#include <WiFi.h>
#include <PubSubClient.h>
#include <GxEPD2_BW.h>
#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>
#include <SHT2x.h>
#include "SparkFunCCS811.h"
//#include <Fonts/FreeSans12pt7b.h>
//#include <Fonts/FreeSans12pt7b_mod.h>
#include <Fonts/FreeSans18pt7b.h>
#include <Fonts/FreeSans24pt7b.h>
#include "GxEPD2_display_selection_new_style.h" // Hier die richtige Display-Auswahldatei einfügen

// Definition der Pins
#define CS_PIN   5
#define DC_PIN   17
#define RST_PIN  16
#define BUSY_PIN 4
#define CCS811_ADDR 0x5A //I2C Addresse für CO2-Sensor
#define PIR_PIN 15

#define EAP_ANONYMOUS_IDENTITY "bee.iot" // Vorbereitung für WLAN Integration
#define EAP_IDENTITY "bee.iot"
#define EAP_PASSWORD "BeeIOT2023!"
#define CUBE_ID "CC4"

SHT2x sht; // Sensorobjekte erstellen
CCS811 myCCS811(CCS811_ADDR); 

char begruessung[] = "Hallo :)"; // Begrüßung beim Hochfahren anzeigen
int ctr = 0;
char line1[] = "Temp";
char line2[] = "CO2";
bool lastMotion = false;
bool room_used = false;
int prog_ctr = 0;
int prog_ctr_room_used = 0;

const char* ssid = "BBS2-ISERV"; // SSID des Berufsschulnetzwerks
const char* mqtt_server = "192.168.221.98"; // IP-Adresse des Raspberry PI (Terminal Niklas Schreiber)

WiFiClient espClient; // WLAN initialisieren
PubSubClient client(espClient);
long lastMsg = 0;
char msg[50];
int value = 0;


void setup() {
  Serial.begin(115200); 
  Wire.begin();  // Standard-I2C-Bus initialisieren (SDA auf GPIO 21, SCL auf GPIO 22)
  Serial.println("Programm beginnt");
  delay(2000);

  if (!sht.begin()) {  // Temperatur- und Luftfeuchtigkeitssensor initialisieren
    Serial.println("Kein GY-21 gefunden!");
    while (1);  // Endlosschleife, wenn der GY-21 nicht gefunden wird
  }
  else {Serial.println("GY-21 gefunden");}

  if (!myCCS811.begin()) { // C02-Sensor initialisieren
    Serial.println("CCS811 nicht gefunden!");
    while (1);  // Endlosschleife, wenn der CCS811 nicht gefunden wird
  }
  else {Serial.println("CCS811 gefunden");}

  display.init(115200, true, 2, false); // Display initialisieren
  Serial.println("Display initialisiert.");
  displayPrint(begruessung); // Zeige die Begrüßung an
  
  pinMode(PIR_PIN, INPUT);
  Serial.println("PIR-Sensor bereit.");
  
  setup_wifi(); // Wlan Methoden aufrufen, um WLan zu initialisieren
  client.setServer(mqtt_server, 1883);
  client.setCallback(callback);
}

void setup_wifi() {
  delay(10);
  Serial.print(F("Verbindung zum Netzwerk aufbauen: ")); // Aufgabe über seriellen Monitor für Anwender
  Serial.println(ssid);
  WiFi.disconnect(true);  
  WiFi.mode(WIFI_STA);    

  WiFi.begin(ssid, WPA2_AUTH_PEAP, EAP_ANONYMOUS_IDENTITY, EAP_IDENTITY, EAP_PASSWORD);  //Verbindung herstellen

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print("."); // "..." Animation bis verbunden, Endlosschleife
  }

  Serial.println("");
  Serial.println("WLan verbunden");
  Serial.println("IP Adresse: ");
  Serial.println(WiFi.localIP());
}

void callback(char* topic, byte* message, unsigned int length) {
  Serial.print("Nachricht erhalten zum Thema: ");
  Serial.print(topic);
  Serial.print(". Nachricht: ");
  String messageTemp;

  for (int i = 0; i < length; i++) {
    Serial.print((char)message[i]);
    messageTemp += (char)message[i];
  }
  Serial.println();
}

void reconnect() {
  while (!client.connected()) {
    Serial.print("Versuche MQTT-Verbindung aufzubauen...");
    if (client.connect(CUBE_ID, "ClimateCube", "ClimateCube")) {
      Serial.println("Verbunden!");
      client.subscribe("esp32/output"); // Anfrage abonnieren
    } else {
      Serial.print("Fehlgeschlagen, Status: ");
      Serial.print(client.state());
      Serial.println("Versuche erneut in 5 Sekunden");
      delay(5000);
    }
  }
}

void displayPrint(const char* textptr) { // Display Print 1-zeilig
  display.setRotation(1); // Display-Rotation
  display.setFont(&FreeSans24pt7b); // Schriftart
  display.setTextColor(GxEPD_BLACK); // Textfarbe
  int16_t tbx, tby; uint16_t tbw, tbh;
  display.getTextBounds(textptr, 0, 0, &tbx, &tby, &tbw, &tbh); // Text zentrieren
  uint16_t x = ((display.width() - tbw) / 2) - tbx;
  uint16_t y = ((display.height() - tbh) / 2) - tby;

  display.setFullWindow();
  display.firstPage();
  do {
    display.fillScreen(GxEPD_WHITE); // Hintergrundfarbe
    display.setCursor(x, y); // Position des Textes
    display.print(textptr); // Text ausgeben
  } while (display.nextPage());
}

void displayPrint2(const char* line1, const char* line2) { // Display Print Funktion 2-zeilig
  display.setRotation(1);
  display.setFont(&FreeSans18pt7b);
  display.setTextColor(GxEPD_BLACK);
  
  int16_t x1, y1;
  uint16_t w1, h1, w2, h2;

  // Berechne die Breite und Höhe für jede Zeile
  display.getTextBounds(line1, 0, 0, &x1, &y1, &w1, &h1);
  display.getTextBounds(line2, 0, 0, &x1, &y1, &w2, &h2);

  // X-Position berechnen, um den Text horizontal zu zentrieren
  uint16_t xLine1 = (display.width() - w1) / 2;
  uint16_t xLine2 = (display.width() - w2) / 2;
  
  // Y-Positionen für beide Zeilen
  uint16_t yLine1 = (display.height() / 2) - (h1 / 2) - 10; // Leichte Verschiebung nach oben
  uint16_t yLine2 = (display.height() / 2) + (h2 / 2) + 20; // Leichte Verschiebung nach unten

  display.setFullWindow();
  display.firstPage();
  do {
    display.fillScreen(GxEPD_WHITE);
    display.setCursor(xLine1, yLine1);
    display.print(line1);
    display.setCursor(xLine2, yLine2);
    display.print(line2);
  } while (display.nextPage());
}

void publishToCubeTopic(const char* suffix, const char* payload) {
  char topic[64];
  snprintf(topic, sizeof(topic), "%s/%s", CUBE_ID, suffix);
  client.publish(topic, payload);
}

void loop() {
  if(!client.connected()) // Zu Beginn Check, ob verbunden mit Terminal
  {
    reconnect(); // reconnect aufrufen, wenn keine Verbindung zum Terminal
  }

  if(prog_ctr > 5750) // ESP ca. alle 24 Stunden neu starten
  {
      ESP.restart();
  }

  if ((prog_ctr-prog_ctr_room_used) >= 20) { // 5 Min keiner im Raum
      room_used = false;
  }

  sht.read(); // GY-21 Werte auslesen
  float temperatureGY21 = sht.getTemperature();
  temperatureGY21 = temperatureGY21-1.0; // Offsetkorrektur des Temperatursensors
  float humidityGY21 = sht.getHumidity();

  myCCS811.readAlgorithmResults(); //CO2 Werte berechnen lassen
  delay(1000); // Zeit zum rechnen geben
  if (myCCS811.dataAvailable()) { // Abfrage, falls Rechnung noch nicht vollständig
    myCCS811.readAlgorithmResults();  // berechnete Werte werden in den globalen Variablen des Sensors gespeichert 
  }
  else {
    Serial.println("CCS811 Error");
  }
  delay(1000);
  int CO2 = myCCS811.getCO2(); // CO2 in lokale Variablen übernehmen

  bool currentMotion = digitalRead(PIR_PIN);
  if (currentMotion && !lastMotion) {
    Serial.println("Neue Bewegung erkannt!");
  }
  else {
    Serial.println("Keine Bewegungsänderung");
  }
  lastMotion = currentMotion; 
  if (currentMotion) {
    room_used = true;
    prog_ctr_room_used = prog_ctr;
  }

  client.loop(); 

  if(ctr>4 && room_used) // Nur jede 4. Abfrage E-Paper Text ändern -> 1 mal pro Minute
  {
    char line1[15], line2[15];
    sprintf(line1, "%.1f`C", temperatureGY21);
    sprintf(line2, "%d ppm CO2", CO2); 
    displayPrint2(line1, line2);
    Serial.println("Display aktualisiert");
    ctr = 0;
  }
  else if (ctr>240) { // wenn Raum inaktiv nur jede Stunde Display ändern
    char line1[15], line2[15];
    sprintf(line1, "%.1f`C", temperatureGY21);
    sprintf(line2, "%d ppm CO2", CO2); 
    displayPrint2(line1, line2);
    Serial.println("Display aktualisiert");
    ctr = 0;
  }
  ctr++;

  Serial.print("Counter: "); Serial.println(ctr);

  char tempString[8]; // String zur Übergabe an Terminal mit MQTT vorbereiten
  dtostrf(temperatureGY21, 1, 2, tempString); // Temperatur in String schreiben
  Serial.print("Temperature: "); // Ausgabe der Temperatur über seriellen Monitor an Laptop
  Serial.println(tempString); 
  publishToCubeTopic("temperature", tempString);

  char humString[8]; // Analog zu Temperatur
  dtostrf(humidityGY21, 1, 2, humString);
  Serial.print("Humidity: ");
  Serial.println(humString);
  publishToCubeTopic("humidity", humString);

  char CO2String[8]; // Analog zu Temperatur
  dtostrf(CO2, 1, 2, CO2String);
  Serial.print("CO2:");
  Serial.println(CO2String);
  publishToCubeTopic("CO2", CO2String);

  char movString[8]; // Analog zu Temperatur
  dtostrf(currentMotion, 1, 2, movString);
  Serial.print("Movement:");
  Serial.println(currentMotion);
  publishToCubeTopic("movement", movString);
  
  delay(10000);
  prog_ctr++; 
}