
//     URL: https://github.com/RobTillaart/SHT2x
/*
  Rui Santos
  Complete project details at https://RandomNerdTutorials.com/esp32-microsd-card-arduino/
  
  This sketch can be found at: Examples > SD(esp32) > SD_Test
*/


#include "Wire.h"
#include "SHT2x.h"
#include "SparkFunCCS811.h" //Click here to get the library: http://librarymanager/All#SparkFun_CCS811
#include <DS3231.h>
#include "FS.h"
#include "SD.h"
#include "SPI.h"
#include <Adafruit_NeoPixel.h> // Bibliothek zum Ansteuern der LEDs

#define LED_PIN 2               // Pin zum ansteuern der LEDs
#define LED_COUNT 2             // Anzahl der anzusteuernden LEDs
Adafruit_NeoPixel strip(LED_COUNT, LED_PIN, NEO_RGB + NEO_KHZ800); // zum Ansteuern der LEDs

DS3231 myRTC;
bool century = false;
bool h12Flag;
bool pmFlag;

uint32_t start;
uint32_t stop;

const int PIR1_PIN = 4;
bool movement = false;

float temperatureVariable = 25.0; //in degrees C
float humidityVariable = 65.0;    //in % relative
#define CCS811_ADDR 0x5A //I2C Address

int prevTime = 0;
int duration = 5000;

SHT2x sht;

CCS811 myCCS811(CCS811_ADDR);


void setup()
{
  Serial.begin(115200);

  Wire.begin();
  sht.begin();

  if (myCCS811.begin() == false)
  {
    Serial.print("CCS811 error. Please check wiring. Freezing...");
    while (1)
      ;
  }

  pinMode(PIR1_PIN, INPUT);

  if(!SD.begin(5)){
    Serial.println("Card Mount Failed");
    return;
  }
  uint8_t cardType = SD.cardType();

  if(cardType == CARD_NONE){
    Serial.println("No SD card attached");
    return;
  }

  strip.begin();                  // LEDs aktivieren
  strip.clear();                  // LEDs standardmäßig auf "aus" setzten
  strip.show();                   // eingestellte LED-Farbe freigeben
}


void loop()
{
 
  if (digitalRead(PIR1_PIN) == 1){
    movement = true;
  }


  if ((millis() - prevTime) > duration) {
    prevTime = millis();

    strip.setPixelColor(0, strip.Color(0, 0, 0));   // LED_1 soll dauerhaft grün leuchten
    strip.setPixelColor(1, strip.Color(0, 0, 0));   // LED_2 soll dauerhaft grün leuchten
    strip.show();                                     // Freigabe der LEDs

    sht.read();

    Serial.println("---------------------------------------");
    temperatureVariable = sht.getTemperature(); //in degrees C
    humidityVariable = sht.getHumidity();       //in % relative
    Serial.print(temperatureVariable);
    Serial.print("\t");
    Serial.println(humidityVariable);
    //delay(1000);

    /*Serial.println("New humidity and temperature:");
    Serial.print("  Humidity: ");
    Serial.print(humidityVariable, 2);
    Serial.println("% relative");
    Serial.print("  Temperature: ");
    Serial.print(temperatureVariable, 2);
    Serial.println(" degrees C");*/
    myCCS811.setEnvironmentalData(humidityVariable, temperatureVariable);

    //Serial.println("Environmental data applied!");


    myCCS811.readAlgorithmResults(); //Dump a reading and wait
    delay(1000);
    //Print data points

  
    if (myCCS811.dataAvailable())
    {
      //Calling readAlgorithmResults() function updates the global tVOC and CO2 variables
      myCCS811.readAlgorithmResults();

      Serial.print("CO2[");
      Serial.print(myCCS811.getCO2());
      Serial.print("] tVOC[");
      Serial.print(myCCS811.getTVOC());
      Serial.print("]");
      
      Serial.println();
    }
    else 
    {
      //If the CCS811 found an internal error, print it.
      Serial.println("CCS811 Error");
    }
    //delay(1000); //Wait for next reading
    Serial.print("Bewegung: ");
    Serial.println(movement);

    	  // then the date
	  Serial.print(myRTC.getDate(), DEC);
	  Serial.print(".");
	
	  // then the month
	  Serial.print(myRTC.getMonth(century), DEC);
	  Serial.print(".");

    Serial.print("20");
    Serial.print(myRTC.getYear(), DEC);
	  Serial.print(' ');

    String dataString = "";
    dataString += "20";
    dataString += String(myRTC.getYear());

    if (myRTC.getMonth(century) < 10){
      dataString += "0";
      dataString += String(myRTC.getMonth(century));
    }
    else dataString += String(myRTC.getMonth(century));

    if (myRTC.getDate() < 10){
      dataString += "0";
      dataString += String(myRTC.getDate());
    }
    else dataString += String(myRTC.getDate());
   


    
  
    //Serial.print(myRTC.getDoW());
	  // and the day of the week
    switch (myRTC.getDoW()){
      case 1:
        Serial.print("Montag");
        //dataString += " Montag,";
        break;
      case 2:
        Serial.print("Dienstag");
        //dataString += " Dienstag,";
        break;
      case 3:
        Serial.print("Mittwoch");
        //dataString += " Mittwoch,";
        break;
      case 4:
        Serial.print("Donnerstag");
        //dataString += " Donnerstag,";
        break;
      case 5:
        Serial.print("Freitag");
        //dataString += " Freitag,";
        break;
      case 6:
        Serial.print("Samstag");
        //dataString += " Samstag,";
        break;
      case 0:
        Serial.print("Sonntag");
        //dataString += " Sonntag,";
        break;
    }
	  Serial.print(" ");


  
	  // Finally the hour, minute, and second
	  Serial.print(myRTC.getHour(h12Flag, pmFlag), DEC);
	  Serial.print(":");
	  Serial.print(myRTC.getMinute(), DEC);
	  Serial.print(":");
	  Serial.print(myRTC.getSecond(), DEC);
    // Display the temperature
	  Serial.print("  T=");
	  Serial.println(myRTC.getTemperature(), 2);
    Serial.println();

    if (myRTC.getHour(h12Flag, pmFlag) < 10){
      dataString += "0";
      dataString += String(myRTC.getHour(h12Flag, pmFlag));
    }
    else dataString += String(myRTC.getHour(h12Flag, pmFlag));

    if (myRTC.getMinute() < 10){
      dataString += "0";
      dataString += String(myRTC.getMinute());
    }
    else dataString += String(myRTC.getMinute());

    if (myRTC.getSecond() < 10){
      dataString += "0";
      dataString += String(myRTC.getSecond());
    }
    else dataString += String(myRTC.getSecond());

    dataString += ", ";


    //dataString += String(myRTC.getTemperature());
    //dataString += ", ";

    dataString += String(myCCS811.getCO2());
    dataString += ", ";
    dataString += String(myCCS811.getTVOC());

    dataString += ", ";
    dataString += String(temperatureVariable);
    dataString += ", ";
    dataString += String(humidityVariable);
    dataString += ", ";
    dataString += String(movement);
    

    dataString += "\n";

    appendFile(SD, "/datalog.txt", dataString.c_str());
    //appendFile(SD, "/datalog.txt", "\n");
    movement = false;
  
  }
}

void readFile(fs::FS &fs, const char * path){
  Serial.printf("Reading file: %s\n", path);

  File file = fs.open(path);
  if(!file){
    Serial.println("Failed to open file for reading");
    return;
  }

  Serial.print("Read from file: ");
  while(file.available()){
    Serial.write(file.read());
  }
  file.close();
}

void writeFile(fs::FS &fs, const char * path, const char * message){
  Serial.printf("Writing file: %s\n", path);

  File file = fs.open(path, FILE_WRITE);
  if(!file){
    Serial.println("Failed to open file for writing");
    return;
  }
  if(file.print(message)){
    Serial.println("File written");
  } else {
    Serial.println("Write failed");
  }
  file.close();
}

void appendFile(fs::FS &fs, const char * path, const char * message){
  Serial.printf("Appending to file: %s\n", path);

  File file = fs.open(path, FILE_APPEND);
  if(!file){
    Serial.println("Failed to open file for appending");
    return;
  }
  if(file.print(message)){
      Serial.println("Message appended");
  } else {
    Serial.println("Append failed");
  }
  file.close();
}


//  -- END OF FILE --

