/*
  https://github.com/sparkfun/SparkFun_CCS811_Arduino_Library
*/



float temperatureVariable = 25.0; //in degrees C
float humidityVariable = 65.0;    //in % relative

#include <Wire.h>
#include "SparkFunCCS811.h" //Click here to get the library: http://librarymanager/All#SparkFun_CCS811

//#define CCS811_ADDR 0x5B //Default I2C Address
#define CCS811_ADDR 0x5A //Alternate I2C Address

CCS811 myCCS811(CCS811_ADDR);

void setup()
{
  Serial.begin(115200);
  Serial.println("CCS811 EnvironmentalReadings Example");

  Wire.begin();

  if (myCCS811.begin() == false)
  {
    Serial.print("CCS811 error. Please check wiring. Freezing...");
    while (1)
      ;
  }

  humidityVariable = 40;     //0 to 100%
  temperatureVariable = 22; // 5C to 70C
  Serial.println("New humidity and temperature:");
  Serial.print("  Humidity: ");
  Serial.print(humidityVariable, 2);
  Serial.println("% relative");
  Serial.print("  Temperature: ");
  Serial.print(temperatureVariable, 2);
  Serial.println(" degrees C");
  myCCS811.setEnvironmentalData(humidityVariable, temperatureVariable);

  Serial.println("Environmental data applied!");


}



void loop()
{
  
  //Randomize the Temperature and Humidity
  
  myCCS811.readAlgorithmResults(); //Dump a reading and wait
  delay(1000);
  //Print data points

  
    if (myCCS811.dataAvailable())
    {
      //Calling readAlgorithmResults() function updates the global tVOC and CO2 variables
      myCCS811.readAlgorithmResults();

      Serial.print("CO2[");
      Serial.print(myCCS811.getCO2());
      Serial.print("] tVOC[");
      Serial.print(myCCS811.getTVOC());
      Serial.print("] millis[");
      Serial.print(millis());
      Serial.print("]");
      Serial.println();
    }
    else 
    {
      //If the CCS811 found an internal error, print it.
      Serial.println("CCS811 Error");
    }
    delay(1000); //Wait for next reading
  
}

