/* Unterbodenbeleuchtung Regenbogen */
#define LED_ROT 23  // Ausgang 23 für rote LED
#define LED_GRUEN 22 // Ausgang 22 für grüne LED
#define LED_BLAU 21 // Ausgang 21 für blaue LED

#define CHANNEL_LED_ROT 0 // PWM-Kanal 0 für rote LED 
#define CHANNEL_LED_GRUEN 1 // PWM-Kanal 1 für gruene LED
#define CHANNEL_LED_BLAU 2 // PWM-Kanal 2 für blaue LED

#define FREQUENCY 1000 // Frequenz f = 1 kHz
#define RESOLUTION 8 // Auflösung: 8 Bit (0 bis 255)

/* Variablen für die duty cycle-Werte (Helligkeit der LEDs)und Farbmischung */
byte dc_led_rot;
byte dc_led_gruen;
byte dc_led_blau;
int fadeZeit = 8;

/* Variable für Abfrage Startsequenz */
boolean ersterDurchlauf = true; 

void setup()
{
 /* Für die drei PWM-Kanäle wird die Frequenz und Auflösung eingestellt */
  ledcSetup(CHANNEL_LED_ROT, FREQUENCY, RESOLUTION);
  ledcSetup(CHANNEL_LED_GRUEN, FREQUENCY, RESOLUTION);
  ledcSetup(CHANNEL_LED_BLAU, FREQUENCY, RESOLUTION);

 /* Den verwendeten Ausgängen des ESP32 werden unterschiedliche PWM-Kanäle zugeordnet */
  ledcAttachPin(LED_ROT, CHANNEL_LED_ROT);
  ledcAttachPin(LED_GRUEN, CHANNEL_LED_GRUEN);
  ledcAttachPin(LED_BLAU, CHANNEL_LED_BLAU);
}

void loop() {
  // Anfragen ob erster Programmdurchlauf
  // Wenn ja, wird die blaue LED hoch gefahren
  if (ersterDurchlauf == true)
{
  //Start mit Blau
  for (dc_led_blau = 0; dc_led_blau < 256; dc_led_blau++)
  {
    ledcWrite(CHANNEL_LED_BLAU, dc_led_blau); // Festlegung des dyty-cycle-Wertes für PWM-Kanal 2 (CHANNEL_LED_BLAU)
    delay(fadeZeit); // Zeitverzögerung fadeZeit in ms
  }
}

ersterDurchlauf = false; //Speichert, dass der erste Durchlauf vollzogen ist

//Wechsel von Blau zu Lila
for (dc_led_rot = 0; dc_led_rot < 256; dc_led_rot++)
{
 ledcWrite(CHANNEL_LED_ROT, dc_led_rot); // Festlegung des dyty-cycle-Wertes für PWM-Kanal 0 (CHANNEL_LED_ROT)
    delay(fadeZeit); 
  }

  // Wechsel von Lila zu Rot
  for (dc_led_blau = 256; dc_led_blau > 0; dc_led_blau--)
  {
    ledcWrite(CHANNEL_LED_BLAU, dc_led_blau); // Festlegung des dyty-cycle-Wertes für PWM-Kanal 2 (CHANNEL_LED_BLAU)
    delay(fadeZeit); 
  }

 //Wechsel von Rot zu Gelb
 for (dc_led_gruen = 0; dc_led_gruen < 256; dc_led_gruen++)
 {ledcWrite(CHANNEL_LED_GRUEN, dc_led_gruen); // Festlegung des dyty-cycle-Wertes für PWM-Kanal 1 (CHANNEL_LED_GRUEN)
    delay(fadeZeit); 
    }

  //Wechsel von Gelb zu Gruen
    for (dc_led_rot = 256; dc_led_rot > 0; dc_led_rot--)
   {
    ledcWrite(CHANNEL_LED_ROT, dc_led_rot);
    delay(fadeZeit); 
  }

  //Wechsel von Gruen zu Petrol
  for (dc_led_blau = 0; dc_led_blau < 256; dc_led_blau++)
  {
    ledcWrite(CHANNEL_LED_BLAU, dc_led_blau);
    delay(fadeZeit); 
  }

  //Wechsel von Petrol zu Blau
  for (dc_led_gruen = 256; dc_led_gruen > 0; dc_led_gruen--)
 {
  ledcWrite(CHANNEL_LED_GRUEN, dc_led_gruen);
  delay(fadeZeit); 
    }
  }
