
#include <Arduino.h>
#include <IRremoteESP8266.h>
#include <IRrecv.h>
#include <IRutils.h>


#define RECV_PIN 34       //Pin an dem der IR-Empfänger angeschlossen ist

IRrecv irrecv(RECV_PIN);  //Objekt erstellen
decode_results results;   

int IRcode=0;             //variable für den Empfangen Tastencode

void setup() 
{
  irrecv.enableIRIn();    // Start the receiver
  Serial.begin(115200);   //Serielle Kommunikation starten
}

void loop() 
{
  if (irrecv.decode(&results))                  //Wenn ein IR-Signal empfangen wurde
  {
    IRcode=(results.value);                     //Das Empfangsignal in der Variable speichern
    
    Serial.print(IRcode, BIN);                  //Gebe es binär im SM aus
    Serial.println("");
    Serial.print(IRcode,HEX);                   //Gebe es hexadezimal im SM aus
    Serial.println("");

    irrecv.resume();                            //IR-Empfänger für den nächsten WErt bereit machen.
    delay(100);
  }
}
