#!/bin/tclsh

set URL "https://cuxd.de/cuxd-ccurm.php?"

set query {}
catch {
  set input $env(QUERY_STRING)
  set pairs [split $input &]
  foreach pair $pairs {
    set key [lindex [split $pair "="] 0]
    if {$key == "cmd" || $key == "version"} {
      if {$pair == "cmd=download"} {
        set download 1
      }
      lappend query $pair
    }
  }
}
set queryURL $URL[join $query "&"]

if {[info exists download] && $download == 1} {
  puts -nonewline "Content-Type: text/html; charset=utf-8\r\n\r\n"
  puts -nonewline "<html><head><meta http-equiv='refresh' content='0; url=$queryURL' /></head><body></body></html>"
} else {
  puts -nonewline "Content-Type: text/plain; charset=utf-8\r\n\r\n"
  catch {
    set newversion [exec /usr/bin/wget -qO- $queryURL]
  }
  if {[info exists newversion]} {
    puts $newversion
  } else {
    puts "n/a"
  }
}

