var CPM = ( CPM || {} );

CPM.svgUtil = ( function () {
    var
     _bBoxSvgTextHeighText = null,
     _bBoxSvgTextHeighTspan = null,
     _bBoxDivElement = null,
     _bBoxSvgElement = null,
     _svgNS = 'http://www.w3.org/2000/svg',
    _xmlNS = 'http://www.w3.org/XML/1998/namespace',
    _createSvgElement = function ( type, params ) {
        var p, value, element, postfix, url, mkId;

        params = params || {};

        postfix = params.postfix;
        url = params.url;
        mkId = params.mkId;

        delete params.postfix;
        delete params.url;
        delete params.mkId;

        // count the svg elements (only for development)
        //  _svgElemeCount += 1;


        element = document.createElementNS( _svgNS, type );
        for ( p in params ) {
            value = params[p];

            switch ( p ) {
                case 'textNode': element.appendChild( document.createTextNode( value ) );
                    break;
                case 'appendTo':
                    value.appendChild( element );
                    break;
                    //case 'id':
                    //    // idComposed = _composeId( item, value, postfix, url, mkId );
                    //    if (idComposed) {
                    //        element.setAttribute('id', idComposed);
                    //    }
                    //    break;
                case 'xml:space':
                    element.setAttributeNS( _xmlNS, p, value );
                    break;
                default: element.setAttribute( p, value );
            }
        }


        return element;
    },
    _createDomElement = function ( type, params ) {
        var p, value,
            element = document.createElement( type );

        for ( p in params ) {
            value = params[p];
            switch ( p ) {
                case 'textNode': element.appendChild( document.createTextNode( value ) );
                    break;
                case 'appendTo': value.appendChild( element );
                    break;
                default: element.setAttribute( p, value );
            }
        }
        return element;
    },
    _createBBoxItems = function ( domNode ) {

        _bBoxDivElement = _createDomElement( 'div', {
            id: 'ID_BBox_DIV',
            style: 'position:absolute; left:0px; top:0px; visibility:hidden;',
            appendTo: domNode
        } );

        _bBoxSvgElement = _createSvgElement( 'svg', {
            'xmlns:xlink': 'http://www.w3.org/1999/xlink',
            id: 'ID_BBox_SVG',
            style: 'pointer-events: none',
            width: '0px',
            height: '0px',
            appendTo: _bBoxDivElement
        } );

        // used to get the TextHeight of SVG elements
        _bBoxSvgTextHeighText = _createSvgElement( 'text', {
            'text-anchor': 'start',
            appendTo: _bBoxSvgElement
        } );

        _bBoxSvgTextHeighTspan = _createSvgElement( 'tspan', {
            appendTo: _bBoxSvgTextHeighText,
            dy: '40px'
        } );

        _bBoxSvgTextHeighTspan.textContent = 'XY';
    },
    _safeFontFamily = function ( fontname ) {
        if ( fontname === 'Arial' ) {
            return 'Arial, Helvetica, sans-serif';
        } else if ( fontname === 'Arial Black' ) {
            return 'Arial Black, Gadget, sans-serif';
        } else if ( fontname === 'Tahoma' ) {
            return 'Tahoma, Geneva, sans-serif';
        } else if ( fontname === 'Lucida Sans Unicode' ) {
            return 'Lucida Sans Unicode, Lucida Grande, sans-serif';
        } else if ( fontname === 'Trebuchet MS' ) {
            return 'Trebuchet MS, Helvetica, sans-serif';
        } else if ( fontname === 'Verdana' ) {
            return 'Verdana, Geneva, sans-serif';
        } else if ( fontname === 'Times New Roman' ) {
            return 'Times New Roman, Times, serif';
        } else if ( fontname === 'Georgia' ) {
            return 'Georgia, Utopia, Charter, serif';
        } else if ( fontname === 'Courier New' ) {
            return 'Courier New, Courier, monospace';
        } else {
            return fontname;
        }
    },
    _setDefaultbBox = function ( fontProps ) {
        var textDecoration,
        text = 'XY';
        _bBoxSvgTextHeighTspan.textContent = text;

        _bBoxSvgTextHeighText.setAttribute( 'font-size', fontProps.Size );
        _bBoxSvgTextHeighText.setAttribute( 'font-style', fontProps.Italic ? 'italic' : 'normal' );
        _bBoxSvgTextHeighText.setAttribute( 'font-weight', fontProps.Weight );
        _bBoxSvgTextHeighText.setAttribute( 'font-family', _safeFontFamily( fontProps.Name ) );

        if ( ( !fontProps.Underline ) && ( !fontProps.StrikeOut ) ) {
            textDecoration = 'none';
        } else {
            textDecoration = ( fontProps.Underline ? 'underline ' : '' ) + ( fontProps.StrikeOut ? 'line-through' : '' );
        }
        _bBoxSvgTextHeighText.setAttribute( 'text-decoration', textDecoration );
    },
    _getTextBBox = function ( fontProps, text ) {
        var bbox;
        if ( text ) {
            _bBoxSvgTextHeighTspan.textContent = text;
        }
        try {
            if ( fontProps.Size ) {
                _bBoxSvgTextHeighText.setAttribute( 'font-size', fontProps.Size );
            }
            if ( fontProps.Weight ) {
                _bBoxSvgTextHeighText.setAttribute( 'font-weight', fontProps.Weight );
            }
            if ( fontProps.Name ) {
                _bBoxSvgTextHeighText.setAttribute( 'font-family', _safeFontFamily( fontProps.Name ) );
            }
            bbox = _bBoxSvgTextHeighText.getBBox();
            //if (bbox.height === 0 && bbox.width !== 0) {
            //    bbox.width = 0; // fix bug in CHROM where space has a width of 45???
            //}
        }
        catch ( err ) {
            //lib.Debug.traceErr( err, 'SVG:getTextBBox() catched exception.' );
        }

        return bbox;
    },
    /*
    * returns offset mouse position Wrt Parent
    * @function
    * @memberOf SHC.Utils
    * @param {evt} Event
    * @param {parent} HTML Element
    * @param {isAdoptToScreen} screen scaling applied or not
    * @param {zoomFactorCB} function callback
    * @returns {point} object - object containing x and y 
    */
    _getMousePoint = function ( evt, parent, isAdoptToScreen, zoomFactorCB ) {
        var matrix = parent.getScreenCTM(),
        point = parent.createSVGPoint(),
        rectPosition = null,
        browserName = navigator.appName,
        target = null,
        zoomFactor = 1;
        if ( isAdoptToScreen && browserName.indexOf( 'Microsoft' ) === -1 ) {
            rectPosition = parent.getBoundingClientRect();
            matrix.e = rectPosition.left;
            matrix.f = rectPosition.top;
        }
        if ( typeof zoomFactorCB === 'function' ) {
            zoomFactor = zoomFactorCB();
        }
        if ( evt.clientX !== undefined && evt.clientX !== null && evt.clientY !== undefined && evt.clientY !== null ) {
            target = evt;
        }
        else if ( evt.changedPointers && evt.changedPointers.length > 0 ) {
            target = evt.changedPointers[0];
        }
        else {
            if ( evt.touches && evt.touches.length > 0 ) {
                target = evt.touches[0];
            }
        }
        if ( target ) {
            point.x = target.clientX;
            point.y = target.clientY;
            point = point.matrixTransform( matrix.inverse() );
            point.x = parseInt( point.x, 10 );
            point.y = parseInt( point.y, 10 );
            if ( isAdoptToScreen && browserName.indexOf( 'Microsoft' ) === -1 && zoomFactor !== 0 ) {
                point.x = point.x / zoomFactor;
                point.y = point.y / zoomFactor;
            }
        }
        return point;
    },
    /**
        * Set attribute of SVG Element.
        * @memberOf PWC.Lib.Canvas.Svg 
        * @param {Object} e Reference of svg element.
        */
    _setAttr = function ( e, a, v ) {
        if ( typeof a === 'object' ) {
            /* apply every attribute individually if an object is passed */
            for ( v in a ) {
                e.setAttribute( v, a[v] );
            }
        }
        else {
            /* set given attribute on node */
            e.setAttribute( a, v );
        }
    },
    _converterBlanks2Nbsps = function ( strValue ) {
        if ( !strValue ) {
            return '';
        }
        return strValue.replace( / /g, '\u00A0' );
    },
    /**
    * Helper for TextWidth for an text according to the font properties and the optional text.
    * If no text is given 'XY' will be used instead.
    * Needed fontProps: Size and Name.
    * Optional fontProps: Italic, Weight, Underline and StrikeOut (defaults: false).
    * @param {Object} fontProps The font properties of the item.
    * @param {String} text The text to check (optional).
    * @returns {Object} the bbox created
    */
    _getTextWidth = function ( fontProps, text ) {
        var canvas, ctx, ctxFont = ( fontProps.Italic ? 'italic ' : 'normal ' ) + fontProps['font-weight'] + ' ' + fontProps['font-size'] + 'px ' + fontProps['font-family'];

        // Initialize the canvas elements used for Converts: TextWidth and TextHeight.
        if ( !ctx ) {
            canvas = CPM.svgUtil.createDomElement( 'canvas', {
            } );
            ctx = canvas.getContext( '2d' );
        }

        text = ( text || 'XY' );
        ctx.font = ctxFont;

        return ctx.measureText( text ).width;
    },
    /**
    * Truncates a text if the length of the text is greater than its max length.
    * @function
    * @memberOf CPM.Common.HelperUtil
    * @param {strLabel} Text to be truncated.
    * @param {maxLimit} Max limit of the text.
    * @param {fontProps} Font properties of the text.
    */
    _truncateLabel = function ( strLabel, maxLimit, fontProps ) {
        var
        ellipsis = '...',
        dotsLen,
        tempString,
        index,
        maxChLength,
        avgChLength,
        maxLen,
        bBoxWidth;

        dotsLen = _getTextWidth( fontProps, ellipsis );
        tempString = strLabel;
        bBoxWidth = _getTextWidth( fontProps, tempString );
        if ( bBoxWidth > maxLimit ) {
            avgChLength = bBoxWidth / strLabel.length;
            maxLen = maxLimit - dotsLen;
            maxChLength = maxLen / avgChLength;
            tempString = strLabel.substring( 0, maxChLength );

            if ( bBoxWidth > maxLen ) {
                do {
                    tempString = tempString.substring( 0, tempString.length - 1 );
                    if ( tempString.length === 0 ) {
                        break;
                    }
                } while ( _getTextWidth( fontProps, tempString ) > maxLen );

                tempString += ellipsis;
            }
            else {
                if ( bBoxWidth < maxLen ) {
                    index = tempString.length + 1;
                    do {
                        tempString = strLabel.substring( 0, index );
                        index++;
                        if ( _getTextWidth( fontProps, tempString ) > maxLen ) {
                            tempString = tempString.substring( 0, tempString.length - 1 );
                            break;
                        }
                    } while ( _getTextWidth( fontProps, tempString ) < maxLen );
                    tempString += ellipsis;
                }
            }
        }
        fontProps = null;
        return tempString;
    },
     /**
    * Test if parent group exists or creates a new group
    * @function
    * @memberOf CPM.svgUtil
    * @param {parentNode} parent SVG element
    * @param {parentGroup} parent group to be appended
    * @returns {nodeValid} boolean depending on presence of parent
    */
    _testParent = function ( parentNode, parentGroup ) {
        //test if of type object
        var nodeValid = false;
        if ( typeof ( parentNode ) === 'object' && (parentNode.nodeName === 'svg' || parentNode.nodeName === 'g' || parentNode.nodeName === 'svg:svg' || parentNode.nodeName === 'svg:g' )) {
            parentNode.appendChild( parentGroup );
            nodeValid = true;
        }
        else {
            if ( typeof ( parentNode ) === 'string' ) {
                //first test if button group exists
                if ( !document.getElementById( parentNode ) ) {
                    parentGroup.setAttributeNS( null, 'id', parentNode );
                    document.documentElement.appendChild( parentGroup );
                    nodeValid = true;
                }
                else {
                    document.getElementById( parentNode ).appendChild( parentGroup );
                    nodeValid = true;
                }
            }
        }
        return nodeValid;
    };

    return {
        createBBoxItems: _createBBoxItems,
        getTextBBox: _getTextBBox,
        setDefaultbBox: _setDefaultbBox,
        createSVG: _createSvgElement,
        getMousePoint: _getMousePoint,
        setAttr: _setAttr,
        createDomElement: _createDomElement,
        converterBlanks2Nbsps: _converterBlanks2Nbsps,
        truncateLabel: _truncateLabel,
        getTextWidth: _getTextWidth,
        testParent: _testParent
    };

} )();