/**
* Creates an instance of TreeControl
* @class
* @desc Class for creating TreeControl
* @constructor
*/
var CPM = ( CPM || {} );
CPM.Tree = function () {
    /**
    * Private members.
    */
    var
    /**    
    * @memberOf TreeControl
    * Holds reference to app
    */
    _app = null,
    /**
    * function to create tree control on DOM
    */
    _createTree = function ( options ) {
        _app = new CPM.App();
        _app.createTreeControl( options );
    },
    /**
    * function to expand all nodes
    */
    _expand = function () {
        _app.expandAll();
    },
    /**
    * function to collapse all nodes
    */
    _collapse = function () {
        _app.collapseAll();
    },
    /**
    * function to create new node
    * @param {nodeData} object
    */
    _createNewNode = function ( nodeData ) {
        _app.createNewNode( nodeData );
    },
    /**
    *  function to create Hierarchy node
    * @param {nodeData} object
    */
    _createHierarchyNode = function ( nodeData ) {
        _app.createHierarchyNode( nodeData );
    },
    /**
    * function to add multiple nodes
    * @param {data} object
    */
    _loadNodes = function ( data ) {
        _app.loadNodes( data );
    },
    /**
    * function to add multiple nodes
    * @param {data} object
    */
    _addNewNodes = function ( data, isBufferData ) {
        _app.addNewNodes( data, isBufferData );
    },
    /**
    * function to remove selected node
    */
    _removeNode = function ( nodeName ) {
        _app.removeNode( nodeName );
    },
    /**
    * function will set callback function that to be called from controller on occuring of event on DOM
    * @param {name} string
    * @param {func} callback
    */
    _on = function ( func ) {
        _app.setCallback( func );
    },
    /**
    * function to update view on resize
    * return bool
    */
    _updateView = function ( height, width ) {
        _app.updateView( height, width );
    },
    /**
    * function to load breadcrumb
     * @param {node} object
    */
    _loadBreadCrumb = function ( node ) {
        _app.loadBreadCrumb( node );
    },
    _handleAlarmData = function ( data ) {
        _app.handleAlarmData( data );
    },
    _handleScreenData = function ( data ) {
        _app.handleScreenData( data );
    },
    _handleLanguageChange = function ( data ) {
        _app.handleLanguageChange( data );
    },
    _disableToolbarButtons = function () {
        _app.disableToolbarButtons();
    },
    _updateProperties = function ( data ) {
        _app.updateProperties( data );
    },
    _handleStyleChange = function ( currentStyle ) {
        _app.handleStyleChange( currentStyle );
    };

    return {
        createTree: _createTree,
        createHierarchyNode: _createHierarchyNode,
        expand: _expand,
        collapse: _collapse,
        createNewNode: _createNewNode,
        loadNodes: _loadNodes,
        removeNode: _removeNode,
        on: _on,
        updateView: _updateView,
        addNewNodes: _addNewNodes,
        loadBreadCrumb: _loadBreadCrumb,
        updateProperties: _updateProperties,
        handleAlarmData: _handleAlarmData,
        handleScreenData: _handleScreenData,
        handleLanguageChange: _handleLanguageChange,
        disableToolbarButtons: _disableToolbarButtons,
        handleStyleChange: _handleStyleChange
    };
};