var CPM = ( CPM || {} );
CPM.searchBox = function () {
    var _backRect, _rectSvg, _line, _textBox, _searchIconSvg, _searchIconRect, _searchIconPath, _closeIconSvg, _closeIconRect, _closeIconPath,

    _setWidth = function ( width, isComboBoxBelow ) {
        var ctrlWidth = width;
        width = ( width / 2 ) - CPM.Enums.Constants.searchBoxLeftPadding;
        if ( isComboBoxBelow ) {
            width = ctrlWidth - 2 * CPM.Enums.Constants.searchComboBoxPadding;
        }
        return width;
    },
    _setAttribute = function ( element, prop, value ) {
        if ( element ) {
            element.setAttribute( prop, value );
        }
    },
    _setIconPath = function ( isExtendedStyle ) {
        var d;
        if ( isExtendedStyle ) {
            d = 'M 21.375 18.882812 L 17.039062 14.542969 C 17.648438 13.503906 18 12.292969 18 11 C 18 7.132812 14.867188 4 11 4 C 7.132812 4 4 7.132812 4 11 C 4 14.867188 7.132812 18 11 18 C 12.355469 18 13.621094 17.613281 14.691406 16.949219 L 19 21.257812 C 19.78125 22.035156 20.953125 22.136719 21.601562 21.484375 C 22.253906 20.828125 22.15625 19.65625 21.375 18.882812 Z M 6 11 C 6 8.238281 8.238281 6 11 6 C 13.761719 6 16 8.238281 16 11 C 16 13.761719 13.761719 16 11 16 C 8.238281 16 6 13.761719 6 11 Z M 6 11 ';
        } else {
            d = 'M11,1 C15.418278,1 19,4.581722 19,9 C19,10.8486595 18.3729536,12.5508646 17.3199461,13.9055298 L21.9142136,18.5 L20.5,19.9142136 L15.9055298,15.3199461 C14.5508646,16.3729536 12.8486595,17 11,17 C6.581722,17 3,13.418278 3,9 C3,4.581722 6.581722,1 11,1 Z M11,2 C7.13400675,2 4,5.13400675 4,9 C4,12.8659932 7.13400675,16 11,16 C14.8659932,16 18,12.8659932 18,9 C18,5.13400675 14.8659932,2 11,2 Z';
        }
        return d;
    };
    this.create = function ( divParent, attrs ) {
        var width, isExtendedStyle, stylePropObj, self = this;
        isExtendedStyle = attrs.currentStyle.includes( CPM.Enums.StyleName.Extended );
        stylePropObj = CPM.StyleFactory.getCurrentStyleProps( attrs.currentStyle );
        width = _setWidth( attrs.width, attrs.isComboBoxBelow );

        // Creating svg & rect to hold the search icon and clear icon to avoid overlapping of input box text value with icons
        _rectSvg = CPM.svgUtil.createSVG( 'svg', {
            x: 0,
            y: 0,
            height: '39',
            width: width,
            style: 'position:absolute; top:0px; left:10px;',
            appendTo: divParent
        } );
        _backRect = CPM.svgUtil.createSVG( 'rect', {
            x: '1',
            y: '1',
            height: '36',
            width: width - 2,
            fill: stylePropObj.TextBox.BackColor,
            stroke: stylePropObj.ComboBox.Stroke,
            'stroke-width': '0.5',
            rx: stylePropObj.ComboBox.Rx,
            style: 'position:absolute; top:0px;',
            appendTo: _rectSvg
        } );
        _line = CPM.svgUtil.createSVG( 'line', {
            x1: '1',
            y1: '37',
            x2: width - 1,
            y2: '37',
            stroke: stylePropObj.TextBox.BottomLineColor,
            'stroke-width': stylePropObj.TextBox.LineStroke,
            appendTo: _rectSvg
        } );
        _textBox = CPM.svgUtil.createDomElement( 'input', {
            id: 'searchBox',
            type: 'text',
            value: '',
            autocomplete: 'off',
            style: 'position:absolute; left:38px; top:10px; height:30px; width:60px;  border:none; outline:none; color:black;',
            appendTo: divParent
        } );
        _textBox.style.width = width - ( 5 * CPM.Enums.Constants.searchComboBoxPadding ) + 'px';
        _textBox.style.backgroundColor = stylePropObj.TextBox.BackColor;
        _textBox.style.color = attrs.currentStyle === CPM.Enums.StyleName.DarkStyle ? 'white' : 'black';

        _searchIconSvg = CPM.svgUtil.createSVG( 'svg', {
            id: 'svg_searchIcon',
            x: 0,
            y: 0,
            height: '35',
            width: stylePropObj.TextBox.SvgWidth,
            style: 'position:absolute; left:12px; top:0px;',
            viewBox: stylePropObj.TextBox.ViewBox,
            appendTo: divParent
        } );

        _searchIconRect = CPM.svgUtil.createSVG( 'rect', {
            id: 'rect_searchIcon',
            x: '0',
            y: stylePropObj.TextBox.IconY,
            height: '37',
            width: stylePropObj.TextBox.SvgWidth,
            fill: stylePropObj.TextBox.BackColor,
            style: 'position:absolute; left:12px; top:0px;',
            appendTo: _searchIconSvg
        } );
        _searchIconPath = CPM.svgUtil.createSVG( 'path', {
            id: 'path_searchIcon',
            d: _setIconPath( isExtendedStyle ),
            fill: stylePropObj.TextBox.IconColor,
            appendTo: _searchIconSvg
        } );
        _closeIconSvg = CPM.svgUtil.createSVG( 'svg', {
            display: 'none',
            id: 'svg_closeIcon',
            x: 0,
            y: 0,
            height: '34',
            width: '26',
            style: 'position:absolute; left:12px; top:0px;',
            viewBox: stylePropObj.TextBox.ViewBox,
            appendTo: divParent
        } );
        _closeIconSvg.style.left = width - CPM.Enums.Constants.searchBoxLeftPadding - 3 + 'px';
        _closeIconRect = CPM.svgUtil.createSVG( 'rect', {
            id: 'rect_closeIcon',
            x: '0',
            y: '-2',
            height: '34',
            width: stylePropObj.TextBox.SvgWidth,
            fill: stylePropObj.TextBox.BackColor,
            style: 'position:absolute; left:12px; top:0px;',
            appendTo: _closeIconSvg
        } );
        _closeIconRect.style.left = width - CPM.Enums.Constants.searchBoxLeftPadding - 3 + 'px';
        _closeIconPath = CPM.svgUtil.createSVG( 'path', {
            id: 'path_closeIcon',
            'stroke-width': stylePropObj.TextBox.StrokeWidth,
            stroke: stylePropObj.TextBox.IconColor,
            d: 'M 13 15 L 7 9 L 19 21 M 13 15 L 7 21 L 19 9',
            fill: stylePropObj.TextBox.IconColor,
            appendTo: _closeIconSvg
        } );
        //Setting top value of elements based on toolbarand url height
         self.updateTopValue( attrs.toolbarHeight + attrs.urlHeight );
        _textBox.addEventListener( 'mouseout', self.hideToolTip );
    };

    this.showInputTextToolTip = function ( position ) {
        var toolTipText, width, ratio, threshold = 6;
        toolTipText = _textBox.value;
        if ( toolTipText !== '' ) {
            width = parseInt( _textBox.style.width, 10 );
            ratio = width / toolTipText.length;
            if ( ratio <= threshold ) {
                CPM.Common.Tooltip.show( position.x, position.y, toolTipText );
            }
        }
    };

    this.hideToolTip = function () {
        CPM.Common.Tooltip.hide();
    };

    this.show = function () {
        if ( _textBox ) {
            _textBox.style.display = 'initial';
            _textBox.disabled = false;
        }
        if ( _rectSvg ) {
            _rectSvg.style.position = 'absolute';
        }
        if ( _searchIconSvg ) {
            _searchIconSvg.style.position = 'absolute';
        }
        if ( _textBox.value !== '' ) {
            _closeIconSvg.style.position = 'absolute';
        } else {
            _closeIconSvg.style.position = 'relative';
        }
    };

    this.hide = function () {
        if ( _textBox ) {
            _textBox.style.display = 'none';
            _textBox.disabled = true;
        }
        // _rectSvg, _searchIconSvg, _closeIconSvg will be stacked on top inside divParent, the display: none will hide the element but will be present in the DOM 
        // and interfere with click of nodes. So changing the position instead of display
        if ( _rectSvg ) {
            _rectSvg.style.position = 'relative';
        }
        if ( _searchIconSvg ) {
            _searchIconSvg.style.position = 'relative';
        }
        if ( _closeIconSvg ) {
            _closeIconSvg.style.position = 'relative';
        }
    };

    this.updateTopValue = function ( top ) {
        var topVal = top + CPM.Enums.Constants.searchBoxTopPadding;
        if ( _textBox ) {
            _textBox.style.top = topVal + 2 + 'px';
        }
        if ( _rectSvg ) {
            _rectSvg.style.top = topVal - 1 + 'px';
        }
        if ( _backRect ) {
            _backRect.style.top = topVal + 'px';
        }
        if ( _line ) {
            _line.style.top = topVal + 7 + 'px';
        }
        if ( _searchIconSvg ) {
            _searchIconSvg.style.top = topVal + 'px';
        }
        if ( _closeIconSvg ) {
            _closeIconSvg.style.top = topVal - 1 + 'px';
        }
    };
    this.showClearIcon = function () {
        _setAttribute( _closeIconSvg, 'display', 'initial' );
        _closeIconSvg.style.position = 'absolute';
    };
    this.hideClearIcon = function () {
        _setAttribute( _closeIconSvg, 'display', 'none' );
        _closeIconSvg.style.position = 'relative';
    };

    this.clearSearch = function () {
        var self = this;
        _textBox.value = '';
        self.hideClearIcon();
        return _textBox.value;
    };

    this.searchText = function () {
        return _textBox.value;
    };

    this.updateWidth = function ( width, isComboBoxBelow ) {
        width = _setWidth( width, isComboBoxBelow );
        _setAttribute( _rectSvg, 'width', width );
        _setAttribute( _backRect, 'width', width - 2 );
        _setAttribute( _line, 'x2', width - 1 );
        _textBox.style.width = width - ( 5 * CPM.Enums.Constants.searchComboBoxPadding ) + 'px';
        _closeIconSvg.style.left = width - CPM.Enums.Constants.searchBoxLeftPadding - 3 + 'px';
    };

    this.updateStyle = function ( stylePropObj, isExtendedStyle, currentStyle ) {
        _textBox.style.backgroundColor = stylePropObj.TextBox.BackColor;
        _textBox.style.color = currentStyle === CPM.Enums.StyleName.DarkStyle ? 'white' : 'black';

        _setAttribute( _backRect, 'fill', stylePropObj.TextBox.BackColor );
        _setAttribute( _backRect, 'stroke', stylePropObj.TextBox.BorderColor );
        _setAttribute( _backRect, 'rx', stylePropObj.TextBox.Rx );

        _setAttribute( _line, 'stroke', stylePropObj.TextBox.BottomLineColor );
        _setAttribute( _line, 'stroke-width', stylePropObj.TextBox.LineStroke );

        _setAttribute( _searchIconSvg, 'width', stylePropObj.TextBox.SvgWidth );
        _setAttribute( _searchIconSvg, 'viewBox', stylePropObj.TextBox.ViewBox );

        _setAttribute( _searchIconRect, 'y', stylePropObj.TextBox.IconY );
        _setAttribute( _searchIconRect, 'fill', stylePropObj.TextBox.BackColor );

        _setAttribute( _searchIconPath, 'd', _setIconPath( isExtendedStyle ) );
        _setAttribute( _searchIconPath, 'fill', stylePropObj.TextBox.IconColor );

        _setAttribute( _closeIconRect, 'fill', stylePropObj.TextBox.BackColor );

        _setAttribute( _closeIconPath, 'stroke-width', stylePropObj.TextBox.StrokeWidth );
        _setAttribute( _closeIconPath, 'stroke', stylePropObj.TextBox.IconColor );
    };
};