var CPM = ( CPM || {} );

CPM.EventManager = function ( parentSvg, eventHandlers, divParent ) {
    'use strict';
    /**
    * Private members.
    */
    var
    /**    
    * @memberOf CPM.Control.EventManager
    * If data is cleaned and gridModel changed before Hammer is loaded, that particular instance of Hammer manager will not be cleared. This flag keeps track of whether hammer instance to be ignored or not.
    */
     _loadHammerEvents = true,
    /**    
    * @memberOf CPM.Control.EventManager
    * Holds information of touch enable for device or not
    */
    _isTouchEnabled = false,
    /**    
    * @memberOf CPM.Control.EventManager
    * Holds reference to area parent
    */
    _areaParent,
     /**    
    * @memberOf CPM.Control.EventManager
    * Holds recent mouse position on mouse move
    */
    _mousPosWrtParentSvg = null,
    /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Holds reference of hammer instance
    */
    _hammerObj = null,
    /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Holds information about pan started or not
    */
    _isPanStarted = false,
    /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Holds information about mouse down state
    */
    _isMouseDown = false,
    /* @memberOf PWC.Components.Grid.EventManager
    * Holds information about mouse down state
    */
    _isMouseRelease = true,
    /**
    /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Holds information about target group
    */
    _targetGroup = null,
     /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Act as timer to skip few pan events on scroll in touch devices
    */
    _timesVPanEvtFired = 0,
    _timesHPanEvtFired = 0,
    _prevPanEvent = null,
    _currPanEvent = null,
    _timesBCPanEvtFired = 0,
    _prevBCPanEvent = null,
    _currBCPanEvent = null,
    _timesCBPanEvtFired = 0,
    _prevCBPanEvent = null,
    _currCBPanEvent = null,
     /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Holds reference to target node
    */
    _targetNode = null,
    /**    
    * @memberOf PWC.Components.Grid.EventManager
    * Holds touch start coordinates. In touch devices touch end coordinates are not coming. use same coordinates for handling row/cell selection
    */
    _touchStartCoordinates,
   _comboBoxStates = { open: false, clicked: false }, // Object of combo box flags to track its state.

   _isComboBoxClicked = false,

     /*
    * Add event listeners to calendar control components
    * @function
    * @memberOf CPM.Control.EventManager
    */
    _addEventListeners = function () {
        //_areaParent = calenderArea.getAreaParent(); 
        divParent.addEventListener( 'mousedown', _eventHandler );
        parentSvg.addEventListener( 'mouseup', _eventHandler );
        parentSvg.addEventListener( 'mouseover', _eventHandler );
        divParent.addEventListener( 'mousemove', _eventHandler );
        parentSvg.addEventListener( 'mouseleave', _eventHandler );
        parentSvg.addEventListener( 'contextmenu', _handleContextMenu );
        parentSvg.addEventListener( 'touchstart', _eventHandler );
        parentSvg.addEventListener( 'touchend', _eventHandler );
        divParent.addEventListener( 'mousewheel', _mouseWheelScroll );
        divParent.addEventListener( 'DOMMouseScroll', _mouseWheelScroll );
        document.body.addEventListener( 'keydown', _handleKeyDown );
        divParent.addEventListener( 'keyup', _handleKeyUp );
        //if ( calenderArea ) {
        //    calenderArea.attachMouseWheelEvent();
        //}
        _addHammerEvents();
        //_isPanEventsAllowedOnShift = viewDefaultProps.areaSettings.isShiftModificationAllowed;
    },
    /*
    * Add hammer event listeners to calendar control components
    * @function
    * @memberOf CPM.Control.EventManager
    */
    _addHammerEvents = function () {
        // require( ['Hammer'], function ( hammer ) {
        var hammer = Hammer;
        if ( parentSvg && _loadHammerEvents ) {
            _hammerObj = new hammer.Manager( parentSvg, { domEvents: true } );
            _hammerObj.add( new hammer.Tap( { event: 'doubletap', taps: 2 } ) );
            _hammerObj.add( new hammer.Tap( { event: 'singletap', taps: 1 } ) );
            _hammerObj.get( 'doubletap' ).recognizeWith( 'singletap' );
            _hammerObj.get( 'singletap' ).requireFailure( 'doubletap' );
            _hammerObj.on( 'doubletap', _doubleClickHandler );
            _hammerObj.on( 'singletap', _singleClickHandler );
            _hammerObj.add( new hammer.Pan( { event: 'pan', pointers: 1, direction: hammer.DIRECTION_ALL, threshold: 1 } ) );
            _hammerObj.on( 'panstart', _panEventHandler );
            _hammerObj.on( 'panup', _panEventHandler );
            _hammerObj.on( 'pandown', _panEventHandler );
            _hammerObj.on( 'panleft', _panEventHandler );
            _hammerObj.on( 'panright', _panEventHandler );
            _hammerObj.on( 'panend', _panEventHandler );
        }
        // } );
    },
    /*
    * Remove event listeners from calendar control components
    * @function
    * @memberOf CPM.Control.EventManager
    */
    _removeEventListeners = function () {
        divParent.removeEventListener( 'mousedown', _eventHandler );
        parentSvg.removeEventListener( 'mouseup', _eventHandler );
        parentSvg.removeEventListener( 'mouseover', _eventHandler );
        divParent.removeEventListener( 'mousemove', _eventHandler );
        parentSvg.removeEventListener( 'mouseleave', _eventHandler );
        parentSvg.removeEventListener( 'contextmenu', _handleContextMenu );
        parentSvg.removeEventListener( 'touchstart', _eventHandler );
        parentSvg.removeEventListener( 'touchend', _eventHandler );
        divParent.removeEventListener( 'mousewheel', _mouseWheelScroll );
        divParent.removeEventListener( 'DOMMouseScroll', _mouseWheelScroll );
        document.body.removeEventListener( 'keydown', _handleKeyDown );
        divParent.removeEventListener( 'keyup', _handleKeyUp );
        if ( _hammerObj ) {
            _hammerObj.off( 'doubletap' );
            _hammerObj.off( 'singletap' );
            _hammerObj.remove( 'doubletap' );
            _hammerObj.remove( 'singletap' );
            _hammerObj.off( 'panstart' );
            _hammerObj.off( 'panup' );
            _hammerObj.off( 'pandown' );
            _hammerObj.off( 'panleft' );
            _hammerObj.off( 'panright' );
            _hammerObj.off( 'panend' );
            _hammerObj.remove( 'pan' );
            _hammerObj.destroy();
            _hammerObj = null;
        } else {
            _loadHammerEvents = false;
        }
    },
    /*
    * disable contextmenu on right click
    * @function
    * @memberOf CPM.Control.EventManager
    * @params{evt}eventObject
    */
    _handleContextMenu = function ( evt ) {
        _targetGroup = null;
        _targetNode = null;
        evt.stopPropagation();
        evt.preventDefault();
        return false;
    },
    /* 
    * Registered as a call back for mousedown,mouseup,touchstart and touchend events
    * @function
    * @memberOf CPM.Control.EventManager
    * @params{evt}eventObject
    */
    _eventHandler = function ( evt ) { 
        if ( evt.type === 'touchstart' || evt.type === 'touchend' ) {
            if ( !_isTouchEnabled ) {
                _isTouchEnabled = true;
            }
            _routeEvent( evt );
        }

        if ( !_isTouchEnabled ) {
            if ( evt.type === 'mousedown' || evt.type === 'mouseup' ) {
                _routeEvent( evt );
            }
            else if ( evt.type === 'mouseover' || evt.type === 'mouseleave' ) {
                _routeEvent( evt );
            }
            else {
                if ( evt.type === 'mousemove' ) {
                    _routeEvent( evt );
                }
            }
        }
    },
    /* 
    * validates event target
    * @function
    * @memberOf CPM.Control.EventManager
    * @params{evt}eventObject
    */
    _validateEventTarget = function ( evt ) {
        var fireEvent = null;
        if ( _targetGroup === null ) {
            fireEvent = _setEventSourceGroup( evt );
        }
        return fireEvent;
    },
    /* 
    * Sets event source group based on mouse position wrto SVG
    * @function
    * @memberOf CPM.Control.EventManager
    * @params{evt}eventObject
    * @params{mousePos}mouse position
    */
    _setEventSourceGroup = function ( evt ) {
        var target = evt.target || evt.srcElement;
        if ( target && ( target.tagName === 'path' || target.tagName === 'rect' ) && target.id.indexOf( 'traverseToParentIcon' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.TraverseToParent;
            _targetNode = target;
        }
        if ( target && ( target.tagName === 'path' || target.tagName === 'rect' ) && target.id.indexOf( 'expandCollapseIcon' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.ExpandCollapse;
            _targetNode = target;
        }
        else if ( ( target && target.tagName === 'rect' && target.id.indexOf( 'nodeBgRect' ) !== -1 ) || ( target && target.tagName === 'text' && target.id.indexOf( 'nodeText' ) !== -1 ) ) {
            _targetGroup = CPM.Enums.EventTarget.NodeTextRect;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'rect' && target.id.indexOf( '_hScrollbar' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.HScrollBar;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'rect' && target.id.indexOf( 'tree_vScrollbar' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.VScrollBar;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'rect' && target.id.indexOf( 'bc_vScrollbar' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.BCVScrollBar;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'rect' && target.id.indexOf( 'cb_vScrollbar' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.CBVScrollBar;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'rect' && target.id.indexOf( '_slider' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.Slider;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'svg' && target.id.indexOf( 'Main_SVG' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.MainSvg;
            _targetNode = target;
        }
        else if ( ( target && target.tagName === 'g' || target && target.tagName === 'svg' || target && target.tagName === 'path' || target && target.tagName === 'rect' ) && target.id.indexOf( 'summaryAlarm' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.SummaryAlarm;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'path' || target.tagName === 'rect' ) && target.id.indexOf( 'NodeImage' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.BCNodeImage;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'path' || target.tagName === 'rect' ) && target.id.indexOf( 'StartImage' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.BCStartImage;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'text' || target.tagName === 'rect' ) && target.id.indexOf( 'NodeText' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.BCNodeText;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'text' || target.tagName === 'rect' || target.tagName === 'path' ) && target.id.indexOf( 'crumbGroup' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.CrumbGroup;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'polygon' || target.tagName === 'rect' ) && target.id.indexOf( 'ExpandAll' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.ExpandAllButton;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'polygon' || target.tagName === 'rect' ) && target.id.indexOf( 'CollapseAll' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.CollapseAllButton;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'polygon' || target.tagName === 'rect' ) && target.id.indexOf( 'FilterButton' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.SearchComboBox;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'svg' || target.tagName === 'path' || target.tagName === 'rect' || target.tagName === 'polygon' ) && target.id.indexOf( 'treeGroup' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.TreeGroupScroll;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'text' || target.tagName === 'path' || target.tagName === 'rect' ) && target.id.indexOf( 'breadcrumbGroup' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.BreadCrumbScroll;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'g' || target.tagName === 'text' || target.tagName === 'path' || target.tagName === 'rect' ) && target.id.indexOf( '_comboBoxElementsGroup' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.ComboBoxScroll;
            _targetNode = target;
        }
        else if ( target && target.tagName === 'INPUT' && target.id.indexOf( 'searchBox' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.SearchInputBox;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'path' || target.tagName === 'rect' || target.tagName === 'svg' ) && target.id.indexOf( '_closeIcon' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.ClearSearchText;
            _targetNode = target;
        }
        else if ( target && ( target.tagName === 'path' || target.tagName === 'rect' || target.tagName === 'svg' ) && target.id.indexOf( '_searchIcon' ) !== -1 ) {
            _targetGroup = CPM.Enums.EventTarget.SearchForText;
            _targetNode = target;
        }
        else {
            if ( eventHandlers.filterComboBox && eventHandlers.filterComboBox.idMatch( target.id ) ) {
                _targetGroup = CPM.Enums.EventTarget.FilterComboBox;
                _targetNode = target;
            }
        }
    },
     //_getMousePos = function ( evt ) {
     //    var point = {};
     //    if ( evt.changedTouches ) {
     //        point.x = evt.changedTouches[0].clientX;
     //        point.y = evt.changedTouches[0].clientY;
     //    } else {
     //        point.x = evt.clientX;
     //        point.y = evt.clientY;
     //    }
     //    return point;
     //},
    /*
    * Function to close combobox if it was in opened state
    */
    _closeComboBox = function () {
        if ( _comboBoxStates.open ) {
            eventHandlers.filterComboBox.onPointerUp(); //Set the combobox button to normal state
            eventHandlers.filterComboBox.closeComboBox();
            _comboBoxStates.open = false;
        }
    },

    /*
    * Function to handle scrollbar events
    * @function
    * @memberOf CPM.Control.EventManager
    * @params{mousePosWrtParentSvg} MousePoint with respect to parent SVG
    * @param {EventObject} evt
    */
    _handleScrollBarEvent = function ( mousePosWrtParentSvg, evt ) {
        var isHandled = true;

        if ( _targetGroup === CPM.Enums.EventTarget.HScrollBar ) {
            eventHandlers.handleHScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
            //calenderArea.hScrollHandler.onScrollClickEvent( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
            //CPM.Layout.StatusBar.toggleStatusBarOff();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.VScrollBar ) {
            eventHandlers.handleVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.BCVScrollBar ) {
            eventHandlers.handleBCVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.CBVScrollBar ) {
            eventHandlers.handleCBVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
        }
        else {
            isHandled = false;
        }

        return isHandled;
    },
    /*
    * Handles left click of mouse
    * @param {evt} eventObject
    */
    _onLeftMouseClick = function ( evt ) {
        var mousePosWrtParentSvg = _mousPosWrtParentSvg, node;
        _validateEventTarget( evt );
        if ( _targetGroup === CPM.Enums.EventTarget.HScrollBar ) {
            eventHandlers.handleHScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.VScrollBar ) {
            eventHandlers.handleVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.BCVScrollBar ) {
            eventHandlers.handleBCVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.CBVScrollBar ) {
            eventHandlers.handleCBVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.BCNodeImage ) {
            eventHandlers.displayImmediateChildren( '', _targetNode, true );
            eventHandlers.setBgColor( evt.type, _targetNode );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.BCNodeText || _targetGroup === CPM.Enums.EventTarget.BCStartImage ) {
            node = eventHandlers.getBCNode( _targetNode );
            eventHandlers.onURLClick( node );
            if ( _targetGroup === CPM.Enums.EventTarget.BCStartImage ) {
                eventHandlers.setBgColor( evt.type, _targetNode );
            }
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.SummaryAlarm ) {
            node = eventHandlers.getNodeData( _targetNode );
            if ( node ) {
                eventHandlers.sendSummaryInfo( node );
                eventHandlers.selectNode( node, false, false );
            }
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.ExpandCollapse ) {
            node = eventHandlers.getNodeData( _targetNode );
            if ( node ) {
                eventHandlers.toggleVisibility( node, undefined, false );
            }
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.CrumbGroup ) {
            node = eventHandlers.getCrumbNode( _targetNode );
            eventHandlers.setSelectedFromBC( node );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.FilterComboBox ) {
            _isComboBoxClicked = true;
            if ( _comboBoxStates.clicked && _comboBoxStates.open ) {
                _comboBoxStates.open = eventHandlers.filterComboBox.onPointerDown( _targetNode.id );
                eventHandlers.filterComboBox.onPointerUp();//Set the combobox button to normal state when the combobox is closed
                _comboBoxStates.clicked = false;
            } else {
                _comboBoxStates.open = eventHandlers.filterComboBox.onPointerDown( _targetNode.id );
                _comboBoxStates.clicked = true;
            }
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.ExpandAllButton ) {
            eventHandlers.expandAll();
            eventHandlers.updateToolbarColor( evt );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.CollapseAllButton ) {
            eventHandlers.collapseAll();
            eventHandlers.updateToolbarColor( evt );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.SearchComboBox ) {
            eventHandlers.toggleFilterButton();
            eventHandlers.updateToolbarColor( evt );
            _closeComboBox();
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.ClearSearchText ) {
            eventHandlers.clearSearch( false );
        }
        else if ( _targetGroup === CPM.Enums.EventTarget.SearchForText ) {
            eventHandlers.searchForText( true );
        }
        else {
            if ( _targetGroup !== CPM.Enums.EventTarget.CBVScrollBar ) {
                _closeComboBox();
            }
        }
        if ( _isTouchEnabled ) {
            _touchStartCoordinates = mousePosWrtParentSvg;
        }
        _isMouseDown = true;
    },
    /* 
    *routes event based on event type and based on validation
    * @function
    * @memberOf CPM.Control.EventManager
    * @params{evt}eventObject
    */
    _routeEvent = function ( evt ) {
        var mousePosWrtParentSvg = CPM.svgUtil.getMousePoint( evt, parentSvg ), node;
        _mousPosWrtParentSvg = mousePosWrtParentSvg;
        switch ( evt.type ) {
            case 'mousedown':
            case 'touchstart':
                _isMouseRelease = false;
                if ( evt.type === 'mousedown' && ( evt.which === 3 || evt.button === 1 ) ) {// Handle Right mouse Click
                    return;
                }
                else {
                    _onLeftMouseClick( evt );
                }
                _targetGroup = null;
                _targetNode = null;
                break;
            case 'mouseup':
            case 'touchend':
                _isMouseRelease = true;
                if ( _isPanStarted ) {
                    _isPanStarted = false;
                }
                else {
                    _validateEventTarget( evt );
                    if ( !_handleScrollBarEvent( mousePosWrtParentSvg, evt ) ) {
                        if ( _targetGroup === CPM.Enums.EventTarget.BCNodeImage ) {
                            eventHandlers.displayImmediateChildren( '', _targetNode, true );
                            eventHandlers.setBgColor( evt.type, _targetNode );
                        }
                        else if ( _targetGroup === CPM.Enums.EventTarget.BCNodeText || _targetGroup === CPM.Enums.EventTarget.BCStartImage ) {
                            node = eventHandlers.getBCNode( _targetNode );
                            eventHandlers.onURLClick( node );
                        }
                        else if ( _targetGroup === CPM.Enums.EventTarget.ExpandAllButton ) {
                            eventHandlers.updateToolbarColor( evt );
                            eventHandlers.expandAll();
                        }
                        else {
                            if ( _targetGroup === CPM.Enums.EventTarget.CollapseAllButton ) {
                                eventHandlers.updateToolbarColor( evt );
                                eventHandlers.collapseAll();
                        }
                    }
                }
                    _targetGroup = null;
                    _targetNode = null;
            }
                _isMouseDown = false;

                break;
            case 'mouseover':
                _validateEventTarget( evt );
                if ( _targetGroup === CPM.Enums.EventTarget.BCNodeImage || _targetGroup === CPM.Enums.EventTarget.BCStartImage ) {
                    eventHandlers.setBgColor( evt.type, _targetNode );
                    if ( _targetNode.id.indexOf( '_NodeText' ) !== -1 ) {
                        eventHandlers.displayImmediateChildren( '', _targetNode );
                }
                }
                else if ( _targetGroup === CPM.Enums.EventTarget.ExpandAllButton || _targetGroup === CPM.Enums.EventTarget.CollapseAllButton || _targetGroup === CPM.Enums.EventTarget.SearchComboBox ) {
                    eventHandlers.updateToolbarColor( evt );
                }
                else if ( _targetGroup !== CPM.Enums.EventTarget.BreadCrumbScroll || _targetGroup !== CPM.Enums.EventTarget.CrumbGroup ) {
                    eventHandlers.unloadBreadCrumb();
                }
                else {
                    if ( ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.HScrollBar ) || ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.VScrollBar ) || ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.BCVScrollBar ) || ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.CBVScrollBar ) ) {
                        _isMouseRelease = true;
                }
            }
                _targetGroup = null;
                break;
            case 'mousemove':
                _validateEventTarget( evt );
                if ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.VScrollBar ) {
                    eventHandlers.handleVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
                }
                else if ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.BCVScrollBar ) {
                    eventHandlers.handleBCVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
                }
                else if ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.CBVScrollBar ) {
                    eventHandlers.handleCBVScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
                }
                else if ( !_isMouseRelease && _targetGroup === CPM.Enums.EventTarget.HScrollBar ) {
                    eventHandlers.handleHScrollBar( mousePosWrtParentSvg, _targetGroup, evt, _targetNode );
                }
                else if ( _targetGroup === CPM.Enums.EventTarget.SearchInputBox ) {
                    eventHandlers.showInputTextToolTip( _getMousePos() );
                }
                else {
                    if ( _targetGroup === CPM.Enums.EventTarget.FilterComboBox ) {
                        eventHandlers.filterComboBox.onPointerMove( _targetNode.id );
                        eventHandlers.showToolTip( _targetNode, _getMousePos( evt ) );
                }
            }
                _targetGroup = null;
                break;
            case 'mouseleave':
                _validateEventTarget( evt );
               if ( _targetGroup === CPM.Enums.EventTarget.MainSvg ) {
                    eventHandlers.updateNodeImage();
                    _closeComboBox();
               }
               else {
                    if ( _targetGroup === CPM.Enums.EventTarget.BCNodeImage ) {
                        eventHandlers.setBgColor( evt.type, _targetNode );
               }
            }
                _targetGroup = null;
                break;
            default:
                break;
        }
    },
        /*
        * Handles scroll events 
        * @param {currPanEvent} currentPanEvent object
        * @param {timesPanEvtFired} timesPanEventFired object
        */
    _scrollbarHandler = function ( currPanEvent, timesPanEvtFired ) {
        var swipeVelocity, length;
        swipeVelocity = Math.abs( currPanEvent.overallVelocity );
        //If swipe velocity is more than 1, then scroll in the respective direction 3 times
        if ( swipeVelocity > 1 ) {
            length = Math.floor( swipeVelocity * 3 );
            for ( var i = 0; i < length; i++ ) {
                _fireEvent( currPanEvent, _targetGroup );
        }
            return;
    }
        if ( currPanEvent.type === CPM.Enums.EventType.panup || currPanEvent.type === CPM.Enums.EventType.pandown ) {
            if ( timesPanEvtFired < 5 ) {
                timesPanEvtFired++;
            } else {
                if ( timesPanEvtFired === 5 ) {
                    _scrollOnPan( _targetGroup );
            }
        }
        } else {
            if ( currPanEvent.type === CPM.Enums.EventType.panleft || currPanEvent.type === CPM.Enums.EventType.panright ) {
                if ( timesPanEvtFired < 5 ) {
                    timesPanEvtFired++;
                } else {
                    if ( timesPanEvtFired === 5 ) {
                        _scrollOnPan( CPM.Enums.EventTarget.TreeGroupScroll );
                }
            }
        }
    }
    },
        /*
        * Registered as a callback for pan events
        * @param {EventObject} evt
        */
    _panEventHandler = function ( evt ) {
        var mousePosWrtParentSvg = CPM.svgUtil.getMousePoint( evt, parentSvg );
        if ( evt.type === CPM.Enums.EventType.panstart ) {
            _isPanStarted = true;
    }
        evt.preventDefault();

        if ( _isPanStarted && ( evt.type === CPM.Enums.EventType.panstart || evt.type === CPM.Enums.EventType.panleft || evt.type === CPM.Enums.EventType.panright || evt.type === CPM.Enums.EventType.panup || evt.type === CPM.Enums.EventType.pandown ) ) {

            if ( !_handleScrollBarEvent( mousePosWrtParentSvg, evt ) ) {
                if ( _targetGroup === CPM.Enums.EventTarget.TreeGroupScroll || _targetGroup === CPM.Enums.EventTarget.ExpandCollapse || _targetGroup === CPM.Enums.EventTarget.NodeTextRect ) {
                    _currPanEvent = evt;
                    _scrollbarHandler( _currPanEvent, _timesHPanEvtFired );
                }
                else if ( _targetGroup === CPM.Enums.EventTarget.BreadCrumbScroll ) {
                    _currBCPanEvent = evt;
                    _scrollbarHandler( _currBCPanEvent, _timesBCPanEvtFired );
                }
                else {
                    if ( _targetGroup === CPM.Enums.EventTarget.ComboBoxScroll ) {
                        _currCBPanEvent = evt;
                        _scrollbarHandler( _currCBPanEvent, _timesCBPanEvtFired );
                }
            }
        }
        }

        else {
            if ( evt.type === CPM.Enums.EventType.panend ) {

                if ( !_handleScrollBarEvent( mousePosWrtParentSvg, evt ) ) {
                    if ( _targetGroup === CPM.Enums.EventTarget.TreeGroupScroll || _targetGroup === CPM.Enums.EventTarget.ExpandCollapse || _targetGroup === CPM.Enums.EventTarget.NodeTextRect ) {
                        _currPanEvent = _prevPanEvent = null;
                        _timesVPanEvtFired = 0;
                        _timesHPanEvtFired = 0;
                    }
                    else if ( _targetGroup === CPM.Enums.EventTarget.BreadCrumbScroll ) {
                        _timesBCPanEvtFired = 0;
                        _prevBCPanEvent = _currBCPanEvent = null;
                    }
                    else {
                        if ( _targetGroup === CPM.Enums.EventTarget.ComboBoxScroll ) {
                            _timesCBPanEvtFired = 0;
                            _prevCBPanEvent = _currCBPanEvent = null;
                    }
                }
            }
                _targetGroup = null;
                _targetNode = null;
        }
    }
    },

        /*
        * Function to perform tree or breadcrumb scroll for pan events
        * @function
        * @memberOf CPM.Control.EventManager
        * @params{target}target element
        */
        _scrollOnPan = function ( target ) {
            if ( target === CPM.Enums.EventTarget.TreeGroupScroll ) {
                if ( _prevPanEvent ) {
                    if ( ( _currPanEvent.type === CPM.Enums.EventType.panup || _currPanEvent.type === CPM.Enums.EventType.pandown ) && ( Math.abs( _currPanEvent.deltaY - _prevPanEvent.deltaY ) > 3 ) ) {
                        _timesVPanEvtFired = 0;
                        _fireEvent( _currPanEvent, target );
                    }
                    else {
                        if ( ( _currPanEvent.type === CPM.Enums.EventType.panleft || _currPanEvent.type === CPM.Enums.EventType.panright ) && ( Math.abs( _currPanEvent.deltaX - _prevPanEvent.deltaX ) > 3 ) ) {
                            _timesHPanEvtFired = 0;
                            _fireEvent( _currPanEvent, target );
                    }
                }
                    _prevPanEvent = _currPanEvent;
                } else {
                    _prevPanEvent = _currPanEvent;
            }
            } else if ( target === CPM.Enums.EventTarget.BreadCrumbScroll ) {
                if ( _prevBCPanEvent ) {
                    if ( ( Math.abs( _currBCPanEvent.deltaY - _prevBCPanEvent.deltaY ) > 3 ) ) {
                        _timesBCPanEvtFired = 0;
                        _fireEvent( _currBCPanEvent, target );
                }
                    _prevBCPanEvent = _currBCPanEvent;
                } else {
                    _prevBCPanEvent = _currBCPanEvent;
            }
            } else {
                if ( target === CPM.Enums.EventTarget.ComboBoxScroll ) {
                    if ( _prevCBPanEvent ) {
                        if ( ( Math.abs( _currCBPanEvent.deltaY - _prevCBPanEvent.deltaY ) > 3 ) ) {
                            _timesCBPanEvtFired = 0;
                            _fireEvent( _currCBPanEvent, target );
                    }
                        _prevCBPanEvent = _currCBPanEvent;
                    } else {
                        _prevCBPanEvent = _currCBPanEvent;
                }
            }
        }
    },

        /*
        * Function to perform tree or breadcrumb scroll for mousewheel events
        * @function
        * @memberOf CPM.Control.EventManager
        * @params{evt}event
        */
        _mouseWheelScroll = function ( evt ) {
            var delta = 0, mozDelta = 0, direction, isShiftKey = evt.shiftKey;

            if ( ( evt.wheelDelta !== undefined || evt.detail !== undefined ) ) {
                delta = evt.wheelDelta;
                mozDelta = evt.detail;
                if ( delta < 0 || mozDelta > 0 ) {
                    direction = true;
                }
                else {
                    if ( delta > 0 || mozDelta < 0 ) {
                        direction = false;
                }
            }
        }
            if ( !isShiftKey && ( evt.target.id.indexOf( 'breadcrumbGroup' ) !== -1 || evt.target.id.indexOf( 'bc_vScrollbar' ) !== -1 ) ) {
                eventHandlers.onScroll( direction, 'bcVScroll' );
            } else if ( !isShiftKey && ( evt.target.id.indexOf( 'treeGroup' ) !== -1 || evt.target.id.indexOf( 'tree_vScrollbar' ) !== -1 ) ) {
                eventHandlers.onScroll( direction, 'VScroll' );
            } else if ( isShiftKey && ( evt.target.id.indexOf( 'treeGroup' ) !== -1 || evt.target.id.indexOf( 'hScrollbar' ) !== -1 ) ) {
                eventHandlers.onScroll( direction, 'HScroll' );
            } else {
                if ( isShiftKey && ( evt.target.id.indexOf( '_comboBoxElementsGroup' ) !== -1 || evt.target.id.indexOf( 'cb_vScrollbar' ) !== -1 ) ) {
                    eventHandlers.onScroll( direction, 'cbVScroll' );
            }
        }
            evt.preventDefault();
    },

        /*
        * Function to perform tree or breadcrumb scroll for pan events
        * @function
        * @memberOf CPM.Control.EventManager
        * @params{evt}event
        * @params{target}breadcrumb or treegroup element
        */
        _fireEvent = function ( evt, target ) {
            if ( target === CPM.Enums.EventTarget.BreadCrumbScroll ) {
                if ( evt.type === CPM.Enums.EventType.panup ) {
                    eventHandlers.onScroll( true, 'bcVScroll' );
                } else {
                    if ( evt.type === CPM.Enums.EventType.pandown ) {
                        eventHandlers.onScroll( false, 'bcVScroll' );
                }
            }
            } else if ( target === CPM.Enums.EventTarget.TreeGroupScroll ) {
                if ( evt.type === CPM.Enums.EventType.panup ) {
                    eventHandlers.onScroll( true, 'VScroll' );
                } else if ( evt.type === CPM.Enums.EventType.pandown ) {
                    eventHandlers.onScroll( false, 'VScroll' );
                } else if ( evt.type === CPM.Enums.EventType.panleft ) {
                    eventHandlers.onScroll( true, 'HScroll' );
                } else {
                    if ( evt.type === CPM.Enums.EventType.panright ) {
                        eventHandlers.onScroll( false, 'HScroll' );
                }
            }
            } else {
                if ( target === CPM.Enums.EventTarget.ComboBoxScroll ) {
                    if ( evt.type === CPM.Enums.EventType.panup ) {
                        eventHandlers.onScroll( true, 'cbVScroll' );
                    } else {
                        if ( evt.type === CPM.Enums.EventType.pandown ) {
                            eventHandlers.onScroll( false, 'cbVScroll' );
                    }
                }
            }
        }
    },

        /*
        * Registered as a callback on single tap 
        * @param {EventObject} evt
        */
        _singleClickHandler = function ( evt ) {
            var node;
            _validateEventTarget( evt );
            if ( _targetGroup === CPM.Enums.EventTarget.TraverseToParent ) {
                node = eventHandlers.getNodeData( _targetNode );
                if ( node ) {
                    eventHandlers.setNavigatedNodeId( node.ParentId );
                    node = eventHandlers.getParent( node.ParentId );
                    eventHandlers.selectNode( node, false, false );
                }
                _closeComboBox();
            } else if ( _targetGroup === CPM.Enums.EventTarget.NodeTextRect ) {
                if ( _isComboBoxClicked ) {
                    _isComboBoxClicked = false;
                    return;
                }
                node = eventHandlers.getNodeData( _targetNode );
                if ( node ) {
                    eventHandlers.selectNode( node, false, false );
                } else {
                    eventHandlers.unloadBreadCrumb();
                }
                _closeComboBox();
            } else if ( _targetGroup === CPM.Enums.EventTarget.SummaryAlarm ) {
                node = eventHandlers.getNodeData( _targetNode );
                if ( node ) {
                    eventHandlers.sendSummaryInfo( node );
                    eventHandlers.selectNode( node, false, false );
                }
                _closeComboBox();
            }
            else {
                if ( _targetGroup === CPM.Enums.EventTarget.CrumbGroup ) {
                    node = eventHandlers.getCrumbNode( _targetNode );
                    eventHandlers.setSelectedFromBC( node );
                    _closeComboBox();
                }
            }
            _targetGroup = null;
            _targetNode = null;
            evt.preventDefault();
    },
        /*
        * Registered as a callback on double tap 
        * @param {EventObject} evt
        */
        _doubleClickHandler = function ( evt ) {

            var node;
            _validateEventTarget( evt );
            if ( _targetGroup === CPM.Enums.EventTarget.NodeTextRect ) {
                node = eventHandlers.getNodeData( _targetNode );
                if ( node ) {
                    eventHandlers.toggleVisibility( node, undefined, true );
            }
            }
            else if ( _targetGroup === CPM.Enums.EventTarget.SummaryAlarm ) {
                node = eventHandlers.getNodeData( _targetNode );
                if ( node ) {
                    eventHandlers.sendSummaryInfo( node );
                    eventHandlers.selectNode( node, false, false );
            }
            } else {
                if ( _targetGroup !== CPM.Enums.EventTarget.CBVScrollBar ) {
                    _closeComboBox();
            }
        }
            _targetGroup = null;
            _targetNode = null;
            evt.preventDefault();

    },
        /*
        * Handle key actions(keyboard events)
        * @param {evt} event 
        */
        _handleKeyDown = function ( evt ) {
            var preventDefault = true,
            target = evt.target || evt.srcElement;

            if ( target && target.tagName === 'INPUT' && target.id.indexOf( 'searchBox' ) !== -1 ) {
                preventDefault = false;
        }
            if ( evt.keyCode === 40 || evt.keyCode === 34 ) { // Down arrow keyCode = 40, Page Down keyCode = 34
                eventHandlers.onScroll( true, 'VScroll', evt );
            } else {
                if ( evt.keyCode === 38 || evt.keyCode === 33 ) { // Up arrow keyCode = 38, Page Up keyCode = 33
                    eventHandlers.onScroll( false, 'VScroll', evt );
                }
                else {
                    if ( evt.keyCode === 13 && !preventDefault ) {  // For Search box ENTER key press
                        eventHandlers.handleSearchText( evt.target.value );
                        evt.target.blur();
                }
            }
        }
            if ( preventDefault ) {
                evt.preventDefault();
        }
    },

        _handleKeyUp = function ( evt ) {
            if ( evt.target.value !== undefined && evt.target.value !== '' ) {
                eventHandlers.showClearIcon();
            } else {
                eventHandlers.hideClearIcon();
        }
    },

        _getMousePos = function () {
            return _mousPosWrtParentSvg;
    },
        /*
        * Cleans EventManager
        * @function
        * @memberOf CPM.Control.EventManager
        */
        _clean = function () {
            _removeEventListeners();
            _areaParent = null;
            _mousPosWrtParentSvg = null;
            _targetGroup = null;
            _targetNode = null;
    };
    return {
            addEventListeners: _addEventListeners,
            handleKeyDown: _handleKeyDown,
            getMousePos: _getMousePos,
            clean: _clean
    };
};