
var CPM = ( CPM || {} );
CPM.Enums = ( CPM.Enums || {} );
CPM.Enums.DataRecievedType = {
    NodeCount: 1010,
    RootOrNode: 1003,
    Hierarchies: 1005,
    SetViewPort: 1006,
    ExpandAll: 1007,
    Scroll: 1008,
    BreadCrumbData: 1011,
    AlarmSummary: 1012,
    ExpandAllForNode: 1013,
    ScreenWindowNode: 1014,
    LanguageChange: 1015
};
/**
* Creates an ENUM of different object count attributes
* @enum
* @desc Enum representing different types of object count attributes
*/
CPM.Enums.ObjectCountAttributes = {
    Requested: 0,
    TreeOrList: 1,
    SystemId: 2,
    ObjectId: 3,
    SelectedNode: 4,
    NameFilter: 5,
    PropertyFilter: 6,
    LanguageId: 7,
    BrowsingMode: 8,
    SortingMode: 9,
    SortByAttribute: 10
};
/**
* Creates an ENUM of different Data attributes
* @enum
* @desc Enum representing different types of Data attributes
*/
CPM.Enums.DataAttributes = {
    Requested: 0,
    TreeOrList: 1,
    StartIndex: 2,
    EndIndex: 3
};
/**
* Creates an ENUM of different types of views
* @enum
* @desc Enum representing different types of views(tree/list)
*/
CPM.Enums.View = {
    Tree: 0,
    List: 1,
    ViewPort: 4
};
/**
* Creates an ENUM of different types of languages
* @enum
* @desc Enum representing different types of languages
*/
CPM.Enums.Language = {
    English: 1033
};
/**
* Creates an ENUM of different types of BrowsingModes
* @enum
* @desc Enum representing different types of BrowsingModes
*/
CPM.Enums.BrowsingMode = {
    Hierarchies: 3,
    ViewRoot: 4,
    ViewNode: 5,
    ExpandAll: 6,
    CollapseAll: 7,
    Scroll: 5,
    AlarmSummary: 9,
    ScreenWindow: 11,
    AlarmOrSHC: 10,
    ScreenFilter: 13,
    ExpandNode: 12,
    RootNode: 15
};

CPM.Enums.Constants = {
    iconToIconGap: 19,
    iconToIconToTextGap: 42,
    horizontalgap: 15,
    polyDimW: 9,
    polyDimH: 5,
    iconDim: 18,
    Gray2: '#64646A',
    topPadding: 8,
    textLeftPadding: 25,
    toolbarHeight: 55,
    urlHeight: 40,
    textBottomPadding: 2,
    toolbarPadding: 4,
    stopColor1: '#F2F4FF',
    stopColor2: '#91939A',
    stopColor3: '#66676C',
    btnBorderColor1: 'rgba(100,100,106,1)',
    btnBorderColor2: 'rgba(100,100,106,0.5)',
    topPaddingAlarmIcon: 5,
    alarmIconWidth: 30,
    alarmIconLeftPadding: 3,
    searchBackRectHeight: 60,
    searchBoxLeftPadding: 15,
    searchBoxTopPadding: 13,
    searchComboBoxMinWidth: 160,
    searchComboBoxPadding: 10
};
CPM.Enums.ToolbarButtons = {
    ExpandAll: 'ExpandAll',
    CollapseAll: 'CollapseAll',
    Filter: 'Filter'
};
CPM.Enums.EventTarget = {
    ExpandCollapse: 0,
    NodeTextRect: 1,
    HScrollBar: 3,
    VScrollBar: 4,
    Slider: 5,
    MainSvg: 6,
    BCVScrollBar: 7,
    SummaryAlarm: 8,
    TreeGroupScroll: 9,
    BreadCrumbScroll: 10,
    BCNodeImage: 11,
    BCNodeText: 12,
    BCStartImage: 13,
    CrumbGroup: 14,
    ExpandAllButton: 15,
    CollapseAllButton: 16,
    FilterComboBox: 17,
    CBVScrollBar: 18,
    ComboBoxScroll: 19,
    TraverseToParent: 20,
    SearchComboBox: 21,
    ClearSearchText: 22,
    SearchInputBox: 23,
    SearchForText: 24 
};
CPM.Enums.EventType = {
    panup: 'panup',
    pandown: 'pandown',
    panleft: 'panleft',
    panright: 'panright',
    panstart: 'panstart',
    panend: 'panend'
};
CPM.Enums.CompanionTypes = {
    Alarm: 1,
    'Calendar Control': 2,
    ScreenWindow: 3
};
CPM.Enums.Filter = {
    None: 0,
    NodeWithPendingAlarms: 1,
    NodeWithVisualization: 2
};
CPM.Enums.ComboGradients = {
    IOFieldNormal: 0,
    ButtonNormal: 1,
    ButtonPressed: 2
};
CPM.Enums.StyleName = {
    Extended: 'ExtendedStyle',
    DarkStyle: 'FlatStyle_Dark'
};
CPM.Enums.NavigationType = {
    Static: 0,
    Dynamic: 1
};