var CPM = ( CPM || {} );

CPM.breadcrumb = function () {
    var _urlPartGroup, _top, _nodeHeight, _urlHeight, _borderWidth, _strokeWidth, _font, _urlData, _viewPortData, _crumbData,
        _prevNode, _bCSvgGroup, _urlGroup, _treeGroup, _startImgRectGroup, _stylePropObj, _pathBackRect, _pathRect, _urlBottomLine,

    _removeBgColor = function ( evt ) {
        var target = evt.target || evt.srcElement,
            idArray = target.id.split( '_' ), idx, nodeImageRect, nodeImagePath;
        idx = parseInt( idArray[idArray.length - 1] );
        if ( target.id.indexOf( 'NodeURL' ) !== -1 ) {
            nodeImageRect = _treeGroup.getElementById( 'rect_NodeImage_' + idx );
            if ( nodeImageRect ) {
                nodeImageRect.setAttribute( 'fill', 'transparent' );
                nodeImageRect.setAttribute( 'stroke-width', '0px' );
            }
            nodeImagePath = _treeGroup.getElementById( 'path_NodeImage_' + idx );
            if ( nodeImagePath ) {
                nodeImagePath.setAttribute( 'stroke', _stylePropObj.BreadCrumb.IconColor );
            }
        } else {
            if ( target.id.indexOf( 'StartImage' ) !== -1 && _urlData.length !== _viewPortData.length && _startImgRectGroup ) {
                _startImgRectGroup.setAttribute( 'fill', 'transparent' );
                _startImgRectGroup.setAttribute( 'stroke-width', '0px' );
            }
        }

    };

    this.createBCRects = function ( parent, urlGroup, data ) {
        _top = data.Top;
        _nodeHeight = data.nodeHeight;
        _urlHeight = data.urlHeight;
        _borderWidth = data.borderWidth;
        _strokeWidth = data.strokeWidth;
        _font = data.Font;
        _treeGroup = parent;
        _urlGroup = urlGroup;
        _stylePropObj = data.stylePropObj;

        _pathBackRect = CPM.svgUtil.createSVG( 'rect', {
            id: 'pathBackRect',
            x: 0,
            y: 0,
            width: data.Width,
            height: CPM.Enums.Constants.urlHeight,
            fill: _stylePropObj.BreadCrumb.BackColor,
            opacity: 1,
            appendTo: _urlGroup
        } );

        _urlBottomLine = CPM.svgUtil.createSVG( 'line', {
            x1: 0,
            y1: CPM.Enums.Constants.urlHeight,
            x2: data.Width,
            y2: CPM.Enums.Constants.urlHeight,
            stroke: _stylePropObj.BreadCrumb.BottomBorderColor,
            'stroke-width': 1,
            appendTo: _urlGroup
        } );
        _pathRect = CPM.svgUtil.createSVG( 'rect', {
            id: 'pathRect',
            x: 0,
            y: 0,
            width: data.Width,
            height: CPM.Enums.Constants.urlHeight - ( CPM.Enums.Constants.urlHeight - data.imageHeight ) / 2, //_urlHeight- ( _urlHeight - data.imageHeight ) / 2,
            fill: _stylePropObj.BreadCrumb.BackColor,
            opacity: 1,
            appendTo: _urlGroup
        } );

        _urlPartGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'URLPart',
            appendTo: _urlGroup
        } );
    };

    this.updateBCStyle = function ( stylePropObj ) {
        var startImage, length, i, urlText, nodeImagePath;
        _stylePropObj = stylePropObj;
        if ( _pathBackRect ) {
            _pathBackRect.setAttribute( 'fill', _stylePropObj.BreadCrumb.BackColor );
        }
        if ( _pathRect ) {
            _pathRect.setAttribute( 'fill', _stylePropObj.BreadCrumb.BackColor );
        }
        if ( _urlBottomLine ) {
            _urlBottomLine.setAttribute( 'stroke', _stylePropObj.BreadCrumb.BottomBorderColor );
        }
        startImage = _treeGroup.getElementById( 'path_StartImage' );
        if ( startImage ) {
            startImage.setAttribute( 'stroke', _stylePropObj.BreadCrumb.IconColor );
        }
        length = _urlData.length;
        for ( i = 0; i < length; i++ ) {
            urlText = _treeGroup.getElementById( 'text_NodeText_' + i );
            if ( urlText ) {
                if ( i === 0 ) {
                    urlText.setAttribute( 'fill', _stylePropObj.BreadCrumb.SelectionForeColor );
                } else {
                    urlText.setAttribute( 'fill', _stylePropObj.BreadCrumb.ForeColor );
                }
            }
            nodeImagePath = _treeGroup.getElementById( 'path_NodeImage_' + i );
            if ( nodeImagePath ) {
                nodeImagePath.setAttribute( 'stroke', _stylePropObj.BreadCrumb.IconColor );
            }
        }
    };
    this.createURLPart = function ( urlData ) {
        var startImageGroup, linearGrad, defsGroup, svg1;
        _urlData = urlData.data;
        CPM.svgUtil.createSVG( 'rect', {
            x: 0,
            y: 0,
            width: _borderWidth,
            height: CPM.Enums.Constants.urlHeight,
            stroke: 'none',
            'stroke-width': _strokeWidth,
            fill: 'none',
            id: 'URLViewPort',
            appendTo: _urlPartGroup
        } );

        //Creating elements required for Start Image
        startImageGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'StartImage',
            appendTo: _urlPartGroup
        } );

        startImageGroup.addEventListener( 'mouseleave', _removeBgColor );//Event added to remove the background color if any, on the start image
        //Defining gradient color for url parts on mouse hover
        defsGroup = CPM.svgUtil.createSVG( 'defs', {
            appendTo: startImageGroup
        } );

        linearGrad = CPM.svgUtil.createSVG( 'linearGradient', {
            id: 'urlNodeGradient',
            x1: '0%',
            x2: '0%',
            y1: '0%',
            y2: '100%',
            appendTo: defsGroup
        } );

        CPM.svgUtil.createSVG( 'stop', {
            offset: '0%',
            'stop-color': '#91939A',
            'stop-opacity': 1,
            appendTo: linearGrad
        } );

        CPM.svgUtil.createSVG( 'stop', {
            offset: '100%',
            'stop-color': '#F2F4FF',
            'stop-opacity': 1,
            appendTo: linearGrad
        } );

        _startImgRectGroup = CPM.svgUtil.createSVG( 'rect', {
            id: 'rect_StartImage',
            x: urlData.textPadding.left - ( ( urlData.imageIconRect.width - urlData.imageIconSvg.width ) / 2 ),
            y: CPM.Enums.Constants.topPadding,
            width: urlData.imageIconRect.width,
            height: urlData.imageIconRect.height,
            fill: 'transparent',
            stroke: 'rgba(100, 100, 106, 0.5)',
            'stroke-width': '0px',
            appendTo: startImageGroup
        } );

        svg1 = CPM.svgUtil.createSVG( 'svg', {
            id: 'svg_StartImage',
            x: urlData.textPadding.left - ( ( urlData.imageIconRect.width - urlData.imageIconSvg.width ) / 2 ),
            y: CPM.Enums.Constants.topPadding,
            width: urlData.imageIconRect.width,
            height: CPM.Enums.Constants.urlHeight,
            appendTo: startImageGroup
        } );

        //StartImage Icon
        if ( urlData.data.length === urlData.viewportData.length ) {
            startImageGroup.setAttribute( 'pointer-events', 'none' );
            CPM.svgUtil.createSVG( 'path', {
                id: 'path_StartImage',
                d: 'M7 7.5 l 5 5 l -5 5',
                fill: 'none',
                stroke: _stylePropObj.BreadCrumb.IconColor,
                'stroke-width': '1px',
                appendTo: svg1
            } );
        } else {
            startImageGroup.removeAttribute( 'pointer-events' );
            CPM.svgUtil.createSVG( 'path', {
                id: 'path_StartImage',
                d: 'M16 6.5 l -4 5 l 4 5',
                fill: 'none',
                stroke: _stylePropObj.BreadCrumb.IconColor,
                'stroke-width': '1px',
                appendTo: svg1
            } );

            CPM.svgUtil.createSVG( 'path', {
                id: 'path_StartImage',
                d: 'M10 6.5 l -4 5 l 4 5',
                fill: 'none',
                stroke: _stylePropObj.BreadCrumb.IconColor,
                'stroke-width': '1px',
                appendTo: svg1
            } );
        }
    };

    this.updateNodeURL = function ( urlData ) {
        var i, nodeData, nodeURLGroup, nodeTextGroup, nodeText, nodeImageGroup, imageSvg, length = urlData.viewportData.length;
        _viewPortData = urlData.viewportData;
        if ( _urlPartGroup ) {
            while ( _urlPartGroup.firstChild ) {
                _urlPartGroup.removeChild( _urlPartGroup.firstChild );
            }
            this.createURLPart( urlData );
        }
        //Creating the url parts based on the current viewport size
        for ( i = 0; i < length; i++ ) {
            nodeData = urlData.viewportData[i];

            nodeURLGroup = CPM.svgUtil.createSVG( 'g', {
                id: 'NodeURL_' + i,
                appendTo: _urlPartGroup
            } );

            nodeURLGroup.addEventListener( 'mouseleave', _removeBgColor );//Event added to remove the background color if any, on the current url part.

            nodeTextGroup = CPM.svgUtil.createSVG( 'g', {
                id: 'NodeText',
                appendTo: nodeURLGroup
            } );

            CPM.svgUtil.createSVG( 'rect', {
                id: 'rect_NodeText_' + i,
                x: nodeData.x,
                y: 0,
                width: nodeData.width + urlData.imageIconSvg.width + urlData.textPadding.left + urlData.textPadding.right,
                height: CPM.Enums.Constants.urlHeight,
                fill: 'transparent',
                stroke: 'rgba(100, 100, 106, 0.5)',
                'stroke-width': '0px',
                appendTo: nodeTextGroup
            } );

            nodeText = CPM.svgUtil.createSVG( 'text', {
                id: 'text_NodeText_' + i,
                x: nodeData.x,
                y: nodeData.height + CPM.Enums.Constants.topPadding,
                'font-size': urlData.font.size,
                fill: i === 0 ? _stylePropObj.BreadCrumb.SelectionForeColor : _stylePropObj.BreadCrumb.ForeColor,
                'font-family': _font.family,
                'font-weight': 'bold',
                appendTo: nodeTextGroup
            } );

            nodeText.textContent = nodeData.name;

            //Do not create BC Node Image if the node is leaf node
            if ( !nodeData.IsLeaf ) {
                nodeImageGroup = CPM.svgUtil.createSVG( 'g', {
                    id: 'NodeImage',
                    appendTo: nodeURLGroup
                } );

                CPM.svgUtil.createSVG( 'rect', {
                    id: 'rect_NodeImage_' + i,
                    x: nodeData.x + nodeData.width + ( urlData.textPadding.left - urlData.imageIconSvg.width ) / 2,
                    y: ( _urlHeight - urlData.imageIconRect.height ) / 2,
                    width: urlData.imageIconRect.width,
                    height: urlData.imageIconRect.height,
                    fill: 'transparent',
                    stroke: 'rgba(100, 100, 106, 0.5)',
                    'stroke-width': '0px',
                    appendTo: nodeImageGroup
                } );

                imageSvg = CPM.svgUtil.createSVG( 'svg', {
                    id: 'svg_NodeImage_' + i,
                    x: nodeData.x + nodeData.width + ( urlData.textPadding.left - urlData.imageIconSvg.width ) / 2,
                    y: CPM.Enums.Constants.topPadding,
                    width: urlData.imageIconRect.width,
                    height: CPM.Enums.Constants.urlHeight,
                    appendTo: nodeImageGroup
                } );

                CPM.svgUtil.createSVG( 'path', {
                    id: 'path_NodeImage_' + i,
                    d: 'M7 7.5 l 5 5 l -5 5',
                    fill: 'none',
                    stroke: _stylePropObj.BreadCrumb.IconColor,
                    'stroke-width': '1px',
                    appendTo: imageSvg
                } );
            }
        }
    };

    this.getBCNode = function ( target ) {
        var idArray = target.id.split( '_' ), idx;
        idx = parseInt( idArray[idArray.length - 1] );
        return _viewPortData[idx];
    };

    this.setBgColor = function ( evtType, target ) {
        var idArray = target.id.split( '_' ), idx, nodeImageRect, fill, nodeImagePath;
        idx = parseInt( idArray[idArray.length - 1] );
        if ( evtType === 'mouseover' || evtType === 'mouseup' || evtType === 'touchend' ) {
            fill = _stylePropObj.BreadCrumb.ButtonColor;
        } else {
            if ( evtType === 'mousedown' || evtType === 'touchstart' ) {
                fill = _stylePropObj.BreadCrumb.PressedButtonColor;
            }
        }
        if ( target.id.indexOf( 'StartImage' ) !== -1 && _urlData.length !== _viewPortData.length ) {
            if ( _startImgRectGroup ) {
                _startImgRectGroup.setAttribute( 'fill', fill );
                _startImgRectGroup.setAttribute( 'stroke-width', '1px' );
            }
        } else {
            nodeImageRect = _treeGroup.getElementById( 'rect_NodeImage_' + idx );
            nodeImagePath = _treeGroup.getElementById( 'path_NodeImage_' + idx );
            if ( nodeImageRect ) {
                nodeImageRect.setAttribute( 'fill', fill );
                nodeImageRect.setAttribute( 'stroke-width', '1px' );
                nodeImagePath.setAttribute( 'stroke', _stylePropObj.BreadCrumb.PressedIconColor );
            }
        }
    };

    this.updateNodeImage = function ( target ) {
        var idArray, idx, nodeImagePath;
        if ( target ) {
            idArray = target.id.split( '_' );
            idx = parseInt( idArray[idArray.length - 1] );
            nodeImagePath = _treeGroup.getElementById( 'path_NodeImage_' + idx );
            if ( nodeImagePath ) {
                nodeImagePath.setAttribute( 'd', 'M6 12 l 5 5 l 5 -5' );//Update the image to downward arrow whenever the children of a node is displayed from breadcrumb.
                if ( _prevNode && _prevNode.id !== nodeImagePath.id ) {
                    _prevNode.setAttribute( 'd', 'M7 7.5 l 5 5 l -5 5' );//Reset the image to forward arrow if any previous node's children were displayed in breadcrumb.
                }
                _prevNode = nodeImagePath;
                return;
            }
        }
        if ( _prevNode ) {
            _prevNode.setAttribute( 'd', 'M7 7.5 l 5 5 l -5 5' );//Reset the image to forward arrow if any previous node's children were displayed in breadcrumb.
            _prevNode = null;
        }
    };

    this.createBreadCrumb = function ( crumbCollection, data, toolbarHeight, imageIconRectHeight ) {
        var i, length = crumbCollection.length, svgGroup, breadCrumbGroup, crumbGroup, crumbSvg, crumbText, left, top, bgRect;
        _crumbData = crumbCollection;
        left = data.crumbX;
        top = CPM.Enums.Constants.urlHeight + toolbarHeight - imageIconRectHeight / 2 + ( 2 * CPM.Enums.Constants.textBottomPadding );

        if ( length > 0 ) {
            if ( !_bCSvgGroup ) {
                _bCSvgGroup = CPM.svgUtil.createSVG( 'svg', {
                    id: 'breadCrumSvg',
                    y: top,
                    style: 'position:absolute; left:0px; top:0px;',
                    appendTo: data.divParent
                } );
            }

            bgRect = CPM.svgUtil.createSVG( 'rect', {
                x: '0',
                y: '0',
                width: data.crumbNodeNameWidth + ( 2 * CPM.Enums.Constants.textLeftPadding ) + CPM.Enums.Constants.polyDimH,
                height: data.crumbHeight,
                fill: _stylePropObj.Control.EvenBackColor,
                stroke: 'none',
                style: 'position:absolute; left:0px; top:0px;',
                appendTo: _bCSvgGroup
            } );
            _bCSvgGroup.setAttribute( 'x', left );
            _bCSvgGroup.setAttribute( 'width', data.crumbNodeNameWidth + ( 2 * CPM.Enums.Constants.textLeftPadding ) + CPM.Enums.Constants.polyDimH );
            _bCSvgGroup.setAttribute( 'height', data.crumbHeight + 7 );
            _bCSvgGroup.style.left = bgRect.style.left = left + 'px';
            _bCSvgGroup.style.top = bgRect.style.top = top + 'px';
        }

        svgGroup = CPM.svgUtil.createSVG( 'svg', {
            height: data.crumbHeight + CPM.Enums.Constants.urlHeight + toolbarHeight,
            width: data.crumbNodeNameWidth + ( 2 * CPM.Enums.Constants.textLeftPadding ) + CPM.Enums.Constants.polyDimH,
            appendTo: _bCSvgGroup
        } );

        breadCrumbGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'breadcrumbGroup',
            transform: 'translate(0,0)',
            appendTo: svgGroup
        } );
        //Creating the elements to display immediate children of for the node selected from breadcrumb
        for ( i = 0; i < length; i++ ) {
            crumbGroup = CPM.svgUtil.createSVG( 'g', {
                id: 'breadcrumbGroup_g_' + i,
                appendTo: breadCrumbGroup
            } );

            CPM.svgUtil.createSVG( 'rect', {
                id: _crumbData[i].isSelected ? 'breadcrumbGroup_rect_Selected_' + i : 'breadcrumbGroup_rect_' + i,
                x: '0',
                y: ( i * _nodeHeight ),
                width: data.crumbNodeNameWidth + ( 2 * CPM.Enums.Constants.textLeftPadding ) + CPM.Enums.Constants.polyDimH,
                height: _nodeHeight,
                fill: _crumbData[i].isSelected ? data.active : i % 2 === 0 ? data.white : data.grey3,
                'stroke-width': '0px',
                appendTo: crumbGroup
            } );

            crumbText = CPM.svgUtil.createSVG( 'text', {
                id: 'breadcrumbGroup_text_' + i,
                x: ( 2 * CPM.Enums.Constants.textLeftPadding ) - CPM.Enums.Constants.horizontalgap,
                y: ( i * _nodeHeight ) + ( 11 * CPM.Enums.Constants.textBottomPadding ),
                fill: _crumbData[i].isSelected ? data.SelectionForeColor : data.foreColor,
                'font-family': _font.family,
                'font-size': _font.Size,
                appendTo: crumbGroup
            } );

            crumbText.textContent = _crumbData[i].Name;

            //Icon to be displayed for each children
            crumbSvg = CPM.svgUtil.createSVG( 'svg', {
                x: CPM.Enums.Constants.polyDimH,
                y: ( i * _nodeHeight ) + ( 3 * CPM.Enums.Constants.textBottomPadding ),
                fill: _crumbData[i].isSelected ? data.SelectionNodeIconColor : _stylePropObj.Control.NodeIconColor,
                appendTo: crumbGroup
            } );

            CPM.svgUtil.createSVG( 'path', {
                id: 'breadcrumbGroup_path1_' + i,
                d: 'M10,7,5.5,11.5,10,16l4.5-4.5ZM6.91,11.5,10,8.41v6.17Z',
                appendTo: crumbSvg
            } );

            CPM.svgUtil.createSVG( 'path', {
                id: 'breadcrumbGroup_path2_' + i,
                d: 'M18.5,6.5,15,3,11.5,6.5,15,10Zm-5.59,0L15,4.41V8.59Z',
                appendTo: crumbSvg
            } );

            CPM.svgUtil.createSVG( 'path', {
                id: 'breadcrumbGroup_path3_' + i,
                d: 'M11.5,16.5,15,20l3.5-3.5L15,13Zm1.41,0L15,14.41v4.17Z',
                appendTo: crumbSvg
            } );
        }

        if ( length > 0 ) {
            CPM.svgUtil.createSVG( 'rect', {
                x: '0',
                y: '0',
                width: data.crumbNodeNameWidth + ( 2 * CPM.Enums.Constants.textLeftPadding ) + CPM.Enums.Constants.polyDimH,
                height: data.crumbHeight,
                fill: 'none',
                stroke: 'none',
                appendTo: _bCSvgGroup
            } );
        }
        return _bCSvgGroup;
    };

    this.resetDims = function () {
        _bCSvgGroup.setAttribute( 'height', '0' );
        _bCSvgGroup.setAttribute( 'width', '0' );
    };

    this.unloadBreadCrumb = function () {
        var self = this;
        if ( _bCSvgGroup ) {
            while ( _bCSvgGroup.firstChild ) {
                _bCSvgGroup.removeChild( _bCSvgGroup.firstChild );
            }
            self.resetDims();
        }
    };

    this.getCrumbNode = function ( target ) {
        var idArray = target.id.split( '_' ), idx;
        idx = parseInt( idArray[idArray.length - 1] );
        return _crumbData[idx];
    };

    this.remove = function () {
        while ( _urlGroup && _urlGroup.firstChild ) {
            _urlGroup.removeChild( _urlGroup.firstChild );
        }
    };
};