/**
* Creates an instance of TreeControl
* @class
* @desc Class for creating TreeControl
* @constructor
*/
var CPM = ( CPM || {} );
CPM.App = function () {
    var
    // holds refernce of callback function to be called on event occurs on DOM
    _callback,
    _searchText = '',
    // holds information of general operations
    _operation = {
        add: 'add',
        remove: 'remove'
    },
    // holds left value
    _left = 5,
    // holds top value
    _top = 5,
    _id = 'CPM_Tree_Combo',
    _deepestNode = 0,
    _deepestNodeWidth = 0,
    _prevNodeSelected,
    _ctrlHeight = 0,
    _nodeHeight = 33.5, // Hardcoded value as there is no configuration available for the font for control in ES
    _divParent = null,
    _isExpandAll = false,
    _isRootNodePropertyChanged = false,
    _isNodeUpdated = false,
    _isFullDataPresent = false,
    _isCollapseAll = false,
    _scrollVerticalHandler = new CPM.Control.ScrollHandler(),
    _scrollBCVerticalHandler = new CPM.Control.ScrollHandler(),
    _scrollHorizontalHandler = new CPM.Control.ScrollHandler(),
    _urlPartTotalHeight,
    _searchComboBoxPartHeight,
    _nodeDomHeight,
    _toolbarHeight,
    _isScrollbarCreated = false,
    _isBCVerticalScrollbarCreated = false,
    _isHorizontalScrollbarCreated = false,
    _isExtendedStyle = false,
    _isAlarmsPresent = false,
    _horizontalLine = false,
    _treeAlarmIconGroup = null,
    _treeGroup = null,
    _treeGroupMatrix,
    _iconTextGroup = null,
    _breadcrumbGroup = null,
    _breadcrumbGroupMatrix,
    _deepestIdx = 1,
    _isBreadCrumbCreated = false,
    _prevHoveredNodeId = null,
    _prevSelectedBCNodeId = null,
    _prevSelectedCrumbNode,
    _nodeHandler,
    _treeControlGroup = null,
    _urlGroup = null,
    _urlGroupMatrix,
    _toolbarGroup = null,
    _searchComboBoxGroup = null,
    _showToolBar = true,
    _showBreadCrumb = true,
    _showSearchComboBox = true,
    _isFilterRectsCreated = false,
    _breadCrumb,
    _toolbar,
    _vpNodeCount,
    _scrollCount = 0,
    _linearDataArray = [],
    _bufferDataArray = [],
    _isBCUpdateRequired = false,
    _iconTextGroupMatrix,
    _vScrollStep = 0,
    _prevScrollPerc = 0,
    _vBCScrollStep = 0,
    _vBCScrollHeight = 0,
    _prevBCScrollPerc = 0,
    _hScrollStep = 0,
    _hScrollWidth = 0,
    //maintain count information. it is used to calculate index of tree nodes
    _count = 0,
    _crumbChildren = [],
    _crumbX,
    _crumbNodeNameWidth,
    _showCrumb = false,
    _crumbHeight,
    _clickedURLNodeId,
    _crumbNodeNameHeight,
    _comboBoxHandler,
    _filterComboBox,
    _searchBox,
    _isSearchPending = false,
    _scrollbarGrp,
    _bcParentGrp = null,
    _options = {},
    _isBCSelectionRequest = false,
    self = this,
    // holds font information
    TEXT_BBOX = 0,
    _font = {
        parttype: 'FontPart',
        Size: 14,
        family: 'Siemens Sans',
        color: 'black'
    },
    _data = {
        Left: _left,
        Top: _top,
        Width: 150,
        Height: 900,
        Font: _font,
        NodePart: [],
        currentStyle: WebCC.Extensions.HMI.Style.Name,
        URLPart: { border: { height: 40, width: 0, strokeWidth: 1, paddingRight: 10 }, font: { size: 14 }, imageIconRect: { width: 20, height: 24 }, imageIconSvg: { width: 5 }, textPadding: { left: 10, right: 10 }, data: [], viewportData: [] },
        ToolbarPart: {
            border: {
                height: 55, width: 50, topVal: 0, strokeWidth: 1, paddingRight: 10, iconSpacing: 7,
                buttonHeight: 36,
                buttonTop: 10
            }, font: { size: 15 }, imageIcon: { width: 24, height: 20 }, textPadding: { left: 5, right: 5 }, data: [], viewportData: []
        },
        SearchComboBoxPart: {
            border: {
                height: 60, width: 0, strokeWidth: 1, paddingRight: 10, iconSpacing: 7,
                buttonHeight: 36,
                buttonTop: 10
            }, font: { size: 15 }, data: [], viewportData: []
        }
    },
    _cntrlHeightNew = 0,
    _cntrlWidthNew = 0,
    // holds refernce of svgParent
    _svgParent,
    // holds selectedNode Id
    _selectedNodeId,
    _expandedNodeId,
    _navigatedNodeId,
    _navigationType,
    _horizontalInitialScrollOffset = 0,
    _hScrollbarHeight,
     _alarmComapnion = [],
     _screenWindowCompanion = [],
     _shcCompanion = [],
     _selectedNodePath,
     _rootNode,
     _eventManager,
     _tbUpdateRequired = false,
     _enableExpandBtn = false,
     _alarmData = {},
     _screenData = {},
     _selectedFilter,
    _createFilter = false,
    _moveBelow = false,
    _addExtraScroll,
    _defaultSelectionBackColor = 4286434805,
    _defaultSelectionForeColor = 0,
    _selectionBackColUpdated = false,
    _selectionForeColUpdated = false,
    //returns default node properties
    _getDefaultNode = function () {
        return {
            Name: null,
            Id: null,
            ObjectType: null,
            IsExpanded: true,
            IsLeaf: false,
            Visible: true,
            Children: [],
            Parent: WebCC.Properties.SelectedNode,
            ParentId: _selectedNodeId
        };
    },

    //calculates bbox information of text
    _fillBBoxInfo = function ( data ) {
        if ( data ) {
            var text = ( data.name || 'XY' ),
            bbox = CPM.svgUtil.getTextBBox( { Size: _data.URLPart.font.size, Weight: 'bold', Name: _font.family }, '' + text );
            data.height = Math.ceil( bbox.height );
            data.width = Math.ceil( bbox.width );
        }
    },

    //returns node data based on nodeId
    _getNodeData = function ( nodeId ) {
        var nodeData,
        nodePart = _data.NodePart[0];
        if ( nodeId ) {
            if ( nodeId === nodePart.Id ) {
                nodeData = nodePart;
            }
            else {
                nodeData = _searchForNode( nodePart, nodeId, _operation.add );
            }
        }
        return nodeData;
    },

    //returns node data based on fullPath
    _getNodeDataByPath = function ( fullPath ) {
        var nodeData,
        nodePart = _data.NodePart[0];
        if ( nodePart ) {
            if ( fullPath === nodePart.fullPath ) {
                nodeData = nodePart;
            } else {
                nodeData = _searchForNode( nodePart, fullPath, _operation.add, true );
            }
        }
        return nodeData;
    },

    _handleSearchText = function ( textStr ) {
        var currentSearchText;
        if ( _isSearchPending ) {
            _count = 0;
        }
        else {
            if ( textStr || textStr === '' ) {
                currentSearchText = textStr.toLowerCase();
                if ( _searchText.toLowerCase() !== currentSearchText ) {
                    _searchText = currentSearchText;
                }
            }
        }

        if ( !_isFullDataPresent ) {
            if ( _data.NodePart[0] ) {
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1], [CPM.Enums.BrowsingMode.ExpandAll, _data.NodePart[0].Id] );
                _isSearchPending = true;
                _nodeHandler.updateBgRects( [], !_scrollCount, _data, _isAlarmsPresent );
            }
        }
        else {
            _markNodesHavingSearchText();

            if ( !_isSearchPending ) {
                _nodeHandler.updateBgRects( [], !_scrollCount, _data, _isAlarmsPresent );
            }
            else {
                _isSearchPending = false;
            }

            if ( _isAlarmsPresent ) {
                _removeAlarmBgRects();
                _createAlarmBgRects();
            }
            _setBeforeTraverse();
            _setForUpdate();
        }
    },

    _mergeNodeProps = function ( dest, src ) {
        var i, j,
        srcChildren,
        destChildren,
        srcChildrenLen,
        destChildrenLen,
        matchedNode;

        if ( dest.Id === src.Id ) {
            dest.isNodeNavigated = src.isNodeNavigated;

            //process if any source children exists
            srcChildren = src.Children;

            if ( srcChildren ) {
                srcChildrenLen = src.Children.length;

                for ( j = 0; j < srcChildrenLen; j++ ) {
                    _mergeNodeProps( dest, srcChildren[j] );
                }
            }
        }
        else {
            destChildren = dest.Children;

            if ( destChildren ) {
                destChildrenLen = destChildren.length;

                //process if any destination children exists
                for ( i = 0; i < destChildrenLen; i++ ) {

                    if ( destChildren[i].Id === src.Id ) {
                        matchedNode = destChildren[i];
                        matchedNode.isNodeNavigated = src.isNodeNavigated;

                        _mergeNodeProps( matchedNode, src );
                        break;
                    }
                }
            }
        }
    },

    _markNodesHavingSearchText = function () {
        _searchNodes( _data.NodePart[0] );
        _data.NodePart[0].hasSearchText = _data.NodePart[0].Name.toLowerCase().includes( _searchText );
    },

    _searchNodes = function ( node ) {
        var child,
        length,
        children;

        node.hasChildWithSearchText = false;

        if ( node ) {
            children = node.Children || [];
            length = children.length;

            while ( length-- ) {
                node.IsExpanded = true;
                child = children[length];
                child.hasSearchText = child.Name.toLowerCase().includes( _searchText );
                if ( child.hasSearchText ) {
                    node.hasChildWithSearchText = true;
                }
                if ( child.isSelected && child.fullPath !== _selectedNodePath ) {
                    child.isSelected = false;
                }
                if ( !child.IsLeaf ) {
                    _searchNodes( child );
                }
            }

            if ( node.hasChildWithSearchText && node.Parent ) {
                node.Parent.hasChildWithSearchText = true;
            }
            if ( node.isSelected && node.fullPath !== _selectedNodePath ) {
                node.isSelected = false;
            }
        }
    },

    //Expands all the childrens of the selected node
    _expandAllChildren = function ( selectedNode ) {
        var i = 0,
        children = selectedNode.Children,
        child,
        childCount;
        if ( _isExpandAll ) {
            selectedNode.IsExpanded = true;
        }
        if ( children ) {
            childCount = children.length;
            for ( i = 0; i < childCount; i++ ) {
                child = children[i];
                child.Visible = true;
                _expandAllChildren( child );
            }
        }
    },

    //update or set depth and index information
    _traverse = function ( node, isVisible ) {
        var i = 0, childName,
        children = node.Children,
        child,
        childCount,
        prevIndexAtDepth = 0;
        prevIndexAtDepth = node.index = _count++;
        if ( _isExpandAll ) {
            node.IsExpanded = true;
        } else {
            if ( _isCollapseAll ) {
                node.IsExpanded = false;
            }
        }

        if ( _rootNode !== '' && _selectedFilter && ( ( _selectedFilter === _options['TBID_NODE_PENDINGALARMS'] && Object.keys( _alarmData ).length > 0 && Object.keys( _alarmData.ActiveAlarms ).length > 0 && _alarmData.ActiveAlarms[_rootNode] === undefined ) || ( _selectedFilter === _options['TBID_NODE_VISUALIZATION'] && Object.keys( _screenData ).length > 0 && Object.keys( _screenData.ScreenFilter ).length > 0 && _screenData.ScreenFilter[_rootNode] === undefined ) ) ) {
            return;
        } else {
            if ( isVisible || _applyVisibilityOnSearchAndFilter( node ) ) {
                _linearDataArray.push( node );
            }
        }
        if ( children ) {
            childCount = children.length;
            for ( i = 0; i < childCount; i++ ) {
                child = children[i];
                child.ParentId = node.Id;
                child.prevIndexAtDepth = prevIndexAtDepth;
                if ( node.IsExpanded === true ) {
                    _applyVisibilityOnSearchAndFilter( child );
                    if ( node.depth === undefined || node.depth === null ) {
                        node.depth = 0;
                    }
                    child.depth = node.depth + 1;
                    if ( child.depth >= _deepestNode ) {
                        _deepestNode = child.depth;
                        childName = child.Name;
                    }
                } else {
                    child.Visible = false;
                }

                if ( child.Visible === true ) {
                    _traverse( child, true );
                    prevIndexAtDepth = child.index;
                }
            }
        }
        //node.isSelected = false;
    },

    _applyVisibilityOnSearchAndFilter = function ( node ) {
        var isVisible = false;

        if ( _selectedFilter && _selectedFilter !== _options['TBID_NONE'] ) {
            if ( _selectedFilter === _options['TBID_NODE_PENDINGALARMS'] && Object.keys( _alarmData ).length > 0 && Object.keys( _alarmData.ActiveAlarms ).length > 0 ) {
                isVisible = _alarmData.ActiveAlarms[node.fullPath] === 1;
            }
            else {
                if ( _selectedFilter === _options['TBID_NODE_VISUALIZATION'] && Object.keys( _screenData ).length > 0 && Object.keys( _screenData.ScreenFilter ).length > 0 ) {
                    isVisible = _screenData.ScreenFilter[node.fullPath] === 0;
                }
            }
        }
        else {
            isVisible = true;
        }

        if ( isVisible && _searchText ) {
            if ( _selectedFilter && _selectedFilter !== _options['TBID_NONE'] ) {
                isVisible = node.canRetain;
            }
            else {
                isVisible = node.hasSearchText || node.hasChildWithSearchText;
            }
        }

        node.Visible = isVisible;

        return isVisible;
    },

    //updates URL data
    _updateURLData = function ( node ) {
        var URLPart = _data.URLPart,
        nodePart = _data.NodePart[0], prevNode,
        nodeData;
        URLPart.data.length = 0;
        if ( !node ) {
            return;
        }
        //selected node is hierarchy node
        if ( node.Id === nodePart.Id ) {
            nodeData = { name: nodePart.Name, id: nodePart.Id, height: null, width: null, IsLeaf: nodePart.IsLeaf };
            URLPart.data.push( nodeData );
            _fillBBoxInfo( nodeData );
        }
        else {//selected node is view root or view node
            nodeData = { name: node.Name, id: node.Id, height: null, width: null, IsLeaf: node.IsLeaf };
            URLPart.data.push( nodeData );
            _fillBBoxInfo( nodeData );

            prevNode = node;
            while ( prevNode.Id !== nodePart.Id ) {
                if ( prevNode.ParentId === nodePart.Id ) {
                    nodeData = { name: nodePart.Name, id: nodePart.Id, height: null, width: null, IsLeaf: nodePart.IsLeaf };
                    URLPart.data.push( nodeData );
                    _fillBBoxInfo( nodeData );
                    break;
                }
                prevNode = _searchForNode( nodePart, prevNode.ParentId, _operation.add );
                nodeData = { name: prevNode.Name, id: prevNode.Id, height: null, width: null, IsLeaf: prevNode.IsLeaf };
                URLPart.data.push( nodeData );
                _fillBBoxInfo( nodeData );
            }
        }
        _calculateViewPortURLData();
    },

    //calculate viewport URL data from entire URL data
    _calculateViewPortURLData = function () {
        var i = 0,
        URLPart = _data.URLPart,
        dataLength = URLPart.data.length,
        viewportDataLength,
        offset = URLPart.textPadding.left + URLPart.imageIconSvg.width + URLPart.textPadding.right,
        availableWidth = ( URLPart.border.width - offset ) > 0 ? ( URLPart.border.width - offset ) : 0,
        coveredWidth = 0;
        URLPart.viewportData.length = 0;
        if ( _breadCrumb ) {
            if ( availableWidth > coveredWidth ) {
                for ( i = 0; i < dataLength; i++ ) {
                    if ( ( coveredWidth + URLPart.data[i].width + offset ) < availableWidth ) {
                        URLPart.viewportData.push( URLPart.data[i] );
                        coveredWidth += URLPart.data[i].width + offset;
                    }
                    else {
                        break;
                    }
                }
                //calculate text x-position
                viewportDataLength = URLPart.viewportData.length;
                coveredWidth = offset;
                for ( i = viewportDataLength - 1; i >= 0; i-- ) {
                    URLPart.viewportData[i].x = coveredWidth;
                    coveredWidth += URLPart.viewportData[i].width + offset;
                }
            }
            _breadCrumb.updateNodeURL( URLPart );
        }
    },

    _searchForNode = function ( node, searchStr, operation, isFullPath ) {
        var
        children,
        child,
        length,
        retVal,
        isFound = false;
        if ( node && node.Children && node.Children.length > 0 ) {
            children = node.Children;
            length = children.length;
            while ( length-- ) {
                child = children[length];
                if ( searchStr && searchStr !== '' ) {
                    if ( isFullPath ) {
                        isFound = ( child.fullPath === searchStr ) ? true : false;
                    }
                    else {
                        isFound = ( child.Id.toLowerCase() === searchStr.toLowerCase() ) ? true : false;
                    }
                    if ( isFound ) {
                        switch ( operation ) {
                            case _operation.remove:
                                children.splice( children.indexOf( child ), 1 );
                                retVal = true;
                                break;
                            case _operation.add:
                                retVal = child;
                                break;
                            default:
                                break;
                        }
                    }
                    else {
                        if ( !child.IsLeaf && !retVal ) {
                            retVal = _searchForNode( child, searchStr, operation, isFullPath );
                        }
                    }
                }
            }
        }
        return retVal;
    },


    _onScroll = function ( direction, scrollBar, evt ) {
        var yValue, xValue, pageScrollCount;
        switch ( scrollBar ) {
            case 'bcVScroll':
                if ( _isBCVerticalScrollbarCreated ) {
                    if ( direction && ( _prevBCScrollPerc + _vBCScrollStep <= 1 ) ) {
                        _prevBCScrollPerc = _prevBCScrollPerc + _vBCScrollStep;
                    } else {
                        if ( !direction && ( _prevBCScrollPerc > 0 && ( _prevBCScrollPerc - _vBCScrollStep >= 0 ) ) ) {
                            _prevBCScrollPerc = _prevBCScrollPerc - _vBCScrollStep;
                        }
                    }
                    if ( _prevBCScrollPerc !== 0 ) {
                        yValue = -( _prevBCScrollPerc * _vBCScrollHeight );
                    }
                    else {
                        yValue = 0;
                    }
                    _breadcrumbGroupMatrix.f = yValue;
                    _createBCVerticalScrollBar();
                }
                break;
            case 'VScroll':
                if ( _isScrollbarCreated ) {
                    if ( direction && ( _vScrollStep + _prevScrollPerc <= 1 ) ) {
                        _prevScrollPerc = _vScrollStep + _prevScrollPerc;
                        if ( evt && evt.keyCode === 34 ) {
                            pageScrollCount = _vpNodeCount + _scrollCount;
                            _prevScrollPerc = pageScrollCount / ( _count - _vpNodeCount );
                        }
                        _scrollCallBack( null, null, _prevScrollPerc );
                        _createVerticalScrollBar();
                    } else {
                        if ( !direction && ( _prevScrollPerc > 0 && ( ( _prevScrollPerc - _vScrollStep ) >= 0 ) ) ) {
                            _prevScrollPerc = _prevScrollPerc - _vScrollStep;
                            if ( evt && evt.keyCode === 33 ) {
                                pageScrollCount = _scrollCount - _vpNodeCount;
                                _prevScrollPerc = pageScrollCount / ( _count - _vpNodeCount );
                            }
                            _scrollCallBack( null, null, _prevScrollPerc );
                            _createVerticalScrollBar();
                        }
                    }
                }
                break;
            case 'HScroll':
                if ( _isHorizontalScrollbarCreated ) {
                    if ( direction && ( _horizontalInitialScrollOffset + _hScrollStep <= 1 ) ) {
                        _horizontalInitialScrollOffset = _horizontalInitialScrollOffset + _hScrollStep;
                    } else {
                        if ( !direction && ( _horizontalInitialScrollOffset > 0 && ( _horizontalInitialScrollOffset - _hScrollStep >= 0 ) ) ) {
                            _horizontalInitialScrollOffset = _horizontalInitialScrollOffset - _hScrollStep;
                        }
                    }
                    if ( _horizontalInitialScrollOffset !== 0 ) {
                        xValue = -( _horizontalInitialScrollOffset * _hScrollWidth );
                    }
                    else {
                        xValue = 0;
                    }
                    _createHorizontalScrollBar();
                    _iconTextGroupMatrix.e = xValue;
                }
                break;
            default:
                break;
        }
    },

    _scrollCallBack = function ( changeType, abs, perc ) {
        var nodeBBoxInfo, vCount = _count;//, percentile;
        _prevScrollPerc = perc;
        if ( _addExtraScroll ) {
            vCount++;
        }
        _scrollCount = Math.round(( vCount - _vpNodeCount ) * perc );
        //Below _scrollCount check is required for handling Page Up and Page Down events
        if ( _scrollCount < 0 ) {
            _scrollCount = 0;
        } else {
            if ( _scrollCount > vCount - _vpNodeCount ) {
                _scrollCount = Math.round( vCount - _vpNodeCount );
            }
        }
        _setHorizontalLineVal();
        nodeBBoxInfo = _nodeHandler.onScroll( _scrollCount, _data, _isScrollbarCreated, _isAlarmsPresent, _horizontalLine );
        _updateNodeBBox( nodeBBoxInfo );
    },

    _scrollCallBackBC = function ( changeType, abs, perc ) {
        var yValue;
        _prevBCScrollPerc = perc;
        if ( perc !== 0 ) {
            yValue = -abs;
        }
        else {
            yValue = 0;
        }
        _breadcrumbGroupMatrix.f = yValue;
    },

    _scrollCallBackHoriz = function ( changeType, abs, perc ) {
        var xValue;
        _horizontalInitialScrollOffset = perc;
        if ( perc !== 0 ) {
            xValue = -abs;
        } else {
            xValue = 0;
        }
        _iconTextGroupMatrix.e = xValue;
    },

    _handleVScrollBar = function ( mousePoint, targetGroup, event, target ) {
        _scrollVerticalHandler.onScrollEvent( mousePoint, targetGroup, event, target );
        _unloadBreadCrumb();
    },

    _handleBCVScrollBar = function ( mousePoint, targetGroup, event, target ) {
        _scrollBCVerticalHandler.onScrollEvent( mousePoint, targetGroup, event, target );
    },

    _handleCBVScrollBar = function ( mousePoint, targetGroup, event, target ) {
        _filterComboBox.cbScrollVerticalHandler.onScrollEvent( mousePoint, targetGroup, event, target );
    },

    _handleHScrollBar = function ( mousePoint, targetGroup, event, target ) {
        _scrollHorizontalHandler.onScrollEvent( mousePoint, targetGroup, event, target );
    },

    _applyResize = function ( height ) {
        var actualHeight;
        if ( height > _ctrlHeight ) {
            actualHeight = height;
            _svgParent.setAttribute( 'height', ( height + 'px' ) );
        }
        else {
            actualHeight = _ctrlHeight;
            _svgParent.setAttribute( 'height', ( _ctrlHeight + 'px' ) );
        }
        _createVerticalScrollBar();
        _createHorizontalScrollBar();
        _updateBgRects();
        _setForUpdate();
    },

    _createVerticalScrollBar = function () {
        var
        left = _data.Left + _data.Width - _data.stylePropObj.ScrollBar.ScrollPadding, settings = {}, totalHeight, viewPortHeight, vCount = _count,
        topValue = _urlPartTotalHeight + _toolbarHeight + _searchComboBoxPartHeight;
        totalHeight = _count * _nodeHeight;
        viewPortHeight = _ctrlHeight - topValue;
        //Do not create vertical scrollbar if total height of tree is within viewport height or if viewport height is lesser than the node height i.e. height of one tree node.
        if ( viewPortHeight >= totalHeight || viewPortHeight < _nodeHeight ) {
            if ( _isScrollbarCreated ) {
                _scrollVerticalHandler.remove();
                _isScrollbarCreated = false;
                _scrollCount = 0;
            }
            return;
        }
        if ( _addExtraScroll ) {
            vCount++;
        }
        settings.currentStyle = _data.currentStyle;
        settings.width = _data.stylePropObj.ScrollBar.Width;
        settings.height = viewPortHeight + _data.stylePropObj.ScrollBar.TopPadding;
        if ( _isHorizontalScrollbarCreated ) {
            settings.height = settings.height - _data.stylePropObj.ScrollBar.Width;
        }
        settings.height = settings.height < 0 ? 0 : settings.height;
        settings.id = 'tree_';
        settings.startValue = 0;
        settings.endValue = vCount - Math.round( _vpNodeCount );

        settings.initialScrollOffset = 0;
        settings.initialHeightPerc = ( _vpNodeCount ) / ( vCount );
        _vScrollStep = settings.scrollStep = 1 / ( vCount - Math.ceil( _vpNodeCount ) );
        settings.horizontalSliderHeight = _data.stylePropObj.ScrollBar.Width;
        if ( _isScrollbarCreated ) {
            _scrollVerticalHandler.remove();
            _prevScrollPerc = settings.initialScrollOffset = _scrollCount / ( settings.endValue );
        }
        _isScrollbarCreated = true;
        _scrollVerticalHandler.createScrollBar( settings, left, topValue, _scrollbarGrp, _scrollCallBack, false );
    },

    // Vertical scroll bar for Breadcrumb 
    _createBCVerticalScrollBar = function () {
        var settings = {},
        left = _crumbNodeNameWidth + 40,
        topValue = _toolbarHeight + _data.URLPart.imageIconRect.height + ( _urlPartTotalHeight - _data.URLPart.imageIconRect.height ) / 2,
        totalHeight = _crumbChildren.length * _nodeDomHeight;
        if ( ( _ctrlHeight - topValue - _toolbarHeight ) > totalHeight ) {
            if ( _isBCVerticalScrollbarCreated ) {
                _scrollBCVerticalHandler.remove();
                _isBCVerticalScrollbarCreated = false;
            }
            return;
        }
        settings.currentStyle = _data.currentStyle;
        settings.width = 15;
        settings.horizontalSliderHeight = 15;
        if ( _isHorizontalScrollbarCreated ) {
            settings.height = _ctrlHeight - topValue - _hScrollbarHeight;
            _vBCScrollHeight = settings.endValue = _nodeDomHeight * _crumbChildren.length - _ctrlHeight + topValue + _hScrollbarHeight;
        } else {
            settings.height = _ctrlHeight - topValue;
            _vBCScrollHeight = settings.endValue = _nodeDomHeight * _crumbChildren.length - _ctrlHeight + topValue;
        }
        _vBCScrollStep = settings.scrollStep = 1 / _crumbChildren.length;
        settings.initialHeightPerc = ( _ctrlHeight - _toolbarHeight - _nodeDomHeight ) / ( _crumbChildren.length * _nodeDomHeight );
        settings.initialScrollOffset = 0;
        settings.id = 'bc_';
        if ( _isBCVerticalScrollbarCreated ) {
            _scrollBCVerticalHandler.remove();
            settings.initialScrollOffset = ( _prevBCScrollPerc * _vBCScrollHeight ) / ( settings.endValue );
        }
        topValue = 0;
        _scrollBCVerticalHandler.createScrollBar( settings, left, topValue, _bcParentGrp, _scrollCallBackBC, false );
        _isBCVerticalScrollbarCreated = true;
    },

    _createHorizontalScrollBar = function () {
        var
        left = 0, settings = {}, viewPortHeight, stylePropObj = _data.stylePropObj,
        topValue = _data.CtrlHeight + _nodeHeight - _data.ToolbarPart.border.topVal - ( 50 + stylePropObj.ScrollBar.TopPadding );
        _hScrollbarHeight = stylePropObj.ScrollBar.Width;
        settings.currentStyle = _data.currentStyle;
        settings.width = _data.CtrlWidth;
        viewPortHeight = _ctrlHeight - _urlPartTotalHeight + _data.Top - _toolbarHeight - _searchComboBoxPartHeight;
        if ( _isScrollbarCreated ) {
            settings.width = settings.width - stylePropObj.ScrollBar.Width;
        }
        if ( _isAlarmsPresent ) {
            settings.width = settings.width - CPM.Enums.Constants.alarmIconWidth;
        }
        _iconTextGroup = _nodeHandler.getIconTextGroup();
        if ( _iconTextGroup ) {
            _iconTextGroupMatrix = _iconTextGroup.transform.baseVal.getItem( 0 ).matrix;
        }
        //Do not create horizontal scrollbar if deepest node width of tree is within viewport width or if viewport height is lesser than the node height i.e. height of one tree node.
        if ( _deepestNodeWidth < settings.width || viewPortHeight < _nodeHeight ) {
            if ( _isHorizontalScrollbarCreated ) {
                _scrollHorizontalHandler.remove();
                _isHorizontalScrollbarCreated = false;
                _iconTextGroupMatrix.e = 0;
            }
            return;
        } else {
            settings.horizontalSliderHeight = _hScrollbarHeight;
            settings.height = _hScrollbarHeight;
            _hScrollWidth = settings.endValue = _deepestNodeWidth - settings.width;
            _hScrollStep = settings.scrollStep = ( 1 / settings.endValue ) * 10;
            settings.initialHeightPerc = ( settings.width ) / ( _deepestNodeWidth );
            settings.initialScrollOffset = 0;
            if ( _isHorizontalScrollbarCreated ) {
                _scrollHorizontalHandler.remove();
                if ( _horizontalInitialScrollOffset ) {
                    settings.initialScrollOffset = _horizontalInitialScrollOffset;
                }
                _isHorizontalScrollbarCreated = false;
                _iconTextGroupMatrix.e = 0;
            }
            _isHorizontalScrollbarCreated = true;
            _scrollHorizontalHandler.createScrollBar( settings, left, topValue, _svgParent, _scrollCallBackHoriz, true, _horizontalLine );
        }
    },

    _setHorizontalLineVal = function () {
        if ( _isScrollbarCreated && _isHorizontalScrollbarCreated && _isAlarmsPresent ) {
            _horizontalLine = true;
        } else {
            _horizontalLine = false;
        }
    },

    _getNodeDomHeight = function () {
        return _nodeHeight;
    },

    //update Parent Dims
    _updateParentDims = function () {
        var treeControl, treeViewPortHeight;
        if ( _svgParent ) {
            treeControl = _svgParent.firstElementChild; //TODO:Remove hard coded id
            if ( treeControl && treeControl.getBBox ) {
                treeViewPortHeight = _urlPartTotalHeight + ( ( _count ) * _nodeHeight );
                _applyResize( treeViewPortHeight );
            }
        }
    },

    _toRGBA = function ( num ) {
        /*jslint bitwise: true */
        num >>>= 0;
        var b = num & 0xFF,
        g = ( num & 0xFF00 ) >>> 8,
        r = ( num & 0xFF0000 ) >>> 16,
        a = ( ( num & 0xFF000000 ) >>> 24 ) / 255;
        /*jslint bitwise: false */

        return 'rgba(' + [r, g, b, a].join( ',' ) + ')';
    },

    _isNodeInViewport = function ( index ) {
        if ( index >= _scrollCount && ( index < _vpNodeCount + _scrollCount ) ) {
            return true;
        } else {
            return false;
        }
    },

    _traverseRawdata = function ( nodeObj, parentNode ) {
        var i = 0, childName, node = {}, formattedNode,
        children,
        child,
        childCount,
        prevIndexAtDepth = 0;
        prevIndexAtDepth = node.index = _count++;
        node.Name = nodeObj[0];

        node.Id = nodeObj[1];
        if ( nodeObj[5] ) {
            node.InstanceId = nodeObj[5];
        }
        node.ChildCount = nodeObj[3];
        node.fullPath = nodeObj[2];
        if ( nodeObj[5] === '0.0.0.0.0.0' ) {
            node.IsLinked = false;
        } else {
            node.IsLinked = true;
        }
        node.IsExpanded = false;
        node.IsLeaf = true;
        node.ParentId = nodeObj.ParentId;
        if ( nodeObj.depth === undefined || nodeObj.depth === null ) {
            node.depth = 0;
        }
        else {
            node.depth = nodeObj.depth;
        }
        if ( nodeObj.length > 6 && nodeObj[6].length > 0 ) {//Children array is sent at the 6th index from server
            children = nodeObj[6].splice( 0 );
            node.Children = [];
            node.IsExpanded = true;
            node.IsLeaf = false;
        }
        if ( node.ChildCount > 0 ) {
            node.IsLeaf = false;
        }
        node.height = TEXT_BBOX.height;
        if ( children ) {
            childCount = children.length;
            for ( i = 0; i < childCount; i++ ) {
                child = children[i];
                child.ParentId = node.Id;
                child.prevIndexAtDepth = prevIndexAtDepth;
                if ( node.IsExpanded === true ) {
                    child.depth = node.depth + 1;
                    if ( child.depth >= _deepestIdx ) {
                        _deepestNode = child[1];
                        _deepestIdx = child.depth;
                        childName = child[0];
                    }
                }
                formattedNode = _traverseRawdata( child, node );
                formattedNode.Parent = node;
                node.Children.push( formattedNode );
                prevIndexAtDepth = child.index;
            }
        }
        if ( !node.Parent && parentNode ) {
            node.Parent = parentNode;
        }
        node.isSelected = false;
        if ( _prevNodeSelected && _prevNodeSelected.Id === node.Id ) {
            node.isSelected = true;
        }
        return node;
    },

    _unloadBreadCrumb = function () {
        _crumbChildren = [];
        _showCrumb = false;
        _treeGroup.setAttribute( 'fill-opacity', '1' );
        _treeAlarmIconGroup.setAttribute( 'fill-opacity', '1' );
        _searchComboBoxGroup.setAttribute( 'fill-opacity', '1' );
        _clickedURLNodeId = null;
        _isBreadCrumbCreated = false;
        _prevHoveredNodeId = null;
        if ( _isBCVerticalScrollbarCreated ) {
            _isBCVerticalScrollbarCreated = false;
            _scrollBCVerticalHandler.remove();
            _breadcrumbGroupMatrix.f = 0;
            _prevBCScrollPerc = 0;
        }
        _breadCrumb.unloadBreadCrumb();
        _breadCrumb.updateNodeImage();   // reset the arrow of URL part if empty area of viewport is clicked
    },
    _getBgAttributes = function () {
        var data = {}, count, nodeHeight;
        nodeHeight = _getNodeDomHeight();
        count = ( _data.CtrlHeight - _urlPartTotalHeight - _toolbarHeight - _searchComboBoxPartHeight ) / nodeHeight;
        //Checking if the total count of bg rects is a whole number. If its whole number then all the bg rects are drawn completely. Hence scrolling should not be adjusted.
        //If the count contains decimal values that means the last bg rect is partially drawn. Hence we add an extra scroll step to the scrollbar so that the last node data is fully displayed on last scroll.
        if ( count !== Math.floor( count ) ) {
            _addExtraScroll = true;
        } else {
            _addExtraScroll = false;
        }
        data.nodeHeight = nodeHeight;
        _vpNodeCount = Math.ceil( count ); //needed for vertical scrollbar
        //we are not considering height of toolbar, breadcrumb, search combobox because setting _treeGroupMatrix.f after creation of all the groups
        //creating extra bgrects than required especially for handling dynamization(hide Toolbar and breadcrumb) to avoid remove and creation of rects
        data.count = Math.ceil( _data.CtrlHeight / nodeHeight );
        data.Top = _data.Top;
        data.ToolbarHeight = _data.ToolbarPart.border.height;
        data.UrlHeight = _data.URLPart.border.height;
        data.SearchComboBoxHeight = _data.SearchComboBoxPart.border.height;
        data.Left = _data.Left;
        data.SelectionBackColor = _data.SelectionBackColor;
        data.SelectionForeColor = _data.SelectionForeColor;
        data.Width = _data.Width;
        data.white = _data.white;
        data.grey3 = _data.grey3;
        data.HorizLineColor = _data.HorizLineColor;
        data.ExpCollIconColor = _data.ExpCollIconColor;
        data.NodeIconColor = _data.NodeIconColor;
        data.SelectionNodeIconColor = _data.SelectionNodeIconColor;
        return data;
    },

    _createBgRects = function () {
        var attrs;
        _treeGroup = document.getElementById( 'treeGroup' );
        _treeGroupMatrix = _treeGroup.transform.baseVal.getItem( 0 ).matrix;
        _treeAlarmIconGroup = document.getElementById( 'treeAlarmIconGroup' );
        attrs = _getBgAttributes();
        _nodeHandler.createBgRects( _treeGroup, attrs );
        _treeGroupMatrix.f = _toolbarHeight + _urlPartTotalHeight + _searchComboBoxPartHeight;
    },

    _updateBgRects = function () {
        while ( _treeGroup.firstChild ) {
            _treeGroup.removeChild( _treeGroup.lastChild );
        }
        _createBgRects();
    },

    _createAlarmBgRects = function () {
        var attrs;
        attrs = _getBgAttributes();
        _nodeHandler.createAlarmBgRects( _treeAlarmIconGroup, attrs );
    },

    _removeAlarmBgRects = function () {
        while ( _treeAlarmIconGroup.firstChild ) {
            _treeAlarmIconGroup.removeChild( _treeAlarmIconGroup.lastChild );
        }
    },

    _createBCRects = function () {
        var data = {}, urlPartGroupCreated;
        urlPartGroupCreated = document.getElementById( 'URLPart' );
        if ( urlPartGroupCreated ) {
            _breadCrumb.updateNodeURL( _data.URLPart );
        } else {
            data.Left = _data.Left;
            data.Top = _data.ToolbarPart.border.height;
            data.Width = _data.Width;
            data.stylePropObj = _data.stylePropObj;
            data.BackColor = _data.BackColor;
            data.imageWidth = _data.URLPart.imageIconRect.width;
            data.imageHeight = _data.URLPart.imageIconRect.height;
            data.nodeHeight = _getNodeDomHeight();
            data.urlHeight = _data.URLPart.border.height;
            data.borderWidth = _data.URLPart.border.width;
            data.strokeWidth = _data.URLPart.border.strokeWidth;
            data.Font = _data.Font;
            _breadCrumb.createBCRects( _treeControlGroup, _urlGroup, data );
            _breadCrumb.createURLPart( _data.URLPart );
        }
        if ( _showBreadCrumb ) {
            _urlGroup.setAttribute( 'display', 'block' );
        } else {
            _urlGroup.setAttribute( 'display', 'none' );
        }
        _urlGroupMatrix.f = _data.ToolbarPart.border.height;
    },

    _updateTreeComponents = function () {
        var count, nodeHeight = _getNodeDomHeight();
        count = ( _data.CtrlHeight - _urlPartTotalHeight - _toolbarHeight - _searchComboBoxPartHeight ) / nodeHeight;
        _vpNodeCount = Math.ceil( count );
        _updateSearchComboBox();
        _setForUpdate();
    },

    _showBreadcrumbArea = function () {
        _urlPartTotalHeight = _data.URLPart.border.height = CPM.Enums.Constants.urlHeight;
        if ( _urlGroup ) {
            _urlGroup.setAttribute( 'display', 'block' );
        }
        if ( _showToolBar ) {
            _urlGroupMatrix.f = CPM.Enums.Constants.toolbarHeight;
            _treeGroupMatrix.f = CPM.Enums.Constants.toolbarHeight + CPM.Enums.Constants.urlHeight + _searchComboBoxPartHeight;
        } else {
            _urlGroupMatrix.f = 0;
            _treeGroupMatrix.f = CPM.Enums.Constants.urlHeight + _searchComboBoxPartHeight;
        }
    },

    _hideBreadcrumbArea = function () {
        _urlPartTotalHeight = _data.URLPart.border.height = 0;
        if ( _urlGroup ) {
            _urlGroup.setAttribute( 'display', 'none' );
        }
        if ( _showToolBar ) {
            _treeGroupMatrix.f = CPM.Enums.Constants.toolbarHeight + _searchComboBoxPartHeight;
        } else {
            _treeGroupMatrix.f = _searchComboBoxPartHeight;
        }
    },

    _createFilterRects = function () {
        var yVal, xVal, stroke, top;
        top = _data.ToolbarPart.border.height + _data.URLPart.border.height;
        yVal = top;
        xVal = 0;
        _isFilterRectsCreated = true;
        if ( _createFilter && _data.CtrlWidth < ( ( 2 * CPM.Enums.Constants.searchComboBoxMinWidth ) + ( 3 * CPM.Enums.Constants.searchComboBoxPadding ) ) ) {
            if ( _searchComboBoxPartHeight !== ( 2 * CPM.Enums.Constants.searchBackRectHeight ) - CPM.Enums.Constants.searchComboBoxPadding ) {
                _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = ( 2 * _data.SearchComboBoxPart.border.height ) - CPM.Enums.Constants.searchComboBoxPadding;
            }
            _moveBelow = true;
        } else {
            _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = CPM.Enums.Constants.searchBackRectHeight;
            _moveBelow = false;
        }
        CPM.svgUtil.createSVG( 'rect', {
            x: xVal,
            y: yVal,
            id: 'searchComboBoxRect',
            width: ( _data.CtrlWidth - xVal ) < 0 ? 0 : _data.CtrlWidth - xVal,
            height: _data.SearchComboBoxPart.border.height,
            fill: _data.stylePropObj.Control.EvenBackColor,
            appendTo: _searchComboBoxGroup
        } );
        if ( _isExtendedStyle ) {
            stroke = _data.stylePropObj.ToolBar.BottomLineColor;
        } else {
            stroke = _data.stylePropObj.Control.HorizLineColor;
        }
        CPM.svgUtil.createSVG( 'line', {
            id: 'searchComboBoxLine',
            x1: 0,
            y1: top + _data.SearchComboBoxPart.border.height,
            x2: _data.CtrlWidth,
            y2: top + _data.SearchComboBoxPart.border.height,
            stroke: stroke,
            'stroke-width': 1,
            appendTo: _searchComboBoxGroup
        } );
    },
    _updateFilterRects = function () {
        var topVal, rect, line;
        rect = _svgParent.getElementById( 'searchComboBoxRect' );
        line = _svgParent.getElementById( 'searchComboBoxLine' );
        if ( _createFilter && _data.CtrlWidth < ( ( 2 * CPM.Enums.Constants.searchComboBoxMinWidth ) + ( 3 * CPM.Enums.Constants.searchComboBoxPadding ) ) ) {
            if ( _searchComboBoxPartHeight !== ( 2 * CPM.Enums.Constants.searchBackRectHeight ) - CPM.Enums.Constants.searchComboBoxPadding ) {
                _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = ( 2 * _data.SearchComboBoxPart.border.height ) - CPM.Enums.Constants.searchComboBoxPadding;
            }
            _moveBelow = true;
        } else {
            _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = CPM.Enums.Constants.searchBackRectHeight;
            _moveBelow = false;
        }
        topVal = _data.ToolbarPart.border.height + _data.URLPart.border.height;
        _data.SearchComboBoxPart.border.width = _data.CtrlWidth;
        if ( rect ) {
            rect.setAttribute( 'height', _searchComboBoxPartHeight );
            rect.setAttribute( 'y', topVal );
            rect.setAttribute( 'width', _data.CtrlWidth );
        }
        if ( line ) {
            line.setAttribute( 'y1', ( topVal + _searchComboBoxPartHeight ) );
            line.setAttribute( 'y2', ( topVal + _searchComboBoxPartHeight ) );
            line.setAttribute( 'x2', _data.CtrlWidth );
        }
    },
    _removeFilterRects = function () {
        _isFilterRectsCreated = false;
        while ( _searchComboBoxGroup && _searchComboBoxGroup.firstChild ) {
            if ( _searchComboBoxGroup.firstChild.id === '_comboBoxElementsGroup' ) {
                break;
            }
            else {
                _searchComboBoxGroup.removeChild( _searchComboBoxGroup.firstChild );
            }
        }
    },
    _updateBCStyle = function () {
        if ( _breadCrumb ) {
            _breadCrumb.updateBCStyle( _data.stylePropObj );
        }
    },
    _showToolbarLine = function () {
        var bottomLine = false;
        if ( _showToolBar && !_showBreadCrumb ) {
            bottomLine = true;
        }
        return bottomLine;
    },
    //Creates toolbar expand, collapse buttons and background rect behind those buttons
    _createToolbar = function () {
        var data = {}, bottomLine = false;
        data.Left = _data.Left;
        data.white = _data.stylePropObj.Control.EvenBackColor;
        data.ToolbarPart = _data.ToolbarPart;
        data.Enabled = _data.Enabled;
        data.isExtendedStyle = _isExtendedStyle;
        data.pressedbuttonStyles = { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.ButtonPressed ) : _data.stylePropObj.ComboBox.PressedbuttonColor };
        data.filterBtnState = _showSearchComboBox ? 1 : 0;
        data.Width = _data.CtrlWidth;
        bottomLine = _showToolbarLine();
        _toolbar.createToolbar( _treeControlGroup, _toolbarGroup, data, bottomLine );
        if ( _showToolBar ) {
            _toolbarGroup.setAttribute( 'display', 'block' );
        } else {
            _toolbarGroup.setAttribute( 'display', 'none' );
        }
    },

    _showToolbarArea = function () {
        _toolbarHeight = _data.ToolbarPart.border.height = CPM.Enums.Constants.toolbarHeight;
        if ( _toolbarGroup ) {
            _toolbarGroup.setAttribute( 'display', 'block' );
        }

        if ( _showBreadCrumb ) {
            _urlGroupMatrix.f = CPM.Enums.Constants.toolbarHeight;
            _treeGroupMatrix.f = CPM.Enums.Constants.toolbarHeight + CPM.Enums.Constants.urlHeight + _searchComboBoxPartHeight;
        } else {
            _treeGroupMatrix.f = CPM.Enums.Constants.toolbarHeight + _searchComboBoxPartHeight;
        }
    },

    _hideToolbarArea = function () {
        _toolbarHeight = _data.ToolbarPart.border.height = 0;
        if ( _toolbarGroup ) {
            _toolbarGroup.setAttribute( 'display', 'none' );
        }
        if ( _showBreadCrumb ) {
            _urlGroupMatrix.f = 0;
            _treeGroupMatrix.f = CPM.Enums.Constants.urlHeight + _searchComboBoxPartHeight;
        } else {
            _treeGroupMatrix.f = _searchComboBoxPartHeight;
        }
    },
    _updateToolBarStyles = function ( currentStyle ) {
        var bottomLine = false, pressedbuttonStyles;
        bottomLine = _showToolbarLine();
        pressedbuttonStyles = { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.ButtonPressed ) : _data.stylePropObj.ComboBox.PressedbuttonColor };
        if ( _toolbar ) {
            _toolbar.updateToolBarStyles( currentStyle, bottomLine, pressedbuttonStyles );
        }
    },
    _callbackOnSelect = function ( data ) {
        var values = _getValues( _options );
        if ( _selectedFilter === values[data] ) {
            return;//Do nothing if the filter is already applied.
        }
        _selectedFilter = values[data];
        if ( _selectedFilter === _options['TBID_NODE_PENDINGALARMS'] ) {
            WebCC.Properties.Filter = CPM.Enums.Filter.NodeWithPendingAlarms;
        } else if ( _selectedFilter === _options['TBID_NODE_VISUALIZATION'] ) {
            WebCC.Properties.Filter = CPM.Enums.Filter.NodeWithVisualization;
        } else {
            WebCC.Properties.Filter = CPM.Enums.Filter.None;
        }

        _filterComboBox.setSelectedOption( _selectedFilter );
        self.filter();
    },
    _updateSearchComboBoxStyle = function () {
        var bgRect, line, stroke;
        bgRect = _svgParent.getElementById( 'searchComboBoxRect' );
        line = _svgParent.getElementById( 'searchComboBoxLine' );
        if ( bgRect ) {
            bgRect.setAttribute( 'fill', _data.stylePropObj.Control.EvenBackColor );
        }
        if ( line ) {
            if ( _isExtendedStyle ) {
                stroke = _data.stylePropObj.ToolBar.BottomLineColor;
            } else {
                stroke = _data.stylePropObj.Control.HorizLineColor;
            }
            line.setAttribute( 'stroke', stroke );
        }
    },
    _updateComboBoxStyle = function () {
        var styles;
        if ( _filterComboBox ) {
            styles = {
                comboBoxStyles: { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.IOFieldNormal ) : _data.stylePropObj.ComboBox.ComboBoxColor },
                normalbuttonStyles: { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.ButtonNormal ) : _data.stylePropObj.ComboBox.NormalbuttonColor },
                pressedbuttonStyles: { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.ButtonPressed ) : _data.stylePropObj.ComboBox.PressedbuttonColor }
            };
            _filterComboBox.updateComboBoxStyle( _data.currentStyle, styles );
        }
    },
    _registerAndSetLocale = function () {
        WebCC.Extensions.X_Textbib.registerTextResource( 'CPM' );
        WebCC.Extensions.X_Textbib.setLocale( 1033 );
    },
    _createFilterDropDown = function () {
        var attributes = {};
        if ( navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            setTimeout( function () {
                _registerAndSetLocale();
            }, 0 );
        } else {
            _registerAndSetLocale();
        }
        _options['TBID_NONE'] = WebCC.Extensions.X_Textbib.getText( 'TBID_NONE' );
        if ( _alarmComapnion && _alarmComapnion.length > 0 ) {
            _options['TBID_NODE_PENDINGALARMS'] = WebCC.Extensions.X_Textbib.getText( 'TBID_NODE_PENDINGALARMS' );
        }
        if ( _screenWindowCompanion && _screenWindowCompanion.length > 0 ) {
            _options['TBID_NODE_VISUALIZATION'] = WebCC.Extensions.X_Textbib.getText( 'TBID_NODE_VISUALIZATION' );
        }
        _filterComboBox.setOptions( _getValues( _options ) );
        attributes = _getFilterComboBoxAttributes();
        _filterComboBox.draw( _searchComboBoxGroup, attributes, 400 );
        switch ( WebCC.Properties.Filter ) {
            case CPM.Enums.Filter.NodeWithPendingAlarms:
                _selectedFilter = _options['TBID_NODE_PENDINGALARMS'];
                break;
            case CPM.Enums.Filter.NodeWithVisualization:
                _selectedFilter = _options['TBID_NODE_VISUALIZATION'];
                break;
            default:
                _selectedFilter = _options['TBID_NONE'];
                break;
        }
        _filterComboBox.setSelectedOption( _selectedFilter );
    },
    _getComboBoxWidth = function ( width ) {
        width = ( width / 2 ) - CPM.Enums.Constants.searchBoxLeftPadding;
        width = width <= CPM.Enums.Constants.searchComboBoxMinWidth ? CPM.Enums.Constants.searchComboBoxMinWidth : width;
        return width;
    },
    _getFilterComboBoxAttributes = function () {
        var width, top, left, comboPadding = CPM.Enums.Constants.searchComboBoxPadding, attributes, topCbOptions;
        if ( _moveBelow ) {
            width = _data.Width - ( 2 * comboPadding );
            top = _data.ToolbarPart.border.height + _data.URLPart.border.height + CPM.Enums.Constants.searchBoxTopPadding + CPM.Enums.Constants.searchBackRectHeight - comboPadding;
            left = comboPadding;
        } else {
            width = _getComboBoxWidth( _data.Width );
            top = _data.ToolbarPart.border.height + _data.URLPart.border.height + CPM.Enums.Constants.searchBoxTopPadding;
            left = _data.Width - width - comboPadding;
        }
        topCbOptions = _data.ToolbarPart.border.height + _data.URLPart.border.height + _data.SearchComboBoxPart.border.height;
        attributes = {
            height: _data.SearchComboBoxPart.border.buttonHeight,
            left: left,
            optionsLeft: left,
            optionsWidth: width,
            top: top,
            width: width,
            ctrlHeight: _data.CtrlHeight,
            topCbOptions: topCbOptions
        };
        return attributes;
    },
    _createSearchBox = function () {
        var attrs = {};
        attrs.left = _data.Left;
        attrs.toolbarHeight = _data.ToolbarPart.border.height;
        attrs.urlHeight = _data.URLPart.border.height;
        attrs.width = _data.CtrlWidth;
        attrs.currentStyle = _data.currentStyle;
        attrs.isComboBoxBelow = _moveBelow;
        _searchBox.create( _divParent, attrs );
    },

    _retainCheckByFilterAndSearch = function ( node, currentFilterData, comparableOperand ) {
        var child,
        length,
        children;

        if ( node ) {
            node.canRetain = false;
            children = node.Children || [];
            length = children.length;

            while ( length-- ) {
                child = children[length];

                if ( !child.IsLeaf ) {
                    _retainCheckByFilterAndSearch( child, currentFilterData, comparableOperand );
                }
                else {
                    child.canRetain = false;
                }

                if ( currentFilterData[child.fullPath] === comparableOperand ) {
                    if ( child.IsLeaf ) {
                        child.canRetain = child.hasSearchText;
                    }
                }
                else {
                    child.canRetain = false;
                }

                if ( !node.canRetain && child.canRetain ) {
                    node.canRetain = true;
                }
            }
            if ( node.canRetain && node.Parent ) {
                node.Parent.canRetain = true;
            }
        }
    },

    _markByFilterAndSearch = function () {
        if ( _data.NodePart.length ) {
            if ( _selectedFilter === _options['TBID_NODE_PENDINGALARMS'] && _alarmData && Object.keys( _alarmData ).length !== 0 ) {
                _retainCheckByFilterAndSearch( _data.NodePart[0], _alarmData.ActiveAlarms, 1 );
            }
            else {
                if ( _selectedFilter === _options['TBID_NODE_VISUALIZATION'] && _screenData && Object.keys( _screenData ).length !== 0 ) {
                    _retainCheckByFilterAndSearch( _data.NodePart[0], _screenData.ScreenFilter, 0 );
                }
            }
        }
    },

    _setBeforeTraverse = function () {
        var node, parentNode;
        _count = 0;
        _linearDataArray = [];

        if ( _selectedFilter !== _options['TBID_NONE'] ) {
            _markByFilterAndSearch();
        }

        if ( _navigationType === CPM.Enums.NavigationType.Dynamic && _navigatedNodeId ) {
            node = _getNodeData( _navigatedNodeId );
            if ( node ) {
                if ( node.IsLeaf ) {
                    parentNode = _getNodeData( node.ParentId );
                    if ( parentNode ) {
                        _traverse( parentNode );
                    }
                } else {
                    node.depth = 0;
                    if ( _svgParent && _svgParent.TifProperties ) {
                        _svgParent.TifProperties.item.nodeId = _navigatedNodeId;
                    }
                    _traverse( node );
                }
            }
        } else {
            _traverse( _data.NodePart[0] );
        }
    },

    _updateNodeBBox = function ( nodeBBoxInfo ) {
        if ( nodeBBoxInfo ) {
            _deepestNodeWidth = nodeBBoxInfo.nodeWidth;
            TEXT_BBOX = nodeBBoxInfo.textBBox;
            _createHorizontalScrollBar();
        }
    },

    _setRootNode = function () {
        var paramValues, paramIds;
        if ( _rootNode !== '' ) {
            _updateRootNode( _rootNode );
        }
        else {
            paramValues = [CPM.Enums.BrowsingMode.Hierarchies];
            paramIds = [0];
            WebCC.Extensions.HMI.DomainLogic.sendDLEvent( paramIds, paramValues );
        }
    },

    _setForUpdate = function ( alarmData ) {
        var nodeBBoxInfo,
        isResetScrollIndexReq = false;
        if ( !_scrollCount ) {
            isResetScrollIndexReq = true;
        }
        nodeBBoxInfo = _nodeHandler.updateBgRects( _linearDataArray, isResetScrollIndexReq, _data, _isAlarmsPresent );
        if ( nodeBBoxInfo ) {
            _deepestNodeWidth = nodeBBoxInfo.nodeWidth;
            _createHorizontalScrollBar();
        }
        _createVerticalScrollBar();
        _setHorizontalLineVal();
        _nodeHandler.updateAlarmSummary( alarmData, _data, _isScrollbarCreated, _isAlarmsPresent, _horizontalLine );
        if ( _tbUpdateRequired && _prevNodeSelected ) {
            _tbUpdateRequired = false;
            _updateToolbarButtons( _prevNodeSelected );
        }
    },

    _resetScrollCount = function ( nodeData ) {
        var nodeBBoxInfo;
        if ( _count > _vpNodeCount ) {
            if ( nodeData.index < ( _count - _vpNodeCount ) ) {
                _scrollCount = nodeData.index;
            }
            else {
                _scrollCount = Math.round( _count - _vpNodeCount );
            }
        }
        _setHorizontalLineVal();
        nodeBBoxInfo = _nodeHandler.onScroll( _scrollCount, _data, _isScrollbarCreated, _isAlarmsPresent, _horizontalLine );
        _updateNodeBBox( nodeBBoxInfo );
        _createVerticalScrollBar();
        _unloadBreadCrumb();
    },

    _resetTree = function () {
        var selectedNode;
        if ( _selectedNodeId ) {
            selectedNode = _getNodeData( _selectedNodeId );
            selectedNode.isSelected = false;
            _nodeHandler.setSelectedNode( selectedNode, _data, _isAlarmsPresent, _horizontalLine );
            _selectedNodeId = undefined;
        }
        _prevNodeSelected = null;
        _prevSelectedCrumbNode = null;
        _prevSelectedBCNodeId = null;
        _deepestNodeWidth = 0;
        if ( _iconTextGroupMatrix ) {
            _iconTextGroupMatrix.e = 0;
        }
        _horizontalInitialScrollOffset = 0;
        _scrollCount = 0;
        _unloadBreadCrumb();
        _updateURLData( _data.NodePart[0] );
    },

    _sendSummaryInfo = function ( nodeData ) {
        var nodePath, paramValues, filterString, index, companionCount = _alarmComapnion.length;
        if ( _alarmComapnion && companionCount > 0 ) {
            if ( !nodeData ) {
                nodePath = _data.NodePart[0].fullPath;
                paramValues = [9, 'Area = \'' + nodePath + '\'' + ' OR Area LIKE \'' + nodePath + '/*\''];
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1], paramValues );
            }
            else {
                nodePath = nodeData.fullPath;
                // nodePath = nodePath.split( '\\' ).join( '\\\\' );
                for ( index = 0; index < companionCount; index++ ) {
                    filterString = 'Area = \'' + nodePath + '\'' + ' OR Area LIKE \'' + nodePath + '/*\'';
                    if ( _alarmComapnion[index].CompanionConfig && _alarmComapnion[index].CompanionConfig.AlarmClassFilter ) {
                        filterString = filterString + ' AND ' + _alarmComapnion[index].CompanionConfig.AlarmClassFilter;
                    }
                    paramValues = [10,
                        CPM.Enums.CompanionTypes.Alarm,
                        _alarmComapnion[index].ControlRef,
                        filterString
                    ];

                    WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1, 2, 3], paramValues );
                }
            }
        }
    },

    _setScreenCompanions = function () {
        var idx, length = WebCC.Properties.Companions.length, control;
        for ( idx = 0; idx < length; idx++ ) {
            control = WebCC.Properties.Companions[idx];
            if ( control && control.ControlRef ) {
                if ( control.ControlType === 'AlarmControl' && control.CompanionConfig && control.CompanionConfig.ShowAlarmSummary ) {
                    _alarmComapnion.push( control );
                    if ( !_createFilter ) {
                        _createFilter = true;
                    }
                }
                else if ( control.ControlType === 'ScreenWindow' ) {
                    _screenWindowCompanion.push( control );
                    if ( !_createFilter ) {
                        _createFilter = true;
                    }
                }
                else {
                    if ( control.ControlType === 'Calendar Control' ) {
                        _shcCompanion.push( control );
                    }
                }
            }
        }
    },
    _showToolTip = function ( target, position ) {
        var trendIndex, temp, toolTipText, targetText;
        temp = target.id.split( '_' );
        trendIndex = parseInt( temp[temp.length - 1] );

        if ( isNaN( trendIndex ) ) {//Mouse hover on the selected trend in combobox
            if ( target.id === _id + '_ComboBox_OptionNumber_SelectedNode' ) {
                toolTipText = _selectedFilter;
                targetText = target.parentNode.textContent;
            }
        } else {//Mouse hover on the combobox options
            toolTipText = _getValues( _options )[trendIndex];
            targetText = _svgParent.getElementById( _id + '_ComboBox_SvgOptionNode_' + trendIndex ).textContent;
        }
        if ( toolTipText !== targetText ) {
            CPM.Common.Tooltip.show( position.x, position.y, toolTipText );
        }
    },

    _searchOrClearText = function ( isSearch ) {
        var inputText;
        if ( isSearch ) {
            inputText = _searchBox.searchText();
        } else {
            inputText = _searchBox.clearSearch();
        }
        _handleSearchText( inputText );
    },

    _setNavigatedNodeId = function ( nodeId ) {
        var node;
        _navigatedNodeId = nodeId;
        node = _getNodeData( nodeId );
        if ( node ) {
            node.isNodeNavigated = true;
        }
    },

        _getEventHandlers = function () {
            return {
                handleVScrollBar: _handleVScrollBar,
                handleHScrollBar: _handleHScrollBar,
                unloadBreadCrumb: _unloadBreadCrumb,
                toggleVisibility: self.toggleVisibility,
                getNodeData: _nodeHandler.getNodeData,
                setNavigatedNodeId: _setNavigatedNodeId,
                getParent: _getNodeData,
                handleBCVScrollBar: _handleBCVScrollBar,
                handleCBVScrollBar: _handleCBVScrollBar,
                selectNode: _setSelected,
                sendSummaryInfo: _sendSummaryInfo,
                getBCNode: _breadCrumb.getBCNode,
                displayImmediateChildren: _displayImmediateChildren,
                onURLClick: _onURLClick,
                setBgColor: _breadCrumb.setBgColor,
                getCrumbNode: _breadCrumb.getCrumbNode,
                setSelectedFromBC: _setSelectedFromBC,
                expandAll: self.expandAll,
                collapseAll: self.collapseAll,
                onScroll: _onScroll,
                updateNodeImage: _breadCrumb.updateNodeImage,
                updateToolbarColor: _toolbar.updateToolbarColor,
                filterComboBox: _filterComboBox,
                showToolTip: _showToolTip,
                handleSearchText: _handleSearchText,
                toggleFilterButton: self.toggleFilterButton,
                showClearIcon: _searchBox.showClearIcon,
                hideClearIcon: _searchBox.hideClearIcon,
                clearSearch: _searchOrClearText,
                searchForText: _searchOrClearText,
                showInputTextToolTip: _searchBox.showInputTextToolTip
            };
        },

    _setTifLibExpandoProps = function () {
        _svgParent.TifProperties = {
            tif: {},
            item: {
                nodes: _data.NodePart[0],
                navigationType: _navigationType,
                nodeId: ( _navigationType === CPM.Enums.NavigationType.Dynamic ) ? _selectedNodeId : undefined
            }
        };
    },

    _addTifLibExpandoProps = function () {
        _svgParent.TifProperties.item = {
                nodes: _data.NodePart[0],
                findNode: function ( nodeId ) {
                    return _getNodeData( nodeId );
                },
                setFocus: function ( nodeId ) {
                    var nodeData = _getNodeData( nodeId );
                    _resetScrollCount( nodeData );
                },
                navigationType: _navigationType,
                nodeId: ( _navigationType === CPM.Enums.NavigationType.Dynamic ) ? _selectedNodeId : undefined
        };
    },

    _sendDLEventForCompanions = function ( instanceId ) {
        var paramValues, index, companionCount;
        companionCount = _screenWindowCompanion.length;
        if ( _screenWindowCompanion && companionCount > 0 ) {
            for ( index = 0; index < companionCount; index++ ) {
                paramValues = [
                CPM.Enums.BrowsingMode.ScreenWindow,
                CPM.Enums.CompanionTypes.ScreenWindow,
                _screenWindowCompanion[index].ControlRef, instanceId];
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1, 2, 3], paramValues );
            }
        }
        companionCount = _shcCompanion.length;
        if ( _shcCompanion && companionCount > 0 ) {
            for ( index = 0; index < companionCount; index++ ) {
                paramValues = [CPM.Enums.BrowsingMode.AlarmOrSHC,
                   CPM.Enums.CompanionTypes['Calendar Control'],
                   _shcCompanion[index].ControlRef,
                   _selectedNodePath
                ];
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1, 2, 3], paramValues );
            }
        }
    },

    _displayImmediateChildren = function ( event, targetNode, isBreadCrumbCreated ) {
        var nodeData, paramIds, node, paramValues;
        node = _breadCrumb.getBCNode( targetNode );
        _clickedURLNodeId = node.id;
        if ( isBreadCrumbCreated ) {
            _isBreadCrumbCreated = true;
        }
        if ( _isBreadCrumbCreated ) {
            if ( _prevHoveredNodeId !== node.id || _prevHoveredNodeId === null ) {
                _unloadBreadCrumb();
                _showCrumb = true;
                _isBreadCrumbCreated = true;
                nodeData = _getNodeData( node.id );
                paramIds = [CPM.Enums.ObjectCountAttributes.Requested, CPM.Enums.ObjectCountAttributes.TreeOrList, CPM.Enums.ObjectCountAttributes.SystemId, CPM.Enums.ObjectCountAttributes.ObjectId, CPM.Enums.ObjectCountAttributes.SelectedNode, CPM.Enums.ObjectCountAttributes.NameFilter,
                                CPM.Enums.ObjectCountAttributes.PropertyFilter, CPM.Enums.ObjectCountAttributes.LanguageId, CPM.Enums.ObjectCountAttributes.BrowsingMode, CPM.Enums.ObjectCountAttributes.SortingMode, CPM.Enums.ObjectCountAttributes.SortByAttribute];
                paramValues = [8, CPM.Enums.View.Tree, 0, , node.id, , , CPM.Enums.Language.English, CPM.Enums.BrowsingMode.ViewNode, , ]; //4 == VIEWROOT
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( paramIds, paramValues );
                _prevHoveredNodeId = node.id;
            }
            // setting horizontal distance for breadcrumb
            _crumbX = node.x + node.width + ( _data.URLPart.textPadding.left - _data.URLPart.imageIconSvg.width ) / 2;
            _breadCrumb.updateNodeImage( targetNode );
        }
    },

    //fire from templete to get text Dims
    _getTextBBox = function ( text ) {
        var bbox;
        bbox = CPM.svgUtil.getTextBBox( _data.Font, '' + text );
        TEXT_BBOX = bbox;
        return bbox;
    },

    //fire from templete on URL click
    _onURLClick = function ( node ) {
        var nodeData,
        firstViewPortNodeData,
        firstViewPortNode;
        if ( node ) {
            nodeData = _getNodeData( node.id );
            nodeData.isNodeNavigated = true;
            _navigatedNodeId = nodeData.Id;
            _setSelected( nodeData, false, true );
        }
        else {
            firstViewPortNode = _data.URLPart.viewportData[_data.URLPart.viewportData.length - 1];
            if ( firstViewPortNode ) {
                firstViewPortNodeData = _getNodeData( firstViewPortNode.id );
                nodeData = _getNodeData( firstViewPortNodeData.ParentId );
            }
        }
        if ( nodeData ) {
            //update URL Viewport
            _updateURLData( nodeData );
            _resetScrollCount( nodeData );
        }
    },

    _loadData = function ( nodeData, updateUrl ) {
        if ( nodeData.IsExpanded || nodeData.Children ) {
            if ( !nodeData.IsExpanded ) {
                nodeData.IsExpanded = !nodeData.IsExpanded;
            }
            _setBeforeTraverse();
            _setForUpdate();
        } else {
            if ( updateUrl ) {
                _isBCSelectionRequest = true;
            }
            _expandedNodeId = nodeData.Id;
            WebCC.Events.fire( 'onExpand', nodeData.fullPath );
            nodeData.IsExpanded = true;
            _callback( { name: nodeData.fullPath, id: nodeData.Id, isRequestData: true, isHierarchyNode: false } );
        }
    },

    _setSelectedFromBC = function ( crumbNode ) {
        var i, nodeData, child, childCount, parentNode;
        crumbNode.isSelected = true;
        _isNodeUpdated = true;
        if ( _prevSelectedCrumbNode ) {
            if ( _prevSelectedCrumbNode.Id === crumbNode.Id ) {
                return;
            }
            else {
                _prevSelectedCrumbNode.isSelected = false;
            }
        }
        _prevSelectedCrumbNode = crumbNode;
        _prevSelectedBCNodeId = crumbNode.Id;

        nodeData = _getNodeData( crumbNode.Id );
        if ( _navigationType === CPM.Enums.NavigationType.Dynamic && nodeData && nodeData.IsLeaf ) {
            parentNode = _getNodeData( nodeData.ParentId );
            if ( parentNode && parentNode.ParentId ) {
                parentNode.childSelected = true;
            }
        }
        if ( nodeData ) {
            nodeData.isSelected = true;
            if ( _prevNodeSelected ) {
                if ( _prevNodeSelected.Id !== crumbNode.Id ) {
                    _prevNodeSelected.isSelected = false;
                    //If full data is available and the selected node is not expanded, then expand the selected node and update the tree.
                    if ( !_prevNodeSelected.IsExpanded && _prevNodeSelected.Children ) {
                        _prevNodeSelected.IsExpanded = true;
                        childCount = _prevNodeSelected.Children.length;
                        for ( i = 0; i < childCount; i++ ) {
                            child = _prevNodeSelected.Children[i];
                            child.Visible = true;
                        }
                        _setBeforeTraverse();
                        _setForUpdate();
                    }
                } else {
                    return;
                }
            }
            _prevNodeSelected = nodeData;
            _updateToolbarButtons( _prevNodeSelected );
            //update WebCC Properties 
            WebCC.Properties.SelectedNode = _prevNodeSelected.fullPath;
            WebCC.Events.fire( 'onSelectionChanged', nodeData.fullPath );
            _selectedNodePath = nodeData.fullPath;
            _navigatedNodeId = _selectedNodeId = nodeData.Id; //setting selectedNode Id
            nodeData.isNodeNavigated = true;
            _resetScrollCount( nodeData );
            _sendDLEventForCompanions( nodeData.InstanceId );
            if ( _navigationType === CPM.Enums.NavigationType.Dynamic && !nodeData.IsLeaf ) {
                _loadData( nodeData, true );
            }
            // If node selected from breadcrumb is available in viewport, then update URL
            for ( i = 0; i < _linearDataArray.length; i++ ) {
                if ( _linearDataArray[i].Id === _prevNodeSelected.Id ) {
                    _updateURLData( _prevNodeSelected );
                    break;
                }
            }
        } else {//If full data is not available then request the data from server for the selected node.
            WebCC.Events.fire( 'onExpand', _prevNodeSelected.fullPath );
            _prevNodeSelected.IsExpanded = true;
            _isBCUpdateRequired = true;
            _callback( { name: _prevNodeSelected.fullPath, id: _prevNodeSelected.Id, isRequestData: true, isHierarchyNode: false } );
        }
        _breadCrumb.resetDims();
    },

    //fire from templete on node click
        _setSelected = function ( node, isCallReq, unloadBreadCrumb ) {
        var parentNode, i;
        node.isSelected = true;
        if ( _prevNodeSelected ) {
            for ( i = 0; i < _linearDataArray.length; i++ ) {
                if ( _prevNodeSelected.fullPath === _linearDataArray[i].fullPath ) {
                    _prevNodeSelected.index = _linearDataArray[i].index;
                    if ( _prevNodeSelected.Id !== node.Id ) {
                        _linearDataArray[i].isSelected = false;
                    }
                    break;
                }
            }
            if ( _prevNodeSelected.Id !== node.Id ) {
                _prevNodeSelected.isSelected = false;
            }
            else {
                if ( !unloadBreadCrumb ) {
                    _unloadBreadCrumb();
                    _breadCrumb.updateNodeImage();
                }
                return;
            }
            parentNode = _getNodeData( _prevNodeSelected.ParentId );
            if ( parentNode ) {
                if ( parentNode.childSelected ) {
                    parentNode.childSelected = false;
                }
                if ( !node.IsLeaf && _prevNodeSelected.isNodeNavigated ) {
                    _prevNodeSelected.isNodeNavigated = false;
                }
            }
            _nodeHandler.setSelectedNode( _prevNodeSelected, _data, _isAlarmsPresent, _horizontalLine );
        }
        _prevNodeSelected = node;
        _prevSelectedCrumbNode = node;
        //update URL Viewport
        _updateURLData( node );
        //update WebCC Properties
        if ( !isCallReq ) {
            _callback( { name: node.fullPath, id: node.Id, isRequestData: false } );
        }
        WebCC.Properties.SelectedNode = node.fullPath;
        _selectedNodePath = node.fullPath;
        _selectedNodeId = node.Id; //setting selectedNode Id
        _prevSelectedBCNodeId = node.Id;
        if ( !unloadBreadCrumb ) {
            _unloadBreadCrumb();
        }
        WebCC.Events.fire( 'onSelectionChanged', node.fullPath );
        _sendDLEventForCompanions( node.InstanceId );
        _data.SelectionBackColor = _selectionBackColUpdated ? _data.SelectionBackColor : _data.stylePropObj.Control.SelectionBackColor;
        _data.SelectionForeColor = _selectionForeColUpdated ? _data.SelectionForeColor : _data.stylePropObj.Control.SelectionForeColor;
        if ( _navigationType === CPM.Enums.NavigationType.Static || node.IsLeaf || _navigatedNodeId !== _selectedNodeId ) {
            parentNode = _getNodeData( node.ParentId );
            if ( parentNode && parentNode.ParentId ) {
                parentNode.childSelected = true;
            }
            _nodeHandler.setSelectedNode( node, _data, _isAlarmsPresent, _horizontalLine );
        } else {
            if ( _navigationType === CPM.Enums.NavigationType.Dynamic ) {
                _setBeforeTraverse();
                _setForUpdate();
            }
        }
        _updateToolbarButtons( node );
    },

    _updateSearchComboBox = function () {
        var attributes;

        if ( _showSearchComboBox ) {
            if ( !_isFilterRectsCreated ) {
                _createFilterRects();
            }
            else {
                _updateFilterRects();
            }
            if ( _createFilter && _filterComboBox ) {
                attributes = _getFilterComboBoxAttributes();
                _filterComboBox.show();
                _filterComboBox.update( attributes, _ctrlHeight, true );
            }
            _searchBox.updateTopValue( _toolbarHeight + _urlPartTotalHeight );
        } else {
            _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = 0;
            _removeFilterRects();
            if ( _createFilter && _filterComboBox ) {
                _filterComboBox.hide();
            }
            _searchBox.hide();
        }
    },

    //Method to update the toolbar button state for the current selected node
    _updateToolbarButtons = function ( selectedNode ) {
        if ( _toolbar ) {
            if ( selectedNode.IsFullyExpanded ) { //If the selected node is fully expanded, disable expandAll button and enable collapseAll button.
                selectedNode.IsFullyExpanded = false;
                _toolbar.setExpandBtnOpacity( 0.5 );
                _toolbar.setCollapseBtnOpacity( 1 );
            } else {
                if ( selectedNode.IsLeaf ) { //If the selected node is a leaf node, disable both the toolbar buttons.
                    _toolbar.setExpandBtnOpacity( 0.5 );
                    _toolbar.setCollapseBtnOpacity( 0.5 );
                } else if ( !selectedNode.IsExpanded ) { //If the selected node is collapsed, disable collapseAll button and enable expandAll button.
                    _toolbar.setExpandBtnOpacity( 1 );
                    _toolbar.setCollapseBtnOpacity( 0.5 );
                } else {
                    if ( selectedNode.IsExpanded ) {
                        _toolbar.setCollapseBtnOpacity( 1 ); //If the selected node is expanded( not full expand), enable the collapseAll button.
                        _updateExpandBtnStatus( selectedNode ); //Also, check if any of the child node or their child nodes are collapsed. If any child node is collpased, enable the expandAll button else disable it.
                        if ( _enableExpandBtn ) {
                            _enableExpandBtn = false;
                            _toolbar.setExpandBtnOpacity( 1 );
                        } else {
                            _toolbar.setExpandBtnOpacity( 0.5 );
                        }
                    }
                }
            }
        }
    },

    //Method to find if any of the child node under the selected node is collapsed or not.
    _updateExpandBtnStatus = function ( selectedNode ) {
        var childCount, i, child;
        if ( selectedNode.Children && !_enableExpandBtn ) {
            childCount = selectedNode.Children.length;
            for ( i = 0; i < childCount; i++ ) {
                child = selectedNode.Children[i];
                if ( !child.IsLeaf ) {
                    if ( child.IsExpanded ) {
                        _updateExpandBtnStatus( child );
                    } else {
                        _enableExpandBtn = true;
                        return;
                    }
                }
            }
        }
    },

     //Method is called when RootNode is Dynamized
        _updateRootNode = function ( value ) {
            var paramIds, paramValues, inValidNode;
            inValidNode = value.includes( '\\' );
            if ( !inValidNode ) {
                _isRootNodePropertyChanged = true;
                paramValues = [CPM.Enums.BrowsingMode.RootNode, value];
                paramIds = [0];
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( paramIds, paramValues );
            }
    },

     _getValues = function ( obj ) {
         var arr = [];
         //work around for IE as _getValues will not work in IE.
         arr = Object.keys( obj ).map( function ( key ) {
             return obj[key];
         }
         );
         return arr;
     },

    _setFilterText = function ( languageId ) {
        var selectedFilterIndex, key, attributes = {};
        WebCC.Extensions.X_Textbib.setLocale( languageId );
        if ( _createFilter ) {
            for ( key in _options ) {
                if ( _options[key] === _selectedFilter ) {
                    selectedFilterIndex = key;
                    break;
                }
            }
            _options['TBID_NONE'] = WebCC.Extensions.X_Textbib.getText( 'TBID_NONE' );
            if ( _alarmComapnion && _alarmComapnion.length > 0 ) {
                _options['TBID_NODE_PENDINGALARMS'] = WebCC.Extensions.X_Textbib.getText( 'TBID_NODE_PENDINGALARMS' );
            }
            if ( _screenWindowCompanion && _screenWindowCompanion.length > 0 ) {
                _options['TBID_NODE_VISUALIZATION'] = WebCC.Extensions.X_Textbib.getText( 'TBID_NODE_VISUALIZATION' );
            }

            if ( _filterComboBox ) {
                _filterComboBox.setOptions( _getValues( _options ) );
                _selectedFilter = _options[selectedFilterIndex];
                attributes = _getFilterComboBoxAttributes();//Update the combobox dimensions as per new values.
                _filterComboBox.update( attributes, _ctrlHeight, false );
                _filterComboBox.setSelectedOption( _selectedFilter );
            }
        }
    },

    _createTreeComponents = function () {
        _createToolbar();
        _createBCRects();
        if ( !_showBreadCrumb ) {
            _hideBreadcrumbArea();
        }
        if ( _createFilter && _toolbar ) {
            self.filter();
        }
        _createSearchBox();
        _setRootNode();
    };
    /*
    * Function to create the CPM tree control
    * @function
    * @memberOf CPM.App
    * @params{options} control data
    */
    this.createTreeControl = function ( options ) {
        var eventHandlers, desktopLayout = {}, configSelectionBackColor, configSelectionForeColor, styles;
        _svgParent = options.svgParent;
        _data.stylePropObj = CPM.StyleFactory.getCurrentStyleProps( options.currentStyle );
        _data.currentStyle = options.currentStyle;
        _isExtendedStyle = _data.currentStyle.includes( CPM.Enums.StyleName.Extended ) ? true : false;
        _data.URLPart.border.width = options.width - _left - _data.URLPart.border.paddingRight;
        _data.Width = options.width;
        _data.Height = options.height;
        _data.ForeColor = _data.stylePropObj.Control.ForeColor;
        configSelectionBackColor = _toRGBA( options.SelectionBackColor );
        configSelectionForeColor = _toRGBA( options.SelectionForeColor );
        if ( options.SelectionBackColor ) {
            if ( configSelectionBackColor === _toRGBA( _defaultSelectionBackColor ) ) {
                _data.SelectionBackColor = _data.stylePropObj.Control.SelectionBackColor;
            } else {
                _data.SelectionBackColor = configSelectionBackColor;
            }
        } else {
            _data.SelectionBackColor = _data.stylePropObj.Control.SelectionBackColor;
        }
        if ( options.SelectionForeColor ) {
            if ( configSelectionForeColor === _toRGBA( _defaultSelectionForeColor ) ) {
                _data.SelectionForeColor = _data.stylePropObj.Control.SelectionForeColor;
            } else {
                _data.SelectionForeColor = configSelectionForeColor;
            }
        } else {
            _data.SelectionForeColor = _data.stylePropObj.Control.SelectionForeColor;
        }

        _selectedNodePath = options.SelectedNodePath;
        _rootNode = options.RootNode;
        _navigationType = options.NavigationType;
        //new styles added
        _data.white = _data.stylePropObj.Control.EvenBackColor;
        _data.grey3 = _data.stylePropObj.Control.OddBackColor;
        _data.HorizLineColor = _data.stylePropObj.Control.HorizLineColor;
        _data.NodeIconColor = _data.stylePropObj.Control.NodeIconColor;
        _data.SelectionNodeIconColor = _data.stylePropObj.Control.SelectionNodeIconColor;
        _data.ExpCollIconColor = _data.stylePropObj.Control.ExpCollIconColor;
        _data.BaseDir = options.BaseDir || '';
        _cntrlHeightNew = _ctrlHeight = options.height;
        _cntrlWidthNew = options.width;
        _data.CtrlHeight = _ctrlHeight;
        _data.CtrlWidth = options.width;
        _data.rtoId = options.rtoId;
        _data.Enabled = options.Enabled;
        _showToolBar = options.ShowToolBar;
        _showBreadCrumb = options.ShowBreadCrumb;
        _divParent = options.divParent;
        if ( CPM.svgUtil ) {
            CPM.svgUtil.createBBoxItems( options.domParent );
            CPM.svgUtil.setDefaultbBox( _data.Font );
        }
        if ( _showToolBar ) {
            _toolbarHeight = _data.ToolbarPart.border.height = CPM.Enums.Constants.toolbarHeight;
        } else {
            _toolbarHeight = _data.ToolbarPart.border.height = 0;
        }
        if ( _showBreadCrumb ) {
            _urlPartTotalHeight = _data.URLPart.border.height = CPM.Enums.Constants.urlHeight;
        } else {
            _urlPartTotalHeight = _data.URLPart.border.height = 0;
        }
        if ( _showSearchComboBox ) {
            _searchComboBoxPartHeight = _data.SearchComboBoxPart.border.height = CPM.Enums.Constants.searchBackRectHeight;
        } else {
            _searchComboBoxPartHeight = _data.SearchComboBoxPart.border.height = 0;
        }
        _nodeHandler = new CPM.svgNodeHandler( { urlPartTotalHeight: _urlPartTotalHeight, toolbarHeight: _toolbarHeight, searchComboBoxHeight: _searchComboBoxPartHeight } );
        _createBgRects();
        _breadCrumb = new CPM.breadcrumb();
        _toolbar = new CPM.toolbar( _data.currentStyle );
        _comboBoxHandler = new CPM.ComboBoxHandler( _svgParent );
        _searchBox = new CPM.searchBox();
        _treeControlGroup = CPM.svgUtil.createSVG( 'svg', {
            id: 'treeControl',
            appendTo: _svgParent
        } );
        // Create placeholder groups for breadcrumb, toolbar, searchbox and combobox to maintain DOM order
        _toolbarGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'toolbarGroup',
            appendTo: _treeControlGroup
        } );
        _urlGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'urlGroup',
            transform: 'translate(0,0)',
            appendTo: _treeControlGroup
        } );
        _urlGroupMatrix = _urlGroup.transform.baseVal.getItem( 0 ).matrix;
        _scrollbarGrp = CPM.svgUtil.createSVG( 'g', {
            id: 'scrollbarGrp',
            appendTo: _treeControlGroup
        } );
        _searchComboBoxGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'searchComboBoxGroup',
            appendTo: _treeControlGroup
        } );
        _setScreenCompanions();
        if ( !_isFilterRectsCreated ) {
            _createFilterRects();
        }
        if ( _createFilter ) {
            styles = {
                comboBoxStyles: { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.IOFieldNormal ) : _data.stylePropObj.ComboBox.ComboBoxColor },
                normalbuttonStyles: { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.ButtonNormal ) : _data.stylePropObj.ComboBox.NormalbuttonColor },
                pressedbuttonStyles: { fill: _isExtendedStyle ? _comboBoxHandler.getGuideStyles( CPM.Enums.ComboGradients.ButtonPressed ) : _data.stylePropObj.ComboBox.PressedbuttonColor },
            };
            _filterComboBox = new CPM.ComboBox( _id, _callbackOnSelect, undefined, styles, _data.currentStyle );
            _createFilterDropDown();
        }
        _createTreeComponents();
        _setTifLibExpandoProps();
        eventHandlers = _getEventHandlers();
        _eventManager = new CPM.EventManager( _svgParent, eventHandlers, _divParent );
        _eventManager.addEventListeners();
        desktopLayout.domNode = _divParent;
        CPM.Common.Tooltip.createItems( desktopLayout );
    };

   /*
    * Function to handle node expand/collapse events
    * @function
    * @memberOf CPM.App
    * @params{node} node to be expanded or collapsed
    * @params{isCollapseAllEvent} indicates whether the function was called for collapseAll event
    */
    this.toggleVisibility = function ( node, isCollapseAllEvent, onDoubleclick ) {
        var isHierarchyNode = false, childCount, i, child;
        _isExpandAll = false;
        _isCollapseAll = false;
        if ( node.IsLeaf ) {
            if ( onDoubleclick ) {
                _navigatedNodeId = node.Id;
                node.isNodeNavigated = true;
                _setSelected( node, true );//_selectedNodeId = node.Id;
            } else {
                _expandedNodeId = node.Id;
            }
            _callback( { name: WebCC.Properties.SelectedNode, id: node.Id, isRequestData: false } );
            return;
        }
        else {
            if ( node.IsExpanded ) {
                if ( !isCollapseAllEvent ) {
                    WebCC.Events.fire( 'onCollapse', node.fullPath );
                }
                if ( node.Children ) {
                    _count = 0;
                    childCount = node.Children.length;
                    for ( i = 0; i < childCount; i++ ) {
                        child = node.Children[i];
                        if ( isCollapseAllEvent ) {
                            child.IsExpanded = false;
                        }
                        child.Visible = false;
                    }
                    _deepestNodeWidth = 0;
                    _deepestNode = 0;
                }
                node.IsExpanded = !node.IsExpanded;
                _expandedNodeId = null;
                _tbUpdateRequired = true;
                _setBeforeTraverse();
                _setForUpdate();
                _scrollCount = _nodeHandler.getScrollIndex();//Fix for the issue when the scrollbar handler is not adjusted properly on last node's expand/collapse operation.
                if ( !isCollapseAllEvent && onDoubleclick ) {
                    _navigatedNodeId = node.Id;
                    node.isNodeNavigated = true;
                    _setSelected( node, true );//_selectedNodeId = node.Id;
                }
            }
            else {
                /*** FIXME: If hierarchies > 2 are present, send additional flag in node with sibling information and set isHierarchyNode as true ***/
                //if ( _data.NodePart[0] && node.Id === _data.NodePart[0].Id ) {
                //    isHierarchyNode = true;
                //}
                _isNodeUpdated = true;
                WebCC.Events.fire( 'onExpand', node.fullPath );
                node.IsExpanded = !node.IsExpanded;
                if ( onDoubleclick ) {
                    _navigatedNodeId = node.Id;
                    node.isNodeNavigated = true;
                    _setSelected( node, true ); //_selectedNodeId = node.Id;
                } else {
                    _expandedNodeId = node.Id;
                }
                _tbUpdateRequired = true;
                if ( node.Children ) {
                    childCount = node.Children.length;
                    for ( i = 0; i < childCount; i++ ) {
                        child = node.Children[i];
                        child.Visible = true;
                    }
                    _setBeforeTraverse();
                    _setForUpdate();
                } else {
                    _callback( { name: WebCC.Properties.SelectedNode, id: node.Id, isRequestData: true, isHierarchyNode: isHierarchyNode } );
                }
            }
            _updateParentDims();
        }
    };

    /*
    * Function to handle window resize event of cpm tree control
    * @function
    * @memberOf CPM.App
    * @params{height} height of the control
    * @params{width} width of the control
    */
    this.updateView = function ( height, width ) {
        var treeViewPortHeight = 0, attributes = {};
        _data.URLPart.border.width = width - _data.Left - _data.URLPart.border.paddingRight;
        _ctrlHeight = height;
        _cntrlWidthNew = width;
        _svgParent.setAttribute( 'width', ( _cntrlWidthNew + 'px' ) );
        _data.Width = _cntrlWidthNew;
        _data.stylePropObj = CPM.StyleFactory.getCurrentStyleProps( _data.currentStyle );
        treeViewPortHeight = _urlPartTotalHeight + ( ( _count ) * _getNodeDomHeight() );
        if ( height > _cntrlHeightNew || treeViewPortHeight < _cntrlHeightNew ) {
            _cntrlHeightNew = height;
            _svgParent.setAttribute( 'height', _cntrlHeightNew + 'px' );
            _data.Height = _cntrlHeightNew;
        }
        if ( treeViewPortHeight > height ) {
            _cntrlHeightNew = treeViewPortHeight;
            _svgParent.setAttribute( 'height', _cntrlHeightNew + 'px' );
            _data.Height = _cntrlHeightNew;
        }
        _data.CtrlHeight = _ctrlHeight;
        _data.CtrlWidth = _cntrlWidthNew;
        _updateBgRects();
        if ( _isAlarmsPresent ) {
            _removeAlarmBgRects();
            _createAlarmBgRects();
        }
        _setForUpdate();
        _scrollCount = _nodeHandler.getScrollIndex();
        //Updating the scrollbars after updating the tree in case the scroll count is changed while updating the tree.
        _createVerticalScrollBar();
        _createHorizontalScrollBar();
        if ( _showBreadCrumb && _breadCrumb ) {
            _breadCrumb.remove();
            _createBCRects();
            if ( _data.URLPart.data.length > 0 ) {
                _calculateViewPortURLData();
            }
        }
        if ( _showSearchComboBox ) {
            if ( !_isFilterRectsCreated ) {
                _createFilterRects();
            }
            else {
                _updateFilterRects();
            }
        }

        if ( _toolbar ) {
            _toolbar.updateWidth( _data.CtrlWidth );
        }
        if ( _showSearchComboBox && _createFilter && _filterComboBox ) {
            attributes = _getFilterComboBoxAttributes();
            _filterComboBox.show();
            _filterComboBox.update( attributes, _ctrlHeight, true );
        }
        if ( _createFilter && _data.CtrlWidth < ( ( 2 * CPM.Enums.Constants.searchComboBoxMinWidth ) + ( 3 * CPM.Enums.Constants.searchComboBoxPadding ) ) ) {
            _moveBelow = true;
        } else {
            _moveBelow = false;
        }
        _searchBox.updateWidth( _data.CtrlWidth, _moveBelow );
    };

    /*
    * Function to handle expandAll toolbar event
    * @function
    * @memberOf CPM.App
    */
    this.expandAll = function () {
        var
        selectedNode,
        paramIds = [0, 1],
        paramValues = [];
        if ( !_toolbar.isExpandAllEnabled() ) {//Do not do ExpandAll if the button is disabled.
            return;
        }
        if ( !_data.NodePart[0] ) {
            return;//Do not do ExpandAll if no data is available.
        }
        if ( _selectedNodeId && _selectedNodeId !== _data.NodePart[0].Id ) {
            selectedNode = _getNodeData( _selectedNodeId );
            paramValues = [CPM.Enums.BrowsingMode.ExpandNode, _selectedNodeId];
        } else {
            selectedNode = _data.NodePart[0];
            if ( _rootNode !== '' ) {
                paramValues = [CPM.Enums.BrowsingMode.ExpandAll, _data.NodePart[0].Id];//To expand only configured rootnode hierarchy
            } else {
                paramValues = [CPM.Enums.BrowsingMode.ExpandNode, ''];
            }
        }
        if ( selectedNode.IsLeaf ) {
            return;//Do not do ExpandAll if a leaf node is selected.
        }
        if ( !_isExpandAll ) {//if not already expanded
            _isExpandAll = true;
            _isCollapseAll = false;
            _isNodeUpdated = true;
            WebCC.Events.fire( 'onExpandAll', _isExpandAll );
            selectedNode.IsFullyExpanded = true;
            if ( !_isExtendedStyle ) {
                _toolbar.setExpandBtnLine( _isExpandAll );
                _toolbar.setCollapseBtnLine( _isCollapseAll );
            }
            if ( _prevNodeSelected ) {
                _tbUpdateRequired = true;
            } else {
                _updateToolbarButtons( selectedNode );
            }

            if ( _isFullDataPresent ) {
                if ( selectedNode.Id !== _data.NodePart[0].Id ) {
                    _expandAllChildren( selectedNode );
                    _isExpandAll = false;
                }
                _setBeforeTraverse();
                if ( !_isNodeInViewport( selectedNode.index ) ) {
                    _resetScrollCount( selectedNode );//If the selected node is outside the VP, reset the scroll index.
                }
                _createVerticalScrollBar();
                _setForUpdate();
                _createHorizontalScrollBar();
            } else {
                selectedNode.Children = [];
                if ( selectedNode.Id === _data.NodePart[0].Id ) {
                    _resetTree();
                    _isFullDataPresent = true;
                }
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( paramIds, paramValues );
            }
        }
    };

    /*
    * Function to handle collapseAll toolbar event
    * @function
    * @memberOf CPM.App
    */
    this.collapseAll = function () {
        var
        selectedNode;
        if ( !_toolbar.isCollapseAllEnabled() ) {//Do not do CollapseAll if the button is disabled.
            return;
        }
        if ( !_data.NodePart[0] ) {
            return;//Do not do CollapseAll if no data is available.
        }
        if ( _selectedNodeId ) {
            selectedNode = _getNodeData( _selectedNodeId );
        } else {
            selectedNode = _data.NodePart[0];
        }
        if ( selectedNode.IsLeaf ) {
            return;//Do not do CollapseAll if a leaf node is selected.
        }
        if ( !_isCollapseAll ) {
            _isCollapseAll = true;
            _isExpandAll = false;
            WebCC.Events.fire( 'onCollapseAll', _isCollapseAll );
            selectedNode.IsFullyExpanded = false;
            if ( !_isExtendedStyle ) {
                _toolbar.setExpandBtnLine( _isExpandAll );
                _toolbar.setCollapseBtnLine( _isCollapseAll );
            }
            if ( selectedNode.IsExpanded ) {
                this.toggleVisibility( selectedNode, true );
                if ( !_isNodeInViewport( selectedNode.index ) ) {
                    _resetScrollCount( selectedNode );//If the selected node is outside the VP, reset the scroll index.
                }
            } else {
                _isCollapseAll = false;
            }
            if ( !_prevNodeSelected || ( _prevNodeSelected && _selectedFilter !== _options['TBID_NONE'] ) ) { //Enable expandAll button if _prevNodeSelected is not available in the changed filter view (!'None') and collapseAll button is pressed                 
                _updateToolbarButtons( selectedNode );
            }
        }
    };
    this.toggleFilterButton = function () {
        var attributes;
        if ( !_showSearchComboBox && !_isFilterRectsCreated ) {
            _showSearchComboBox = true;
            _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = CPM.Enums.Constants.searchBackRectHeight;
            _createFilterRects();
            if ( _createFilter && _filterComboBox ) {
                attributes = _getFilterComboBoxAttributes();
                _filterComboBox.show();
                _filterComboBox.update( attributes, _ctrlHeight, true );
            }
            _searchBox.show();
            _searchBox.updateTopValue( _toolbarHeight + _urlPartTotalHeight );
        } else {
            _showSearchComboBox = false;
            _data.SearchComboBoxPart.border.height = _searchComboBoxPartHeight = 0;
            _removeFilterRects();
            if ( _createFilter && _filterComboBox ) {
                _filterComboBox.hide();
            }
            _searchBox.hide();
        }
        if ( !_isExtendedStyle ) {
            _toolbar.setFilterBtnLine( _showSearchComboBox );
        }
        _updateBgRects();
        if ( _isAlarmsPresent ) {
            _removeAlarmBgRects();
            _createAlarmBgRects();
        }
        _setForUpdate();
    };
    /*
    * Function to handle Filter toolbar event
    * @function 
    * @memberOf CPM.App
    */
    this.filter = function () {
        var selectedNode, navigatedNodePath;
        if ( _selectedFilter === _options['TBID_NODE_PENDINGALARMS'] ) {
            if ( !_data.NodePart[0] ) {
                return;
            }
            if ( _selectedNodeId ) {
                selectedNode = _getNodeData( _selectedNodeId );
                selectedNode.isSelected = false;
                _nodeHandler.setSelectedNode( selectedNode, _data, _isAlarmsPresent, _horizontalLine );
                selectedNode.isSelected = true;
            }
            if ( ( Object.keys( _alarmData ).length === 0 ) || Object.keys( _alarmData.ActiveAlarms ).length === 0 ) {
                _data.URLPart.data = [];
                _data.URLPart.viewportData = [];
                _createBCRects();
                _count = 0;
                _linearDataArray = [];
                if ( _toolbar ) {
                    _toolbar.setExpandBtnOpacity( 0.5 );
                    _toolbar.setCollapseBtnOpacity( 0.5 );
                }
            } else {
                if ( _navigationType === CPM.Enums.NavigationType.Dynamic ) {
                    if ( _navigatedNodeId ) {
                        navigatedNodePath = _getNodeData( _navigatedNodeId ).fullPath;
                        if ( _alarmData.ActiveAlarms[navigatedNodePath] === 1 ) {
                            _setBeforeTraverse();
                        } else {
                            _linearDataArray = [];
                        }
                    } else {
                        _setBeforeTraverse();
                    }
                } else {
                    _setBeforeTraverse();
                }
                if ( _toolbar ) {
                    _toolbar.setExpandBtnOpacity( 1 );
                    _toolbar.setCollapseBtnOpacity( 1 );
                }
                if ( selectedNode ) {
                    if ( _alarmData.ActiveAlarms[selectedNode.fullPath] !== 1 ) {
                        _createBCRects();
                    } else {
                        _updateURLData( selectedNode );
                    }
                }
            }
            _createVerticalScrollBar();
            _setForUpdate();
            _createHorizontalScrollBar();
        }
        else if ( _selectedFilter === _options['TBID_NODE_VISUALIZATION'] ) {
            if ( Object.keys( _screenData ).length > 0 ) {
                self.handleScreenData();
            }
            else {
                //clearing the tree before requesting for screen window data
                _data.URLPart.data = [];
                _data.URLPart.viewportData = [];
                _createBCRects();
                _count = 0;
                _linearDataArray = [];
                if ( _toolbar ) {
                    _toolbar.setExpandBtnOpacity( 0.5 );
                    _toolbar.setCollapseBtnOpacity( 0.5 );
                }
                _setForUpdate();
                _createVerticalScrollBar();
                _createHorizontalScrollBar();
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [], [CPM.Enums.BrowsingMode.ScreenFilter] );
            }
        }
        else {
            if ( _data.NodePart[0] ) {
                if ( _selectedNodeId ) {
                    selectedNode = _getNodeData( _selectedNodeId );
                    _updateURLData( selectedNode );
                    if ( _toolbar ) {
                        _toolbar.setExpandBtnOpacity( 1 );
                        _toolbar.setCollapseBtnOpacity( 1 );
                    }
                }
                _setBeforeTraverse();
                _setForUpdate();
            }
        }
    };

    /*
    * Function to create new node in the tree
    * @function
    * @memberOf CPM.App
    * @params{node} node to be added to the tree
    */
    this.createNewNode = function ( node ) {
        var parentNode;
        if ( node.Parent === _data.NodePart[0].Name ) {
            parentNode = _data.NodePart[0];
        }
        else {
            parentNode = _searchForNode( _data.NodePart[0], node.Parent, _operation.add );
        }
        if ( parentNode ) {
            if ( parentNode.Children ) {
                parentNode.Children.push( node );
            }
            else {
                parentNode.Children = [];
                parentNode.Children.push( node );
            }
        }
        _count = 0;
        _deepestNodeWidth = 0;
        _deepestNode = 0;
        _traverse( _data.NodePart[0] );

    };

    /*
    * Function to load intial tree nodes whenever received from server
    * @function
    * @memberOf CPM.App
    * @params{rawData} data of the intial nodes to be displayed.
    */
    this.createHierarchyNode = function ( data ) {
        var node = _getDefaultNode();
        node.Name = data.Name;
        node.Id = data.Id;
        node.Children = data.Children;
        _data.NodePart.push( node );
        _count = 0;
        _deepestNodeWidth = 0;
        _deepestNode = 0;
        _updateParentDims();
    };

    /*
    * Function to load intial tree nodes whenever received from server
    * @function
    * @memberOf CPM.App
    * @params{rawData} data of the intial nodes to be displayed.
    */
    this.loadNodes = function ( rawData ) {
        var i = 0,
        selectedNode,
        wholePlantNodes,
        parentNode, node, paramIds, paramValues;

        if ( _isSearchPending ) {
            _isFullDataPresent = true;
            _count = 0;
            _deepestIdx = 1;
            wholePlantNodes = _traverseRawdata( rawData[0] );
            _mergeNodeProps( wholePlantNodes, _data.NodePart[0] );
            _data.NodePart[0] = wholePlantNodes;

            _handleSearchText();
            return;
        }
        if ( !_nodeHeight ) {
            _getNodeDomHeight();
        }

        for ( i = 0; i < rawData.length; i++ ) {
            if ( _expandedNodeId ) {
                parentNode = _getNodeData( _expandedNodeId );
                if ( !parentNode.Children ) {
                    parentNode.Children = [];
                }
                parentNode.Children.push( _traverseRawdata( rawData[i], parentNode ) );
            }
            else if ( _selectedNodeId && !_isRootNodePropertyChanged && _isNodeUpdated ) {
                parentNode = _getNodeData( _selectedNodeId );
                if ( !parentNode.Children ) {
                    parentNode.Children = [];
                }
                parentNode.Children.push( _traverseRawdata( rawData[i], parentNode ) );
            }
            else {
                if ( _isRootNodePropertyChanged ) {
                    _resetTree();
                    _rootNode = WebCC.Properties.RootNode;
                    _data.URLPart.data = [];
                    _data.URLPart.viewportData = [];
                    _createBCRects();
                    _navigatedNodeId = null;
                    _isNodeUpdated = true;
                    _isRootNodePropertyChanged = false;
                }
                _data.NodePart[0] = _traverseRawdata( rawData[i] );
                if ( _searchText && _isNodeUpdated ) {
                    node = _getNodeDataByPath( _rootNode );
                    paramIds = [0, 1];
                    if ( node ) {
                        paramValues = [CPM.Enums.BrowsingMode.ExpandAll, node.Id];
                    } else {
                        paramValues = [CPM.Enums.BrowsingMode.ExpandAll, ''];
                    }
                    _isNodeUpdated = false;
                    WebCC.Extensions.HMI.DomainLogic.sendDLEvent( paramIds, paramValues );
                }
            }
        }
        if ( _expandedNodeId ) {
            _expandedNodeId = null;
        }
        if ( _isExpandAll && _selectedNodeId && _selectedNodeId !== _data.NodePart[0].Id ) {
            selectedNode = _getNodeData( _selectedNodeId );
            selectedNode.IsExpanded = true;//Since we add only child nodes in this case, we have to set the already available selected node 'expanded'.
            _isExpandAll = false;
        }

        _tbUpdateRequired = true;
        _markNodesHavingSearchText();
        _setBeforeTraverse();
        _setForUpdate();
        if ( _isBCSelectionRequest ) {
            _updateURLData( parentNode );
            _isBCSelectionRequest = false;
        }
        if ( selectedNode && !_isNodeInViewport( selectedNode.index ) ) {
            _resetScrollCount( selectedNode );//If the selected node is outside the VP, reset the scroll index.
        }
        _updateParentDims();
        //Breadcrumb update required for scenario when the node selected from breadcrumb is not available with client but received from server in this function.
        if ( _isBCUpdateRequired ) {
            selectedNode = _getNodeData( _prevSelectedBCNodeId );
            selectedNode.isSelected = true;
            _prevNodeSelected.isSelected = false;
            _prevNodeSelected = selectedNode;
            _updateToolbarButtons( _prevNodeSelected );
            _updateURLData( selectedNode );
            WebCC.Properties.SelectedNode = selectedNode.fullPath;
            WebCC.Events.fire( 'onSelectionChanged', selectedNode.fullPath );
            _selectedNodeId = selectedNode.Id;
            if ( _navigationType === CPM.Enums.NavigationType.Dynamic && !selectedNode.IsLeaf ) {
                _setBeforeTraverse();
                _setForUpdate();
            }
            _resetScrollCount( selectedNode );
            _isBCUpdateRequired = false;
        }
        _sendSummaryInfo();
        _addTifLibExpandoProps();
        if ( Object.keys( _screenData ).length === 0 && _selectedFilter && ( Object.keys( _options ).length > 0 && _selectedFilter === _options['TBID_NODE_VISUALIZATION'] ) ) { //Request explicitly to DL for the visualization data if the filter is configured as visualization
            self.filter();
        }
    };

    /*
    * Function to add new nodes to the existing tree nodes
    * @function
    * @memberOf CPM.App
    * @params{data} data of the new nodes to be added.
    * @params{isBufferData} Indicates if the data is to be stored in a buffer array or not.
    */
    this.addNewNodes = function ( data, isBufferData ) {
        var parentId = data.ParentId, parentNode, nodeData, formattedData;
        if ( isBufferData ) {
            _bufferDataArray.push( data );
            if ( !data.MoreFollows ) {
                for ( var i = 0; i < _bufferDataArray.length; i++ ) {
                    parentNode = _getNodeData( parentId );
                    if ( !parentNode.Children ) {
                        parentNode.Children = [];
                    }
                    nodeData = _bufferDataArray[i].DisplayData[0];
                    nodeData.ParentId = parentId;
                    nodeData.Parent = parentNode;
                    nodeData.depth = parentNode.depth + 1;
                    formattedData = _traverseRawdata( nodeData, parentNode );
                    parentNode.Children.push( formattedData );

                }
                _markNodesHavingSearchText();
                _setBeforeTraverse();
                _createVerticalScrollBar();
                _nodeHandler.resetDataArray( _linearDataArray );
                _setForUpdate();
            }
        }
        else {
            if ( parentId ) {
                parentNode = _getNodeData( parentId );
                if ( !parentNode.Children ) {
                    parentNode.Children = [];
                }
                nodeData = data.DisplayData[0];
                nodeData.ParentId = parentId;
                nodeData.Parent = parentNode;
                nodeData.depth = parentNode.depth + 1;
                formattedData = _traverseRawdata( nodeData, parentNode );
                parentNode.Children.push( formattedData );
                _markNodesHavingSearchText();
                _setBeforeTraverse();
                _setForUpdate();
            }
        }
    };

    /*
    * Function to remove a node from the tree
    * @function
    * @memberOf CPM.App
    * @params{nodeName} name of the node to be removed.
    */
    this.removeNode = function ( nodeName ) {
        _searchForNode( _data.NodePart[0], nodeName, _operation.remove );
        _count = 0;
        _deepestNode = 0;
        _deepestNodeWidth = 0;
        _traverse( _data.NodePart[0] );
    };

    /*
    * Function to set the callback function.
    * @function
    * @memberOf CPM.App
    * @params{func} callback function name
    */
    this.setCallback = function ( func ) {
        _callback = func;
    };

    /*
    * Function to load the breadcrumb for the given node.
    * @function
    * @memberOf CPM.App
    * @params{data} selected node data
    */
    this.loadBreadCrumb = function ( data ) {
        var i = 0, crumbNode, maxNodeNameWidth = 0, cNodeNameWidth, crumbData = {},
        // extraPaddingGap = 48,
        length;
        _nodeDomHeight = _getNodeDomHeight();
        //holds children nodes of breadcrumb for a parent node
        _crumbChildren = [];
        //TODO: recheck if condition for expandable and non expandable node
        if ( data ) {
            length = data.length;
            if ( length !== 0 ) {
                for ( i = 0; i < length; i++ ) {
                    crumbNode = _getDefaultNode();
                    crumbNode.fullPath = data[i][2];
                    if ( _selectedFilter && _selectedFilter !== _options['TBID_NONE'] ) {
                        if ( _selectedFilter === _options['TBID_NODE_PENDINGALARMS'] && _alarmData && ( Object.keys( _alarmData.ActiveAlarms ).length > 0 || Object.keys( _alarmData.RemovedAlarms ).length > 0 ) && !( _alarmData.ActiveAlarms[crumbNode.fullPath] === 1 || _alarmData.RemovedAlarms[crumbNode.fullPath] === 0 ) ) {
                            continue;
                        }
                        else {
                            if ( _selectedFilter === _options['TBID_NODE_VISUALIZATION'] && _screenData && Object.keys( _screenData.ScreenFilter ).length > 0 && _screenData.ScreenFilter[crumbNode.fullPath] !== 0 ) {
                                continue;
                            }
                        }
                    }
                    crumbNode.Name = data[i][0];
                    crumbNode.Id = data[i][1];

                    crumbNode.bBox = _getTextBBox( crumbNode.Name );
                    crumbNode.isSelected = false;
                    if ( _prevSelectedBCNodeId && _prevSelectedBCNodeId === crumbNode.Id ) {
                        crumbNode.isSelected = true;
                        _prevSelectedCrumbNode = crumbNode;
                        _prevSelectedBCNodeId = crumbNode.Id;
                    }
                    _crumbNodeNameHeight = _getTextBBox( crumbNode.Name ).height;
                    cNodeNameWidth = _getTextBBox( crumbNode.Name ).width;
                    if ( maxNodeNameWidth < cNodeNameWidth ) {
                        maxNodeNameWidth = cNodeNameWidth;
                    }
                    _crumbNodeNameWidth = maxNodeNameWidth;
                    _crumbChildren.push( crumbNode );
                }
                if ( _crumbChildren.length > 0 ) {
                    _treeGroup.setAttribute( 'fill-opacity', '0.5' );
                    _treeAlarmIconGroup.setAttribute( 'fill-opacity', '0.5' );
                    _searchComboBoxGroup.setAttribute( 'fill-opacity', '0.5' );
                }
                if ( ( _ctrlHeight - _nodeDomHeight - _toolbarHeight ) < ( _crumbChildren.length * _nodeDomHeight ) ) {
                    if ( _isHorizontalScrollbarCreated ) {
                        _crumbHeight = _ctrlHeight - _toolbarHeight - CPM.Enums.Constants.urlHeight - _hScrollbarHeight;
                    } else {
                        _crumbHeight = _ctrlHeight - _toolbarHeight - CPM.Enums.Constants.urlHeight;
                    }
                } else {
                    _crumbHeight = _crumbChildren.length * _nodeDomHeight;
                }

                crumbData.crumbX = _crumbX;
                crumbData.crumbNodeNameWidth = _crumbNodeNameWidth;
                crumbData.crumbHeight = _crumbHeight;
                crumbData.white = _data.white;
                crumbData.grey3 = _data.grey3;
                crumbData.foreColor = _data.ForeColor;
                crumbData.crumbNodeNameHeight = _crumbNodeNameHeight;
                crumbData.SelectionForeColor = _data.SelectionForeColor;
                crumbData.SelectionNodeIconColor = _data.SelectionNodeIconColor;
                crumbData.active = _data.SelectionBackColor;
                crumbData.divParent = _divParent;
                _bcParentGrp = _breadCrumb.createBreadCrumb( _crumbChildren, crumbData, _toolbarHeight, _data.URLPart.imageIconRect.height );

                _breadcrumbGroup = document.getElementById( 'breadcrumbGroup' );
                _breadcrumbGroupMatrix = _breadcrumbGroup.transform.baseVal.getItem( 0 ).matrix;
                // Creating breadcrumb scrollbar after creation of breadcrumb children nodes in the DOM
                if ( ( _ctrlHeight - _nodeDomHeight - _toolbarHeight ) < ( _crumbChildren.length * _nodeDomHeight ) ) {
                    _createBCVerticalScrollBar();
                }
            }
        }
    };

    /*
    * Function to handle alarm summary data
    * @function
    * @memberOf CPM.App
    * @params{data} alarm summary data
    */
    this.handleAlarmData = function ( data ) {
        var selectedNode;
        if ( ( data.ActiveAlarms && data.ActiveAlarms !== null ) || ( data.RemovedAlarms && data.RemovedAlarms !== null ) ) {
            _alarmData = data;
            if ( _selectedFilter === _options.TBID_NODE_PENDINGALARMS ) {
                if ( Object.keys( data.ActiveAlarms ).length === 0 ) {
                    _resetTree();
                    _data.URLPart.data = [];
                    _data.URLPart.viewportData = [];
                    _createBCRects();
                    _count = 0;
                    _linearDataArray = [];
                    if ( _toolbar ) {
                        _toolbar.setExpandBtnOpacity( 0.5 );
                        _toolbar.setCollapseBtnOpacity( 0.5 );
                    }
                    _isAlarmsPresent = false;
                    _removeAlarmBgRects();
                } else {
                    if ( Object.keys( data.RemovedAlarms ).length > 0 && _navigationType === CPM.Enums.NavigationType.Static && _selectedNodeId ) {
                        selectedNode = _getNodeData( _selectedNodeId );
                        if ( data.RemovedAlarms[selectedNode.fullPath] === 0 ) {
                            selectedNode.isSelected = false;
                            _nodeHandler.setSelectedNode( selectedNode, _data, _isAlarmsPresent, _horizontalLine );
                            _selectedNodeId = undefined;
                        }
                    }
                    _setBeforeTraverse();
                    if ( _toolbar ) {
                        _toolbar.setExpandBtnOpacity( 1 );
                        _toolbar.setCollapseBtnOpacity( 1 );
                    }
                    _isAlarmsPresent = true;
                    _removeAlarmBgRects();
                    _createAlarmBgRects();
                }
                _setForUpdate( data );
            } else {
                if ( _alarmData.ActiveAlarms && Object.keys( _alarmData.ActiveAlarms ).length === 0 ) {
                    _isAlarmsPresent = false;
                    _removeAlarmBgRects();
                } else {
                    _isAlarmsPresent = true;
                    _removeAlarmBgRects();
                    _createAlarmBgRects();
                }
                _createHorizontalScrollBar();
                _setHorizontalLineVal();
                _data.SelectionBackColor = _selectionBackColUpdated ? _data.SelectionBackColor : _data.stylePropObj.Control.SelectionBackColor;
                _data.SelectionForeColor = _selectionForeColUpdated ? _data.SelectionForeColor : _data.stylePropObj.Control.SelectionForeColor;
                _nodeHandler.updateAlarmSummary( _alarmData, _data, _isScrollbarCreated, _isAlarmsPresent, _horizontalLine ); // Called on screen load if alarm is raised
            }
        } else {
            _isAlarmsPresent = false;
        }
    };

    /*
    * Function to handle screen window data
    * @function
    * @memberOf CPM.App
    * @params{data} screen window data
    */
    this.handleScreenData = function ( data ) {
        var selectedNode, navigatedNodePath;
        if ( data && data.ScreenFilter !== null ) {
            _screenData = data;
        }
        if ( _selectedFilter !== _options['TBID_NONE'] ) {
            if ( Object.keys( _screenData.ScreenFilter ).length === 0 ) {
                if ( _selectedNodeId ) {
                    selectedNode = _getNodeData( _selectedNodeId );
                    selectedNode.isSelected = false;
                    _nodeHandler.setSelectedNode( selectedNode, _data, _isAlarmsPresent, _horizontalLine );
                    selectedNode.isSelected = true;
                }
                _data.URLPart.data = [];
                _data.URLPart.viewportData = [];
                _createBCRects();
                _count = 0;
                _linearDataArray = [];
                if ( _toolbar ) {
                    _toolbar.setExpandBtnOpacity( 0.5 );
                    _toolbar.setCollapseBtnOpacity( 0.5 );
                }
            } else {
                if ( _toolbar ) {
                    _toolbar.setExpandBtnOpacity( 1 );
                    _toolbar.setCollapseBtnOpacity( 1 );
                }
                if ( _selectedNodeId ) {
                    selectedNode = _getNodeData( _selectedNodeId );
                }
                if ( _navigationType === CPM.Enums.NavigationType.Static ) {
                    if ( selectedNode && _screenData.ScreenFilter[selectedNode.fullPath] !== 0 ) {
                        selectedNode.isSelected = false;
                        _nodeHandler.setSelectedNode( selectedNode, _data, _isAlarmsPresent, _horizontalLine );
                        selectedNode.isSelected = true;
                    }
                    _setBeforeTraverse();
                } else {
                    if ( _navigatedNodeId ) {
                        navigatedNodePath = _getNodeData( _navigatedNodeId ).fullPath;
                        if ( _screenData.ScreenFilter[navigatedNodePath] === 0 ) {
                            _setBeforeTraverse();
                        } else {
                            _linearDataArray = [];
                        }
                    } else {
                        _setBeforeTraverse();
                    }
                }
                if ( selectedNode ) {
                    if ( _screenData.ScreenFilter[selectedNode.fullPath] !== 0 ) {
                        _createBCRects();
                    } else {
                        _updateURLData( selectedNode );
                    }
                }
            }
            _setForUpdate();
            _createVerticalScrollBar();
            _createHorizontalScrollBar();
        }
    };

    /*
    * Function to handle runtime language change event
    * @function
    * @memberOf CPM.App
    * @params{data} language id
    */
    this.handleLanguageChange = function ( languageId ) {
        if ( navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            setTimeout( function () {
                _setFilterText( languageId );
            }, 0 );
        } else {
            _setFilterText( languageId );
        }
    };

    /*
    * Function to disable the toolbar buttons
    * @function
    * @memberOf CPM.App
    */
    this.disableToolbarButtons = function () {
        if ( _toolbar ) {
            _toolbar.setExpandBtnOpacity( 0.5 );
            _toolbar.setCollapseBtnOpacity( 0.5 );
        }
    };
    /*
    * Function to update the CPM control properties
    * @function
    * @memberOf CPM.App
    * @params{data} holds the property name and its value
    */
    this.updateProperties = function ( data ) {
        var node, paramValues, paramIds;
        switch ( data.key ) {
            case 'RootNode':
                if ( data.value !== '' ) {
                    _updateRootNode( data.value );
                }
                else {
                    _rootNode = '';
                    _isRootNodePropertyChanged = true;
                    paramValues = [CPM.Enums.BrowsingMode.Hierarchies];
                    paramIds = [0];
                    WebCC.Extensions.HMI.DomainLogic.sendDLEvent( paramIds, paramValues );
                }
                break;
            case 'SelectedNode':
                _selectedNodePath = data.value;
                node = _getNodeDataByPath( _selectedNodePath );
                if ( node ) {
                    if ( _prevNodeSelected && _prevNodeSelected.fullPath === _selectedNodePath ) {
                        return;
                    }
                    _setSelected( node, false );
                    _resetScrollCount( node );
                }
                break;
            case 'SelectionBackColor':
                if ( data.value !== 0 && _toRGBA( data.value ) !== _toRGBA( _defaultSelectionBackColor ) ) {
                    _data.SelectionBackColor = data.value ? _toRGBA( data.value ) : _data.SelectionBackColor;
                    _selectionBackColUpdated = true;
                    _nodeHandler.updateSelectionBackColor( _data.SelectionBackColor );
                }
                break;
            case 'SelectionForeColor':
                if ( data.value !== 0 && _toRGBA( data.value ) !== _toRGBA( _defaultSelectionForeColor ) ) {
                    _data.SelectionForeColor = data.value ? _toRGBA( data.value ) : _data.SelectionForeColor;
                    _selectionForeColUpdated = true;
                    _nodeHandler.updateSelectionForeColor( _data.SelectionForeColor );
                }
                break;
            case 'Enabled':
                _data.Enabled = data.value;
                if ( _toolbar ) {
                    if ( _data.Enabled ) {
                        _toolbar.setExpandBtnOpacity( 1 );
                        _toolbar.setCollapseBtnOpacity( 1 );
                    } else {
                        _toolbar.setExpandBtnOpacity( 0.5 );
                        _toolbar.setCollapseBtnOpacity( 0.5 );
                    }
                }
                break;
            case 'Filter':
                if ( _createFilter ) {
                    switch ( data.value ) {
                        case CPM.Enums.Filter.NodeWithPendingAlarms:
                            WebCC.Properties.Filter = data.value;
                            _selectedFilter = _options['TBID_NODE_PENDINGALARMS'];
                            break;
                        case CPM.Enums.Filter.NodeWithVisualization:
                            WebCC.Properties.Filter = data.value;
                            _selectedFilter = _options['TBID_NODE_VISUALIZATION'];
                            break;
                        case CPM.Enums.Filter.None:
                            WebCC.Properties.Filter = data.value;
                            _selectedFilter = _options['TBID_NONE'];
                            break;
                        default:
                            break;
                    }
                    if ( _filterComboBox ) {
                        _filterComboBox.setSelectedOption( _selectedFilter );
                    }
                    self.filter();
                }
                break;
            case 'ShowToolBar':
                _showToolBar = data.value;
                if ( _showToolBar ) {
                    _showToolbarArea();
                } else {
                    _hideToolbarArea();
                }
                _updateTreeComponents();
                break;
            case 'ShowBreadCrumb':
                _showBreadCrumb = data.value;
                if ( _showBreadCrumb ) {
                    _showBreadcrumbArea();
                } else {
                    _hideBreadcrumbArea();
                }
                _updateTreeComponents();
                break;
            case 'NavigationType':
                if ( data ) {
                    _navigationType = data.value;
                    if ( _svgParent && _svgParent.TifProperties ) {
                        _svgParent.TifProperties.item.navigationType = _navigationType;
                    }
                    if ( _selectedNodePath ) {
                        node = _getNodeDataByPath( _selectedNodePath );
                        if ( node ) {
                            if ( _navigationType === CPM.Enums.NavigationType.Dynamic ) {
                                WebCC.Properties.NavigationType = CPM.Enums.NavigationType.Dynamic;
                                if ( !node.IsLeaf ) {
                                    _navigatedNodeId = node.Id;
                                    node.isNodeNavigated = true;
                                    _loadData( node, false );
                                }
                            } else {
                                WebCC.Properties.NavigationType = CPM.Enums.NavigationType.Static;
                                _setBeforeTraverse();
                                _setForUpdate();
                            }
                        }
                    }
                }
                break;
            default:
                break;
        }
    };
    /*
    * Function to handle style change
    * @function
    * @memberOf CPM.App
    */
    this.handleStyleChange = function ( currentStyle ) {
        _isExtendedStyle = currentStyle.includes( CPM.Enums.StyleName.Extended ) ? true : false;
        _data.currentStyle = currentStyle;
        _data.stylePropObj = CPM.StyleFactory.getCurrentStyleProps( currentStyle );
        _updateToolBarStyles( currentStyle );
        _updateBCStyle();
        if ( _isScrollbarCreated ) {
            _createVerticalScrollBar();
        }
        if ( _isHorizontalScrollbarCreated ) {
            _createHorizontalScrollBar();
        }
        _data.ForeColor = _data.stylePropObj.Control.ForeColor;
        _data.white = _data.stylePropObj.Control.EvenBackColor;
        _data.grey3 = _data.stylePropObj.Control.OddBackColor;
        _data.HorizLineColor = _data.stylePropObj.Control.HorizLineColor;
        _data.AlarmSeperatorLineColor = _data.stylePropObj.Control.AlarmSeperatorLineColor;
        _data.NodeIconColor = _data.stylePropObj.Control.NodeIconColor;
        _data.SelectionNodeIconColor = _data.stylePropObj.Control.SelectionNodeIconColor;
        _data.ExpCollIconColor = _data.stylePropObj.Control.ExpCollIconColor;
        _data.SelectionBackColor = _selectionBackColUpdated ? _data.SelectionBackColor : _data.stylePropObj.Control.SelectionBackColor;
        _data.SelectionForeColor = _selectionForeColUpdated ? _data.SelectionForeColor : _data.stylePropObj.Control.SelectionForeColor;
        _nodeHandler.updateNodeStyle( _data, _isAlarmsPresent );
        _searchBox.updateStyle( _data.stylePropObj, _isExtendedStyle, currentStyle );
        _updateSearchComboBoxStyle();
        _updateComboBoxStyle();
    };
};
