// JavaScript source code
var CPM = ( CPM || {} );
CPM.Style = ( CPM.Style || {} );

CPM.StyleFactory = ( function () {
    return {
        getCurrentStyleProps: function ( currentStyle ) {
            switch ( currentStyle ) {
                case 'FlatStyle_Bright':
                    return new FlatStyleBright();
                    break;
                case 'FlatStyle_Dark':
                    return new FlatStyleDark();
                    break;
                case 'ExtendedStyle':
                default:
                    return new ExtendedStyle(); // Extended style
                    break;
            }
        }
    }
} )();
var FlatStyleBright = function () {
    var brightStyle = CPM.Style;
    brightStyle.Control = {
        OddBackColor: 'rgba(255,255,255,1)',
        EvenBackColor: 'rgba(255,255,255,1)',
        ForeColor: 'rgba(33,41,44,1)',
        ExpCollIconColor: 'rgba(0,0,0,1)',
        NodeIconColor: 'rgba(123,146,162,1)',
        SelectionNodeIconColor: 'rgba(255,255,255,1)',
        SelectionBackColor: 'rgba(38,92,255,1)',
        SelectionForeColor: 'rgba(255,255,255,1)',
        HorizLineColor: 'rgba(223,230,237,1)'
    };
    brightStyle.BreadCrumb = {
        BackColor: 'rgba(223,230,237,1)',
        ForeColor: 'rgba(105,120,129,1)',
        IconColor: 'rgba(105,120,129,1)',
        SelectionForeColor: 'rgba(33,41,44,1)',
        ButtonColor: 'rgba(123,146,162,1)',
        PressedButtonColor: 'rgba(111,139,191,1)',
        PressedIconColor: 'rgba(255,255,255,1)',
        BottomBorderColor: 'none'
    };
    brightStyle.ComboBox = {
        ComboBoxColor: 'rgba(255, 255, 255, 1.0)',
        NormalbuttonColor: 'rgba(123, 146, 162, 1.0)',
        PressedbuttonColor: 'rgba(111, 139, 191, 1.0)',
        FontColor: '#000000',
        RectColor: 'rgba(255,255,255,1)',
        Rx: 0,
        Stroke: 'rgba(123, 146, 162, 1.0)',
        TriangleColor: 'rgba(255, 255, 255, 1.0)',
        OptionsStroke: 'rgba(155,175, 190, 1.0)',
        Line: 'rgba(0, 0, 0, 1.0)',
        ClickableRect: 'rgba(38, 92, 255, 1.0)'
    };
    brightStyle.ScrollBar = {
        BgColor: 'rgba(205, 217, 225, 1.0)',
        ScrollbarColor: 'rgba(205, 217, 225, 1.0)',
        ScrollerColor: 'rgba(123, 146, 162, 1.0)',
        HighlightColor: 'rgba(123, 146, 162, 1.0)',
        DisabledFillColor: '#CDD9E1',
        DisabledStrokeColor: '#cdd9e1',
        TriangleFillColor: 'rgba(105, 120, 129, 0)',
        TriangleStrokeColor: '#697881',
        Opacity: 1,
        LeftPadding: 20,
        ScrollPadding: 25,
        TopPadding: 2,
        Width: 20,
        HeightPadding: 2,
        HorizontalSliderHeight: 20,
        ScrollButton: 'rgba(205, 217, 225, 1.0)',
        TriangleColor: 'rgba(105, 120, 129, 1.0)',
        StrokeWidth: 2
    };
    brightStyle.ToolBar = {
        Fill: 'rgba(123, 146, 162, 1)',
        Hover: 'rgba(123, 146, 162, 0.75)',
        Pressed: 'rgba(111, 139, 191, 1)',
        Disabled: 'rgba(123, 146, 162, 0.6)',
        BottomBorder: 'rgba(0, 0, 0, 1)',
        BorderColor1: 'none',
        Rx: 0,
        BottomLineColor: 'none',
        IconColor: 'rgba(255,255,255,1)'
    };
    brightStyle.TextBox = {
        BackColor: 'rgba(255,255,255,1)',
        BorderColor: 'rgba(123, 146, 162, 1)',
        Rx: 0,
        BottomLineColor: 'rgba(0, 0, 0, 1)',
        LineStroke: '2',
        IconColor: 'rgba(123,146,162,1)',
        SvgWidth: '22',
        ViewBox: '0 0 26 22',
        RectLineColor: 'rgba(223,230,237,1)',
        StrokeWidth: '1',
        IconY: '-7'
    };
    return brightStyle;
};

var FlatStyleDark = function () {
    var darkStyle = CPM.Style;
    darkStyle.Control = {
        OddBackColor: 'rgba(40,45,58,1)',
        EvenBackColor: 'rgba(40,45,58,1)',
        ForeColor: 'rgba(255,255,255,1)',
        ExpCollIconColor: 'rgba(255,255,255,1)',
        NodeIconColor: 'rgba(131,145,160,1)',
        SelectionNodeIconColor: 'rgba(0,0,0,1)',
        SelectionBackColor: 'rgba(83,169,255,1)',
        SelectionForeColor: 'rgba(32,36,45,1)',
        HorizLineColor: 'rgba(58,66,82,1)'
    };
    darkStyle.BreadCrumb = {
        BackColor: 'rgba(58,66,82,1)',
        ForeColor: 'rgba(131,145,160,1)',
        IconColor: 'rgba(131,145,160,1)',
        SelectionForeColor: 'rgba(255,255,255,1)',
        ButtonColor: 'rgba(73,82,101,1)',
        PressedButtonColor: 'rgba(75,99,132,1)',
        PressedIconColor: 'rgba(255,255,255,1)',
        BottomBorderColor: 'none'
    };
    darkStyle.ComboBox = {
        ComboBoxColor: 'rgba(32, 36, 45, 1.0)',
        NormalbuttonColor: 'rgba(73, 82, 101, 1.0)',
        PressedbuttonColor: 'rgba(75, 99, 132, 1.0)',
        FontColor: '#FFFFFF',
        RectColor: 'rgba(32, 36, 45, 1.0)',
        Rx: 0,
        Stroke: 'rgba(73, 82, 101, 1.0)',
        TriangleColor: 'rgba(255, 255, 255, 1.0)',
        OptionsStroke: 'rgba(73, 82, 101, 1.0)',
        Line: 'rgba(131, 145, 160, 1.0)',
        ClickableRect: 'rgba(83, 169, 255, 1.0)'
    };
    darkStyle.ScrollBar = {
        BgColor: 'rgba(58, 66, 82, 1)',
        ScrollbarColor: 'rgba(58, 66, 82, 1.0)',
        ScrollerColor: 'rgba(131, 145, 160, 1.0)',
        HighlightColor: 'rgba(131, 145, 160, 1.0)',//actually   clr in hash
        DisabledFillColor: '#3A4252',
        DisabledStrokeColor: '#3a4252',
        TriangleFillColor: 'rgba(131, 145, 160, 0)',
        TriangleStrokeColor: '#8391A0',
        Opacity: 1,
        LeftPadding: 20,
        ScrollPadding: 25,
        TopPadding: 2,
        Width: 20,
        HeightPadding: 2,
        HorizontalSliderHeight: 20,
        ScrollButton: 'rgba(58, 66, 82, 1.0)',
        TriangleColor: 'rgba(131, 145, 160, 1.0)',
        StrokeWidth: 2
    };
    darkStyle.ToolBar = {
        Fill: 'rgba(73, 82, 101, 1)',
        Hover: 'rgba(73, 82, 101, 0.75)',
        Pressed: 'rgba(75, 99, 132, 1)',
        Disabled: 'rgba(73, 82, 101, 0.6)',
        BottomBorder: 'rgba(131, 145, 160, 1)',
        BorderColor1: 'none',
        Rx: 0,
        BottomLineColor: 'none',
        IconColor: 'rgba(255,255,255,1)'
    };
    darkStyle.TextBox = {
        BackColor: 'rgba(32, 36, 45, 1)',
        BorderColor: 'rgba(73, 82, 101, 1)',
        Rx: 0,
        BottomLineColor: 'rgba(131, 145, 160, 1)',
        LineStroke: '2',
        IconColor: 'rgba(131,145,160,1)',
        SvgWidth: '22',
        ViewBox: '0 0 26 22',
        RectLineColor: 'rgba(58,66,82,1)',
        StrokeWidth: '1',
        IconY: '-7'
    };
    return darkStyle;
};

var ExtendedStyle = function () {
    var extendedStyle = CPM.Style;
    extendedStyle.Control = {
        OddBackColor: '#e6e6eb',
        EvenBackColor: 'rgba(255,255,255,1)',
        ForeColor: 'rgba(0,0,0,1)',
        ExpCollIconColor: 'rgba(0,0,0,1)',
        NodeIconColor: 'rgba(0,0,0,1)',
        SelectionNodeIconColor: 'rgba(0,0,0,1)',
        SelectionBackColor: 'rgba(125,205,245,1)',
        SelectionForeColor: 'rgba(0,0,0,1)',
        HorizLineColor: 'none'
    };
    extendedStyle.BreadCrumb = {
        BackColor: 'rgba(230, 230, 235, 1)',
        ForeColor: 'rgba(0,0,0,1)',
        IconColor: 'gray',
        SelectionForeColor: 'rgba(0,0,0,1)',
        ButtonColor: 'url(#urlNodeGradient)',
        PressedButtonColor: '#878787',
        PressedIconColor: 'gray',
        BottomBorderColor: '#64646A'
    };
    extendedStyle.ComboBox = {
        ComboBoxColor: 'url(#CPM_Gradient_IOFieldNormal_Gradient)',
        NormalbuttonColor: 'url(#CPM_Gradient_ButtonNormal_Gradient)',
        PressedbuttonColor: 'url(#CPM_Gradient_ButtonPressed_Gradient)',
        FontColor: '#000000',
        RectColor: 'rgba(255,255,255,1)',
        Rx: 3,
        Stroke: 'rgba(100, 100, 106, 0.5)',
        TriangleColor: 'rgba(0, 0, 0, 1.0)',
        Line: 'none',
        ClickableRect: '#22aaee'
    };
    extendedStyle.ScrollBar = {
        BgColor: 'rgba(7, 33, 128, 0.54)',
        ScrollbarColor: 'rgba(240, 240, 254, 1.0)',
        ScrollerColor: 'rgba(100, 100, 106, 0.5)',
        HighlightColor: '#BBBBBB',
        DisabledFillColor: '#F6F6F6',
        DisabledStrokeColor: '#f6f6f6',
        TriangleFillColor: 'rgba(100, 100, 106, 0.5)',
        TriangleStrokeColor: 'none',
        Opacity: 0,
        Stroke: 'rgba(100, 100, 106, 1.0)',
        LeftPadding: 22,
        ScrollPadding: 22,
        TopPadding: 0,
        Width: 17,
        HeightPadding: 0,
        HorizontalSliderHeight: 17,
        ScrollButton: 'rgba(240, 240, 254, 1.0)',
        TriangleColor: 'rgba(100, 100, 106, 0.5)',
        StrokeWidth: 0
    };
    extendedStyle.ToolBar = {
        BorderColor1: 'rgba(100,100,106,1)',
        Fill: 'url(#ButtonBgGradient_LigtherDarker_ExpandAll)',
        Rx: 4,
        BottomLineColor: 'gray',
        IconColor: 'rgba(0,0,0,1)'
    };
    extendedStyle.TextBox = {
        BackColor: 'rgba(255, 255, 255, 1)',
        BorderColor: 'rgba(100, 100, 106, 1)',
        Rx: 3,
        BottomLineColor: 'rgba(100, 100, 106, 0.5)',
        LineStroke: '0',
        IconColor: 'rgba(0,0,0,1)',
        SvgWidth: '26',
        ViewBox: '0 0 26 26',
        RectLineColor: 'rgba(58,66,82,1)',
        StrokeWidth: '2',
        IconY: '-3'
    };
    return extendedStyle;
};
