/**
* Creates an instance of ContextControl
* @class
* @desc Class for creating ContextControl
* @constructor 
*/
var Context = ( Context || {} );
Context.Control = function () {
    var
    /**    
    * @memberOf ContextControl 
    * Holds scope of contextController 
    */
    $scope = {},
    _tagData,
	_isRequestTagBrowser = true,
	_isDropdown = false,

    /**
    * function to create context control on DOM  
    **/
    _createControl = function ( options ) {
        var screen;
        $scope = angular.element( options.domParent ).scope();

        if ( options.HostType === 'Trend' ) {
            _isRequestTagBrowser = false;
            _isDropdown = true;
            _tagData = options.PathArray;
        }

        $scope.data = {
            isRequestTagBrowser: _isRequestTagBrowser,
            isDropdown: _isDropdown,
            contextDialogLabels: $scope.getLabelTexts(),
            areaPaths: _tagData ? _tagData : [],
            path: '',
            selectedPath: '',
            contexts: [],
            selectedContext: '',
            contextValues: [],
            selectedRow: -1,
            existingContext: JSON.parse( options.SelectedContext ),
            savedData: null,
            isModified: false
        };
        screen = $scope.createContextControl( options );
        options.domParent.appendChild( screen[0] );
        if ( $scope.data.existingContext && $scope.data.existingContext.value ) {
            $scope.data.savedData = $scope.data.existingContext;
            $scope.loadPath( $scope.data.existingContext.path, true );
        }
    },
    /**
    * function to load path
    **/
	_loadPath = function ( data ) {
	    $scope.loadPath( data );
	},
    /**
    * function to load contexts
    **/
	 _loadContexts = function ( data ) {
	     $scope.loadContexts( data );
	 },
    /**
    * function to load context values
    **/
	 _loadContextValues = function ( data ) {
	     $scope.loadContextValues( data );
	 },
    /**
    * function to fetch contexts for changed path
    **/
    _onPathChange = function ( data ) {
        $scope.onPathChange( data );
    },
    /**
    * function to fetch contexts values for changed context
    **/
    _onContextChange = function ( context ) {
        $scope.onContextChange( context );
    },
	/**
    * function will set callback function that to be called from controller on occuring of event on DOM
    * @param {name} string
    * @param {func} callback
    */
    _on = function ( func ) {
        $scope.setCallback( func );
    },
    /**
    * function to update view on resize
    * return bool
    */
    _updateView = function ( height, width ) {
        $scope.updateView( height, width );
    },

    /**
    * function to handle language translation
    * returns translated text 
    */
    _handleLanguageChange = function ( data ) {
        $scope.data.contextDialogLabels = $scope.handleLanguageChange( data );
        if ( $scope.safeApply ) { // Controller might not be created yet for this screen.
            $scope.safeApply(); // Update bindings.
        }
    }
    ;

    return {
        createControl: _createControl,
        loadPath: _loadPath,
        loadContexts: _loadContexts,
        loadContextValues: _loadContextValues,
        onPathChange: _onPathChange,
        onContextChange: _onContextChange,
        updateView: _updateView,
        on: _on,
        handleLanguageChange: _handleLanguageChange
    };
};
