// contextApp is a fully-fledged Angular module.
var Context = ( Context || {} );
Context.contextApp = angular.module( 'contextApp', [] );
// The cpmTreeController can add new templates that will be compiled by Angular. 
// Note: The corresponding ng-controller attribute must be placed somewhere close to the HTML-tag. 
Context.contextApp.controller( 'contextController', ['$scope', '$compile', function ( $scope, $compile ) {
    var
    // holds refernce of callback function to be called on event occurs on DOM
    _callback,
    // holds reference of the host control ID
	_hostId,
    // holds left value 
    _left = 5,
    // holds top value 
    _top = 5,
    _ctrlHeight = 0,
    _cntrlHeightNew = 0,
    _cntrlWidthNew = 0,
    _divParent = null,
    
	_formatDate = function ( date ) {
	    var d = new Date( date ), formattedDate;
	    formattedDate = [( d.getMonth() + 1 ),
            d.getDate(),
            d.getFullYear()].join( '.' ) +
            '\n' +
            [d.getHours() + ' h',
            d.getMinutes() + ' min',
            d.getSeconds() + ' sec',
            d.getMilliseconds() + ' ms'].join( ':' );
	    return formattedDate;
	}
    ;
    //holds data to be binded to template
    $scope.FrameData = {
        Left: _left,
        Top: _top,
        Height: 704,
        Width: 720
    };
    //compiles context control and display in DOM 
    $scope.createContextControl = function ( options ) {
        $scope.FrameData.Width = options.width;
        $scope.FrameData.Height = options.height;
        //$scope.FrameData.BackColor = 'rgba(230, 230, 235, 1)';//TODO:Once back color is available from the container remove this hard coded value.
        //new styles added
        $scope.FrameData.DefaultBackground = '#f8f8f9';
        $scope.FrameData.white = '#fff';
        $scope.FrameData.grey3 = '#e6e6eb';
        $scope.FrameData.black = '#000';
        $scope.FrameData.active = '7dcdf5';
        $scope.FrameData.BaseDir = options.BaseDir || '';
        _cntrlHeightNew = _ctrlHeight = options.height;
        _cntrlWidthNew = options.width;
        $scope.FrameData.CtrlHeight = _ctrlHeight;
        $scope.FrameData.CtrlWidth = options.width;
        _divParent = options.divParent;
        _hostId = options.HostID;

        return $compile( '<context-control basedir="' + $scope.FrameData.BaseDir + '" ></context-control>' )( $scope );
    };
    
    //on window resize, update content 
    $scope.updateView = function ( height, width ) {
        $scope.safeApply();
    };

    //manually refreshing scope
    $scope.safeApply = function () {
        if ( !$scope.$$phase ) {
            // Performance issue: use $digest() instead of $apply()
            $scope.$apply();
            //$scope.$digest();
        }
    };

    $scope.createTagBrowser = function () {
        var paramIds = [],
		parameters,
        paramValues = [];
        paramIds = [0, 1];
        paramValues = [Context.DataEvents.TagBrowser, {
            'Left': ( window.frameElement.getBoundingClientRect().left + ( ( $scope.FrameData.Width - 400 ) / 2 ) ),
            'Top': ( window.frameElement.getBoundingClientRect().top + ( ( $scope.FrameData.Height - 382 ) / 2 ) ),
            'Width': 400,
            'Height': 382,
            'WindowFlags': 95,
            'Caption': 'Browser View',
            'TargetObjectType': 998,
            'DisplayViewType': 0
        }];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    $scope.loadPath = function ( data, isSavedData ) { //1. update path field 2. request for contexts
        $scope.data.path = data;
        $scope.data.selectedPath = data;
        $scope.data.contexts = [];
        $scope.data.selectedContext = '';
        $scope.data.contextValues = [];
        $scope.data.selectedRow = -1;

        if ( isSavedData ) {
            if ( ( data === $scope.data.savedData.path ) && $scope.data.existingContext && $scope.data.existingContext.path ) {
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1], [Context.DataEvents.Contexts, data] );
                return;
            }
        }
        else {
            $scope.data.existingContext = null;
            $scope.data.isModified = true;
        }
        if ( $scope.safeApply ) { // Controller might not be created yet for this screen. 
            $scope.safeApply(); // Update bindings.
        }

        var paramIds = [],
            paramValues = [],
			parameters = {};
        paramIds = [0, 1];
        paramValues = [Context.DataEvents.Contexts, data];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    $scope.loadContexts = function ( data ) { //1. update contexts dropdown
        $scope.data.contexts = data;
        $scope.data.contextValues = [];
        $scope.data.selectedRow = -1;

        if ( !$scope.data.isModified && $scope.data.existingContext && $scope.data.existingContext.contextId ) {
            $scope.data.selectedContext = $scope.data.existingContext.contextId;
            WebCC.Extensions.HMI.DomainLogic.sendDLEvent( [0, 1], [Context.DataEvents.ContextValues, $scope.data.selectedContext] );
        }
        else {
            $scope.data.existingContext = null;
            $scope.data.isModified = true;
            $scope.data.selectedContext = '';
        }
        if ( $scope.safeApply ) { // Controller might not be created yet for this screen.
            $scope.safeApply(); // Update bindings.
        }
    };

    $scope.loadContextValues = function ( data ) {
        var sTime, eTime;
        $scope.data.selectedRow = -1;
        for ( var ix in data ) {
            sTime = window.DatePrecise( data[ix].startTime ).getTime();
            data[ix].startTime_format = _formatDate( sTime );
            eTime = window.DatePrecise( data[ix].endTime ).getTime();
            data[ix].endTime_format = _formatDate( eTime );

            if ( !$scope.data.isModified && $scope.data.existingContext && $scope.data.existingContext.value ) {
                if ( $scope.data.selectedContext === $scope.data.existingContext.contextId ) {
                    if ( data[ix].startTime_format === $scope.data.existingContext.startTime_format ) {
                        $scope.data.selectedRow = parseInt( ix );
                    }
                }
            }
            if ( $scope.data.savedData && $scope.data.savedData.contextId !== $scope.data.selectedContext ) {
                $scope.data.existingContext = null;
                $scope.data.isModified = true;
            }
        }

        $scope.data.contextValues = data;

        if ( $scope.safeApply ) { // Controller might not be created yet for this screen.
            $scope.safeApply(); // Update bindings.
        }
    };

    $scope.onPathChange = function ( data ) {
        var paramIds = [],
            paramValues = [],
			parameters = {},
			path;
        path = $scope.data.selectedPath;

        paramIds = [0, 1];
        paramValues = [Context.DataEvents.Contexts, path];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    $scope.onContextChange = function () {
        var paramIds = [],
            paramValues = [],
			parameters = {};

        paramIds = [0, 1];
        paramValues = [Context.DataEvents.ContextValues, $scope.data.selectedContext];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    $scope.onSelectRow = function ( rowIndex ) {
        $scope.data.selectedRow = rowIndex;
        if ( $scope.data.savedData ) {
            $scope.data.existingContext = null;
            $scope.data.isModified = true;
        }
    };

    $scope.onSaveContext = function () {
        var paramIds = [],
            paramValues = [],
			parameters = {},
			rowIndex,
			valueObj,
			contextValues;
        rowIndex = $scope.data.selectedRow;
        contextValues = $scope.data.contextValues;
        valueObj = contextValues[rowIndex];
        delete valueObj['$$hashKey'];
        valueObj.path = $scope.data.path || $scope.data.selectedPath;
        valueObj.contextId = $scope.data.selectedContext;
        paramIds = [0, 1, 2];
        paramValues = [Context.DataEvents.SelectContext, valueObj, _hostId];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    $scope.onCancel = function () {
        var paramIds = [],
            paramValues = [],
			parameters = {};

        paramIds = [0, 1, 2];
        paramValues = [Context.DataEvents.SelectContext, {}, _hostId];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    $scope.onClearContext = function () {
        var paramIds = [],
            paramValues = [],
			parameters = {};
        $scope.data.path = '';
        $scope.data.contexts = [];
        $scope.data.contextValues = [];
        $scope.data.selectedContext = '';
        $scope.data.selectedRow = -1;
        $scope.data.existingContext = null;
        $scope.data.savedData = null;

        paramIds = [0, 1, 2];
        paramValues = [Context.DataEvents.SelectContext, { clear: true }, _hostId];
        parameters = {
            paramIds: paramIds,
            paramValues: paramValues
        };
        _callback( parameters );
    };

    //function to set callback
    $scope.setCallback = function ( func ) {
        _callback = func;
    };

    $scope.labelMapping = function ( languageId ) {
        if ( languageId ) {
            WebCC.Extensions.X_Textbib.setLocale( languageId );
        }
        $scope.labels = [];
        $scope.labels['PlantObject'] = WebCC.Extensions.X_Textbib.getText( 'TBID_PlantObject' );
        $scope.labels['Contexts'] = WebCC.Extensions.X_Textbib.getText( 'TBID_Contexts' );
        $scope.labels['LoggedContextValues'] = WebCC.Extensions.X_Textbib.getText( 'TBID_LoggedContextValues' );
        $scope.labels['Value'] = WebCC.Extensions.X_Textbib.getText( 'TBID_Value' );
        $scope.labels['StartTime'] = WebCC.Extensions.X_Textbib.getText( 'TBID_StartTime' );
        $scope.labels['EndTime'] = WebCC.Extensions.X_Textbib.getText( 'TBID_EndTime' );
        $scope.labels['QualityCode'] = WebCC.Extensions.X_Textbib.getText( 'TBID_QualityCode' );
        $scope.labels['OK'] = WebCC.Extensions.X_Textbib.getText( 'TBID_OK' );
        $scope.labels['Cancel'] = WebCC.Extensions.X_Textbib.getText( 'TBID_Cancel' );
        $scope.labels['Clear'] = WebCC.Extensions.X_Textbib.getText( 'TBID_Clear' );
        return $scope.labels;
    };

    $scope.getLabelTexts = function () {
        return $scope.labelMapping();
    };

    $scope.handleLanguageChange = function ( languageId ) {
        return $scope.labelMapping( languageId );
    };

}] );
// Adds directive <contextControl/>
Context.contextApp.directive( 'contextControl', function () {
    return {
        restrict: 'E',
        replace: true,
        templateUrl: function ( element, attrs ) {
            return attrs.basedir + 'templates/contextdialog.html';
        }
    };
} );
