var CPM = ( CPM || {} );

CPM.toolbar = function ( currStyle ) {
    var _left, _toolbarPart, _toolbarGroup, _treeControl, topVal, height,
        self = this,
        _constants = CPM.Enums.Constants,
        _toolbarBtns = CPM.Enums.ToolbarButtons,
        _expandAllGroup, _expandAllBtnOpacity,
        _collapseAllGroup, _collapseAllBtnOpacity,
        _filterGroup, _filterBtnState,
        _toolbarBackRect, _toolbarBottomLine,
        _separatorLine = null,
        _styleFactory = CPM.StyleFactory.getCurrentStyleProps( currStyle ),
        _isExtendedStyle = currStyle.includes( CPM.Enums.StyleName.Extended ) ? true : false,
        _pressedbuttonStyles,
        _expPolygon, _collPolygon, _filterPolygon, _iconRectArray = [],

    _createExpandBorder = function () {
        CPM.svgUtil.createSVG( 'line', {
            id: 'ExpandAll_Line',
            x1: 2 * _left,
            x2: 2 * _left + _toolbarPart.border.width,
            y1: topVal + height - 1,
            y2: topVal + height - 1,
            'stroke-width': '2px',
            stroke: _styleFactory.ToolBar.BottomBorder,
            appendTo: _expandAllGroup
        } );
    },
    _createExpandAllButton = function () {
        var svgGroup, parentGroup, polygonGroup, rectGroup1, rectGroup2, rectGroup3;
        _expandAllGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'ExpandAll',
            opacity: _expandAllBtnOpacity,
            appendTo: _toolbarGroup
        } );

        _expandAllGroup.addEventListener( 'mouseleave', self.updateToolbarColor ); //Event added to update button gradient color on mouseleave
        if ( _isExtendedStyle ) {
            _createGradientElement( _expandAllGroup, _toolbarBtns.ExpandAll ); //Define default gradient color for the button
        }

        CPM.svgUtil.createSVG( 'rect', {
            id: 'ExpandAll_Rect',
            x: 2 * _left,
            y: topVal,
            width: _toolbarPart.border.width,
            height: height,
            stroke: _styleFactory.ToolBar.BorderColor1,
            'stroke-width': '1px',
            fill: _styleFactory.ToolBar.Fill,
            rx: _styleFactory.ToolBar.Rx,
            appendTo: _expandAllGroup
        } );
        if ( !_isExtendedStyle ) {
            _createExpandBorder();
        }
        //Svg part (icon) of ExpandAll button
        svgGroup = CPM.svgUtil.createSVG( 'svg', {
            id: 'ExpandAll_Svg',
            x: ( 3 * _left ) + _toolbarPart.border.strokeWidth + _toolbarPart.border.iconSpacing,
            y: topVal + 7,
            'shape-rendering': 'crispEdges',
            appendTo: _expandAllGroup
        } );

        parentGroup = CPM.svgUtil.createSVG( 'g', {
            appendTo: svgGroup
        } );

        polygonGroup = CPM.svgUtil.createSVG( 'g', {
            appendTo: parentGroup
        } );

        _createRect( polygonGroup, 'ExpandAll_rect1', 5, 7.83, 2, 9 );

        _expPolygon = CPM.svgUtil.createSVG( 'polygon', {
            id: 'ExpandAll_polygon',
            fill: _styleFactory.ToolBar.IconColor,
            points: '3 15.83 5.96 19.83 9 15.83 3 15.83',
            appendTo: polygonGroup
        } );

        _createRect( parentGroup, 'ExpandAll_rect2', 5, 2.83, 16, 4 );

        rectGroup1 = CPM.svgUtil.createSVG( 'g', {
            appendTo: parentGroup
        } );
        _createRect( rectGroup1, 'ExpandAll_rect3', 10, 7.83, 11, 1 );
        _createRect( rectGroup1, 'ExpandAll_rect4', 10, 9.83, 11, 1 );
        _createRect( rectGroup1, 'ExpandAll_rect5', 10, 7.83, 1, 3 );
        _createRect( rectGroup1, 'ExpandAll_rect6', 20, 7.83, 1, 3 );

        rectGroup2 = CPM.svgUtil.createSVG( 'g', {
            appendTo: parentGroup
        } );
        _createRect( rectGroup2, 'ExpandAll_rect7', 10, 11.83, 11, 1 );
        _createRect( rectGroup2, 'ExpandAll_rect8', 10, 13.83, 11, 1 );
        _createRect( rectGroup2, 'ExpandAll_rect9', 10, 11.83, 1, 3 );
        _createRect( rectGroup2, 'ExpandAll_rect10', 20, 11.83, 1, 3 );

        rectGroup3 = CPM.svgUtil.createSVG( 'g', {
            appendTo: parentGroup
        } );
        _createRect( rectGroup3, 'ExpandAll_rect11', 10, 15.83, 11, 1 );
        _createRect( rectGroup3, 'ExpandAll_rect12', 10, 17.83, 11, 1 );
        _createRect( rectGroup3, 'ExpandAll_rect13', 10, 15.83, 1, 3 );
        _createRect( rectGroup3, 'ExpandAll_rect14', 20, 15.83, 1, 3 );

        CPM.svgUtil.createSVG( 'rect', {
            width: 26,
            height: 21.67,
            fill: 'none',
            appendTo: svgGroup
        } );
        //End of the ExpandAll icon
    },
    _createCollapseBorder = function () {
        CPM.svgUtil.createSVG( 'line', {
            id: 'CollapseAll_Line',
            x1: ( 4 * _left ) + _toolbarPart.border.width + _constants.toolbarPadding,
            x2: ( 4 * _left ) + _toolbarPart.border.width + _constants.toolbarPadding + _toolbarPart.border.width,
            y1: topVal + height - 1,
            y2: topVal + height - 1,
            'stroke-width': '2px',
            stroke: _styleFactory.ToolBar.BottomBorder,
            appendTo: _collapseAllGroup
        } );
    },

    _createCollapseAllButton = function () {
        var svgGroup, rectGroup, polygonGroup;
        _collapseAllGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'CollapseAll',
            opacity: _collapseAllBtnOpacity,
            appendTo: _toolbarGroup
        } );
        _collapseAllGroup.addEventListener( 'mouseleave', self.updateToolbarColor ); //Event added to update button gradient color on mouseleave
        if ( _isExtendedStyle ) {
            _createGradientElement( _collapseAllGroup, _toolbarBtns.CollapseAll ); //Define default gradient color for the button
        }

        CPM.svgUtil.createSVG( 'rect', {
            id: 'CollapseAll_Rect',
            x: ( 4 * _left ) + _toolbarPart.border.width + _constants.toolbarPadding,
            y: topVal,
            width: _toolbarPart.border.width,
            height: height,
            stroke: _styleFactory.ToolBar.BorderColor1,
            'stroke-width': '1px',
            fill: _styleFactory.ToolBar.Fill,
            rx: _styleFactory.ToolBar.Rx,
            appendTo: _collapseAllGroup
        } );
        if ( !_isExtendedStyle ) {
            _createCollapseBorder();
        }
        //Svg part (icon) of CollapseAll button
        svgGroup = CPM.svgUtil.createSVG( 'svg', {
            id: 'CollapseAll_Svg',
            x: ( 5 * _left ) + _toolbarPart.border.strokeWidth + _toolbarPart.border.width + _constants.toolbarPadding + _toolbarPart.border.iconSpacing,
            y: topVal + 7,
            'shape-rendering': 'crispEdges',
            appendTo: _collapseAllGroup
        } );

        rectGroup = CPM.svgUtil.createSVG( 'g', {
            appendTo: svgGroup
        } );

        polygonGroup = CPM.svgUtil.createSVG( 'g', {
            appendTo: rectGroup
        } );

        _createRect( polygonGroup, 'CollapseAll_rect1', 5, 10.83, 2, 9 );

        _collPolygon = CPM.svgUtil.createSVG( 'polygon', {
            id: 'CollapseAll_polygon',
            fill: _styleFactory.ToolBar.IconColor,
            points: '9 11.83 6.04 7.83 3 11.83 9 11.83',
            appendTo: polygonGroup
        } );

        _createRect( rectGroup, 'CollapseAll_rect2', 5, 2.83, 16, 4 );

        CPM.svgUtil.createSVG( 'rect', {
            width: 26,
            height: 21.67,
            fill: 'none',
            appendTo: svgGroup
        } );
        //End of the CollapseAll icon
    },
    _createFilterBorder = function () {
        CPM.svgUtil.createSVG( 'line', {
            id: 'Filter_Line',
            x1: ( 6 * _left ) + ( 2 * _toolbarPart.border.width ) + ( 5 * _constants.toolbarPadding ) + 1,
            x2: ( 6 * _left ) + ( 2 * _toolbarPart.border.width ) + ( 5 * _constants.toolbarPadding ) + 1 + _toolbarPart.border.width,
            y1: topVal + height - 1,
            y2: topVal + height - 1,
            'stroke-width': '2px',
            stroke: _styleFactory.ToolBar.BottomBorder,
            appendTo: _filterGroup
        } );
    },
    _createFilterButton = function () {
        var svgGroup, rectGroup, polygonGroup;
        _filterGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'FilterButton',
            opacity: 1,
            appendTo: _toolbarGroup
        } );
        _filterGroup.addEventListener( 'mouseleave', self.updateToolbarColor ); //Event added to update button gradient color on mouseleave
        if ( _isExtendedStyle ) {
            _createGradientElement( _filterGroup, _toolbarBtns.Filter ); //Define default gradient color for the button
        }
        _separatorLine = CPM.svgUtil.createSVG( 'line', {
            x1: ( 6 * _left ) + ( 2 * _toolbarPart.border.width ) + ( 2 * _constants.toolbarPadding ),
            y1: topVal,
            x2: ( 6 * _left ) + ( 2 * _toolbarPart.border.width ) + ( 2 * _constants.toolbarPadding ),
            y2: topVal + height,
            stroke: 'gray',
            'stroke-width': 1,
            appendTo: _filterGroup
        } );
        CPM.svgUtil.createSVG( 'rect', {
            id: 'FilterButton_Rect',
            x: ( 6 * _left ) + ( 2 * _toolbarPart.border.width ) + ( 5 * _constants.toolbarPadding ) + 1,
            y: topVal,
            width: _toolbarPart.border.width,
            height: height,
            stroke: _styleFactory.ToolBar.BorderColor1,
            'stroke-width': '1px',
            fill: _isExtendedStyle && ( _filterBtnState === 1 ) ? _pressedbuttonStyles['fill'] : _styleFactory.ToolBar.Fill,
            rx: _styleFactory.ToolBar.Rx,
            appendTo: _filterGroup
        } );
        if ( !_isExtendedStyle ) {
            _createFilterBorder();
        }
        //Svg part (icon) of CollapseAll button
        svgGroup = CPM.svgUtil.createSVG( 'svg', {
            id: 'FilterButton_Svg',
            x: ( 7 * _left ) + _toolbarPart.border.strokeWidth + ( 2 * _toolbarPart.border.width ) + ( 5 * _constants.toolbarPadding ) + _toolbarPart.border.iconSpacing,
            y: topVal + 7,
            'shape-rendering': 'crispEdges',
            appendTo: _filterGroup
        } );
        rectGroup = CPM.svgUtil.createSVG( 'g', {
            appendTo: svgGroup
        } );
        polygonGroup = CPM.svgUtil.createSVG( 'g', {
            appendTo: rectGroup
        } );
        _filterPolygon = CPM.svgUtil.createSVG( 'polygon', {
            id: 'FilterButton_polygon',
            fill: _styleFactory.ToolBar.IconColor,
            points: '19,3 12.5,14 6,3',
            appendTo: polygonGroup
        } );
        _createRect( polygonGroup, 'FilterButton_icon_rect', 11, 11, 3, 7 );
        CPM.svgUtil.createSVG( 'rect', {
            width: 26,
            height: 21.67,
            fill: 'none',
            appendTo: svgGroup
        } );
        //End of the FilterButton icon
    },
    _createGradientElement = function ( parentDom, elemId ) {
        var defsGroup, linearGrad;
        //Defining gradient color for toolbar buttons
        defsGroup = CPM.svgUtil.createSVG( 'defs', {
            appendTo: parentDom
        } );

        linearGrad = CPM.svgUtil.createSVG( 'linearGradient', {
            id: 'ButtonBgGradient_LigtherDarker_' + elemId,
            x1: '50%',
            x2: '50%',
            y1: '0%',
            y2: '100%',
            gradientUnits: 'objectBoundingBox',
            appendTo: defsGroup
        } );

        CPM.svgUtil.createSVG( 'stop', {
            offset: '0.0',
            'stop-color': _constants.stopColor1,
            'stop-opacity': '1.0',
            appendTo: linearGrad
        } );

        CPM.svgUtil.createSVG( 'stop', {
            offset: '1.0',
            'stop-color': _constants.stopColor2,
            'stop-opacity': '1.0',
            appendTo: linearGrad
        } );
    },

    //Reset the gradient colors of toolbar buttons to their default values
    _resetToDefaults = function ( btnType ) {
        var linearGrad, buttonRect;
        if ( btnType === _toolbarBtns.ExpandAll ) {
            linearGrad = _treeControl.getElementById( 'ButtonBgGradient_LigtherDarker_ExpandAll' );
            buttonRect = _treeControl.getElementById( 'ExpandAll_Rect' );
        } else if ( btnType === _toolbarBtns.CollapseAll ) {
            linearGrad = _treeControl.getElementById( 'ButtonBgGradient_LigtherDarker_CollapseAll' );
            buttonRect = _treeControl.getElementById( 'CollapseAll_Rect' );
        } else {
            if ( btnType === _toolbarBtns.Filter ) {
                linearGrad = _treeControl.getElementById( 'ButtonBgGradient_LigtherDarker_FilterButton' );
                buttonRect = _treeControl.getElementById( 'FilterButton_Rect' );
            }
        }
        if ( linearGrad && buttonRect ) {
            linearGrad.childNodes[0].setAttribute( 'stop-color', _constants.stopColor1 );
            linearGrad.childNodes[1].setAttribute( 'stop-color', _constants.stopColor2 );
            buttonRect.setAttribute( 'stroke', _constants.btnBorderColor1 );
        }
    },

    _createRect = function ( parentDom, id, x, y, width, rectHeight ) {
        var rect;
        rect = CPM.svgUtil.createSVG( 'rect', {
            id: id,
            x: x,
            y: y,
            width: width,
            height: rectHeight,
            fill: _styleFactory.ToolBar.IconColor,
            appendTo: parentDom
        } );
        _iconRectArray.push( rect );
    },
    _setAttributes = function ( element, property, value ) {
        if ( element ) {
            element.setAttribute( property, value );
        }
    },
    _setButtonStateColor = function ( currButton, currStyleToolBarProps ) {
        var currButtonFillColor;
        if ( currButton ) {
            currButtonFillColor = currButton.getAttribute( 'fill' );
            switch ( currButtonFillColor ) {
                case currStyleToolBarProps.Fill:
                    currButton.setAttribute( 'fill', _styleFactory.ToolBar.Fill );
                    break;
                case currStyleToolBarProps.Hover:
                    currButton.setAttribute( 'fill', _styleFactory.ToolBar.Hover );
                    break;
                case currStyleToolBarProps.Pressed:
                    currButton.setAttribute( 'fill', _styleFactory.ToolBar.Pressed );
                    break;
                default:
                    currButton.setAttribute( 'fill', _styleFactory.ToolBar.Fill );
                    break;
            }
        }
    },
    _updateIconColor = function () {
        var i, length = _iconRectArray.length;
        for ( i = 0; i < length; i++ ) {
            _setAttributes( _iconRectArray[i], 'fill', _styleFactory.ToolBar.IconColor );
        }
        _setAttributes( _expPolygon, 'fill', _styleFactory.ToolBar.IconColor );
        _setAttributes( _collPolygon, 'fill', _styleFactory.ToolBar.IconColor );
        _setAttributes( _filterPolygon, 'fill', _styleFactory.ToolBar.IconColor );
    };



    this.createToolbar = function ( parentDom, toolbarGroup, data, bottomLine ) {
        var yVal, stroke;
        _left = data.Left;
        _toolbarPart = data.ToolbarPart;
        topVal = _toolbarPart.border.buttonTop;
        height = _toolbarPart.border.buttonHeight;
        _treeControl = parentDom;
        _toolbarGroup = toolbarGroup;
        _pressedbuttonStyles = data.pressedbuttonStyles;
        _filterBtnState = data.filterBtnState;
        yVal = _toolbarPart.border.topVal;
        if ( data.Enabled ) {
            if ( !_expandAllBtnOpacity && !_collapseAllBtnOpacity ) {
                _expandAllBtnOpacity = _collapseAllBtnOpacity = 1;
            }
        } else {
            _expandAllBtnOpacity = _collapseAllBtnOpacity = 0.5;
        }
        _toolbarBackRect = CPM.svgUtil.createSVG( 'rect', {
            x: 0,
            y: yVal,
            id: 'toolbarBackgroundRect2',
            width: data.Width,
            height: CPM.Enums.Constants.toolbarHeight,
            fill: data.white,
            appendTo: _toolbarGroup
        } );
        _isExtendedStyle = data.isExtendedStyle;
        if ( _isExtendedStyle ) {
            stroke = _styleFactory.ToolBar.BottomLineColor;
        } else {
            if ( bottomLine ) {
                stroke = _styleFactory.Control.HorizLineColor;
            } else {
                stroke = _styleFactory.ToolBar.BottomLineColor;
            }
        }

        _toolbarBottomLine = CPM.svgUtil.createSVG( 'line', {
            x1: 0,
            y1: CPM.Enums.Constants.toolbarHeight - 1,
            x2: data.Width,
            y2: CPM.Enums.Constants.toolbarHeight - 1,
            stroke: stroke,
            'stroke-width': 1,
            appendTo: _toolbarGroup
        } );
        _createExpandAllButton();
        _createCollapseAllButton();
        _createFilterButton();
    };

    this.updateWidth = function ( width ) {
        _setAttributes( _toolbarBackRect, 'width', width );
        _setAttributes( _toolbarBottomLine, 'x2', width );
    };

    this.setExpandBtnOpacity = function ( expandBtnOpacity ) {
        if ( _expandAllBtnOpacity !== expandBtnOpacity ) {
            _expandAllBtnOpacity = expandBtnOpacity;
            if ( _expandAllBtnOpacity === 0.5 ) {
                _resetToDefaults( _toolbarBtns.ExpandAll ); //Reset the expandAll button to default colors when the button opacity is 0.5 (disabled).
                if ( !_isExtendedStyle ) {
                    this.removeExpandBtnLine();
                }
            }
            else {
                if ( !_isExtendedStyle ) {
                    this.setExpandBtnLine();
                }
            }
            _expandAllGroup.setAttribute( 'opacity', _expandAllBtnOpacity );
        }
    };

    this.setCollapseBtnOpacity = function ( collapseBtnOpacity ) {
        if ( _collapseAllBtnOpacity !== collapseBtnOpacity ) {
            _collapseAllBtnOpacity = collapseBtnOpacity;
            if ( _collapseAllBtnOpacity === 0.5 ) {
                _resetToDefaults( _toolbarBtns.CollapseAll ); //Reset the collapseAll button to default colors when the button opacity is 0.5 (disabled).
                if ( !_isExtendedStyle ) {
                    this.removeCollapseBtnLine();
                }
            }
            else {
                if ( !_isExtendedStyle ) {
                    this.setCollapseBtnLine();
                }
            }
            _collapseAllGroup.setAttribute( 'opacity', _collapseAllBtnOpacity );
        }
    };

    this.isExpandAllEnabled = function () {
        return _expandAllBtnOpacity === 1 ? true : false;
    };

    this.isCollapseAllEnabled = function () {
        return _collapseAllBtnOpacity === 1 ? true : false;
    };

    this.updateToolbarColor = function ( evt ) {
        var target = evt.target || evt.srcElement, linearGrad, buttonRect;
        if ( _expandAllBtnOpacity === 1 && target.id.indexOf( 'ExpandAll' ) !== -1 ) {
            linearGrad = _treeControl.getElementById( 'ButtonBgGradient_LigtherDarker_ExpandAll' );
            buttonRect = _treeControl.getElementById( 'ExpandAll_Rect' );
        } else if ( _collapseAllBtnOpacity === 1 && target.id.indexOf( 'CollapseAll' ) !== -1 ) {
            linearGrad = _treeControl.getElementById( 'ButtonBgGradient_LigtherDarker_CollapseAll' );
            buttonRect = _treeControl.getElementById( 'CollapseAll_Rect' );
        } else {
            if ( _collapseAllBtnOpacity === 1 && target.id.indexOf( 'FilterButton' ) !== -1 ) {
                linearGrad = _treeControl.getElementById( 'ButtonBgGradient_LigtherDarker_Filter' );
                buttonRect = _treeControl.getElementById( 'FilterButton_Rect' );
            }
        }
        if ( linearGrad && buttonRect && _isExtendedStyle ) {
            switch ( evt.type ) {
                case 'mouseover':
                    linearGrad.childNodes[1].setAttribute( 'stop-color', _constants.stopColor3 );
                    buttonRect.setAttribute( 'stroke', _constants.btnBorderColor2 );
                    break;
                case 'mouseleave':
                    linearGrad.childNodes[1].setAttribute( 'stop-color', _constants.stopColor2 );
                    buttonRect.setAttribute( 'stroke', _constants.btnBorderColor1 );
                    break;
                case 'mousedown':
                case 'touchstart':
                    linearGrad.childNodes[0].setAttribute( 'stop-color', _constants.stopColor3 );
                    linearGrad.childNodes[1].setAttribute( 'stop-color', _constants.stopColor1 );
                    if ( target.id.indexOf( 'FilterButton' ) !== -1 ) {
                        if ( _filterBtnState === 0 ) {
                            buttonRect.setAttributeNS( null, 'fill', _pressedbuttonStyles['fill'] );
                            _filterBtnState = 1;
                        }
                        else {
                            buttonRect.setAttributeNS( null, 'fill', _styleFactory.ToolBar.Fill );
                            _filterBtnState = 0;
                        }
                    }
                    buttonRect.setAttribute( 'stroke', _constants.btnBorderColor2 );
                    break;
                case 'mouseup':
                case 'touchend':
                    linearGrad.childNodes[0].setAttribute( 'stop-color', _constants.stopColor1 );
                    linearGrad.childNodes[1].setAttribute( 'stop-color', _constants.stopColor3 );
                    break;
                default:
                    break;
            }
        }
        else {
            if ( buttonRect ) {
                switch ( evt.type ) {
                    case 'mouseover':
                        buttonRect.setAttribute( 'fill', _styleFactory.ToolBar.Hover );
                        break;
                    case 'mouseleave':
                        buttonRect.setAttribute( 'fill', _styleFactory.ToolBar.Fill );
                        break;
                    case 'mousedown':
                    case 'touchstart':
                        buttonRect.setAttribute( 'fill', _styleFactory.ToolBar.Pressed );
                        break;
                    default:
                        break;
                }
            }
        }
    };
    this.setExpandBtnLine = function ( expandAll ) {
        var lineStyle;
        lineStyle = _treeControl.getElementById( 'ExpandAll_Line' );
        if ( !lineStyle ) {
            _createExpandBorder();
            lineStyle = _treeControl.getElementById( 'ExpandAll_Line' );
        }
        if ( expandAll ) {
            lineStyle.setAttribute( 'y1', topVal - 1 );
            lineStyle.setAttribute( 'y2', topVal - 1 );
        }
        else {
            lineStyle.setAttribute( 'y1', topVal + height - 1 );
            lineStyle.setAttribute( 'y2', topVal + height - 1 );
        }
    };
    this.setCollapseBtnLine = function ( collapseAll ) {
        var lineStyle;
        lineStyle = _treeControl.getElementById( 'CollapseAll_Line' );
        if ( !lineStyle ) {
            _createCollapseBorder();
            lineStyle = _treeControl.getElementById( 'CollapseAll_Line' );
        }
        if ( collapseAll ) {
            lineStyle.setAttribute( 'y1', topVal - 1 );
            lineStyle.setAttribute( 'y2', topVal - 1 );
        }
        else {
            lineStyle.setAttribute( 'y1', topVal + height - 1 );
            lineStyle.setAttribute( 'y2', topVal + height - 1 );
        }
    };
    this.setFilterBtnLine = function ( isPressed ) {
        var lineStyle;
        lineStyle = _treeControl.getElementById( 'Filter_Line' );
        if ( !lineStyle ) {
            _createFilterBorder();
            lineStyle = _treeControl.getElementById( 'Filter_Line' );
        }
        if ( isPressed ) {
            lineStyle.setAttribute( 'y1', topVal - 1 );
            lineStyle.setAttribute( 'y2', topVal - 1 );
        }
        else {
            lineStyle.setAttribute( 'y1', topVal + height - 1 );
            lineStyle.setAttribute( 'y2', topVal + height - 1 );
        }
    };
    this.removeExpandBtnLine = function () {
        var expandAllLine;
        expandAllLine = _treeControl.getElementById( 'ExpandAll_Line' );
        _expandAllGroup.removeChild( expandAllLine );
    };
    this.removeCollapseBtnLine = function () {
        var collapseAllLine;
        collapseAllLine = _treeControl.getElementById( 'CollapseAll_Line' );
        _collapseAllGroup.removeChild( collapseAllLine );
    };
    this.updateToolBarStyles = function ( currentStyle, bottomLine, pressedbuttonStyles ) {
        var expandBorder, collapseBroder, filterBorder,
            collapseButtonRect, expandButtonRect, filterButtonRect,
             toolbarBackRect2,
            currentStyleProps;

        currentStyleProps = _styleFactory;
        _styleFactory = CPM.StyleFactory.getCurrentStyleProps( currentStyle );
        _isExtendedStyle = currentStyle.includes( CPM.Enums.StyleName.Extended ) ? true : false;
        _pressedbuttonStyles = pressedbuttonStyles;
        expandBorder = _treeControl.getElementById( 'ExpandAll_Line' );
        collapseBroder = _treeControl.getElementById( 'CollapseAll_Line' );
        filterBorder = _treeControl.getElementById( 'Filter_Line' );
        collapseButtonRect = _treeControl.getElementById( 'CollapseAll_Rect' );
        expandButtonRect = _treeControl.getElementById( 'ExpandAll_Rect' );
        filterButtonRect = _treeControl.getElementById( 'FilterButton_Rect' );
        toolbarBackRect2 = _treeControl.getElementById( 'toolbarBackgroundRect2' );
        if ( _isExtendedStyle ) {
            if ( expandBorder && expandBorder.parentNode ) {
                expandBorder.parentNode.removeChild( expandBorder );
                expandBorder = null;
            }
            if ( collapseBroder && collapseBroder.parentNode ) {
                collapseBroder.parentNode.removeChild( collapseBroder );
                collapseBroder = null;
            }
            if ( filterBorder && filterBorder.parentNode ) {
                filterBorder.parentNode.removeChild( filterBorder );
                filterBorder = null;
            }
            _createGradientElement( _expandAllGroup, _toolbarBtns.ExpandAll );
            _createGradientElement( _collapseAllGroup, _toolbarBtns.CollapseAll );
            _setAttributes( collapseButtonRect, 'fill', _styleFactory.ToolBar.Fill );
            _setAttributes( expandButtonRect, 'fill', _styleFactory.ToolBar.Fill );
            _setAttributes( filterButtonRect, 'fill', _isExtendedStyle && ( _filterBtnState === 1 ) ? _pressedbuttonStyles['fill'] : _styleFactory.ToolBar.Fill );
            _setAttributes( _toolbarBottomLine, 'stroke', _styleFactory.ToolBar.BottomLineColor );
        } else {
            _setButtonStateColor( expandButtonRect, currentStyleProps.ToolBar );
            if ( expandBorder ) {
                expandBorder.setAttribute( 'stroke', _styleFactory.ToolBar.BottomBorder );
            } else {
                _createExpandBorder();
                if ( _expandAllBtnOpacity === 0.5 ) {
                    this.setExpandBtnLine( true );
                }
            }
            _setButtonStateColor( collapseButtonRect, currentStyleProps.ToolBar );
            if ( collapseBroder ) {
                collapseBroder.setAttribute( 'stroke', _styleFactory.ToolBar.BottomBorder );
            } else {
                _createCollapseBorder();
                if ( _collapseAllBtnOpacity === 0.5 ) {
                    this.setCollapseBtnLine( true );
                }
            }
            _setButtonStateColor( filterButtonRect, currentStyleProps.ToolBar );
            if ( filterBorder ) {
                filterBorder.setAttribute( 'stroke', _styleFactory.ToolBar.BottomBorder );
            }
            else {
                _createFilterBorder();
                this.setFilterBtnLine( _filterBtnState );
            }
            _setAttributes( toolbarBackRect2, 'width', toolbarBackRect2.width.baseVal.value + 1 );
            if ( bottomLine ) {
                _setAttributes( _toolbarBottomLine, 'stroke', _styleFactory.Control.HorizLineColor );
            } else {
                _setAttributes( _toolbarBottomLine, 'stroke', _styleFactory.ToolBar.BottomLineColor );
            }
        }
        _setAttributes( expandButtonRect, 'rx', _styleFactory.ToolBar.Rx );
        _setAttributes( collapseButtonRect, 'rx', _styleFactory.ToolBar.Rx );
        _setAttributes( filterButtonRect, 'rx', _styleFactory.ToolBar.Rx );

        _setAttributes( toolbarBackRect2, 'fill', _styleFactory.Control.EvenBackColor );
        _setAttributes( collapseButtonRect, 'stroke', _styleFactory.ToolBar.BorderColor1 );
        _setAttributes( expandButtonRect, 'stroke', _styleFactory.ToolBar.BorderColor1 );
        _setAttributes( filterButtonRect, 'stroke', _styleFactory.ToolBar.BorderColor1 );
        _updateIconColor();
    };

    this.showBottomLine = function () {
        _setAttributes( _toolbarBottomLine, 'stroke', _styleFactory.Control.HorizLineColor );
    };
};