
var CPM = ( CPM || {} );

CPM.svgNodeHandler = function ( obj ) {
    var
    self = this,
    _urlPartTotalHeight = obj.urlPartTotalHeight,
    _toolbarHeight = obj.toolbarHeight,
    _searchComboBoxHeight = obj.searchComboBoxHeight,
    _nodeTextGroup,
    _parent,
    _vpSVgNodes = [],
    _vpAlarmIconNodes = [],
    _nodeHeight,
    _scrollIndex = 0,
    _count,
    _dataArray = null,
    _top,
    _left,
    _font,
    _selectedSvgNode = null,
    _selectedAlarmIconNode = null,
    _ctrlWidth,
    _alarmSummaryData = [],
    _alarmDataFromServer = {},

    _updateOnScroll = function ( data, isScrollbarCreated, isAlarmsPresent, horizontalLine ) {
        var i, dataIndex, y, nodeObj, nodeBBoxInfo, nodeWidth, svgNode, alarmIconNode, top, nodeProps = {};
        _alarmSummaryData = [];
        // find deepest node
        for ( i = 0; i < _count; i++ ) {
            svgNode = _vpSVgNodes[i];
            dataIndex = i + _scrollIndex;
            nodeObj = _dataArray[dataIndex];
            if ( nodeObj ) {
                nodeBBoxInfo = _getNodeWidth( nodeObj );
                if ( i === 0 ) {
                    nodeWidth = nodeBBoxInfo.nodeWidth;
                }
                if ( nodeWidth < nodeBBoxInfo.nodeWidth ) {
                    nodeWidth = nodeBBoxInfo.nodeWidth;
                }
            }
        }
        top = _urlPartTotalHeight + _toolbarHeight + _searchComboBoxHeight;
        // Below for loop takes care of node icon, expand/collapse icon, node text, selection of node, alarm data
        for ( i = 0; i < _count; i++ ) {
            svgNode = _vpSVgNodes[i];
            if ( isAlarmsPresent ) {
                alarmIconNode = _vpAlarmIconNodes[i];
            }
            dataIndex = i + _scrollIndex;
            nodeObj = _dataArray[dataIndex];
            if ( nodeObj ) {
                nodeProps.hasSearchText = nodeObj.hasSearchText;
                y = i * _nodeHeight;
                svgNode.update( nodeObj, _left, y );
                svgNode.createText( _createText( nodeObj ), data, i );
                if ( nodeObj.isSelected ) {
                    _selectedSvgNode = svgNode;
                    if ( isAlarmsPresent ) {
                        _selectedAlarmIconNode = nodeObj;
                    }
                }
                nodeProps.isSelected = nodeObj.isSelected;
                svgNode.setStyleForNode( nodeProps, data, i );
                if ( isAlarmsPresent ) {
                    alarmIconNode.setStyleForAlarmNode( nodeObj.isSelected, data, i );
                }
                _alarmSummaryData.push( nodeObj.fullPath );
            } else {    //node which was present previously, but has to be empty when vertical scroller has reached the bottom end
                svgNode.update();
                nodeProps.isSelected = false;
                svgNode.setStyleForNode( nodeProps, data, i );
                if ( isAlarmsPresent ) {
                    alarmIconNode.setStyleForAlarmNode( false, data, i );
                }
            }
        }
        self.updateAlarmSummary( null, data, isScrollbarCreated, isAlarmsPresent, horizontalLine );
        if ( nodeBBoxInfo ) {
            nodeBBoxInfo.nodeWidth = nodeWidth;
        }
        return nodeBBoxInfo;
    },

       _resetTextGroup = function () {
           if ( _nodeTextGroup ) {
               while ( _nodeTextGroup.firstChild ) {
                   _nodeTextGroup.removeChild( _nodeTextGroup.lastChild );
               }
           }
           _nodeTextGroup = CPM.svgUtil.createSVG( 'g', {
               id: 'treeGroup_iconTextGroup',
               transform: 'translate(0, 0 )',
               appendTo: _parent
           } );
       },
        _createText = function ( currText ) {
            var y, textHeight = 15,//Hardcoded as no configuration available in ES for font
            initX, x;
            y = _top +5 + ( textHeight * 0.75 ) +( ( currText.index - _scrollIndex ) * ( 18.5 +textHeight ) );
            if( currText &&( currText.isSelected || currText.childSelected ) && currText.ParentId && currText.isNodeNavigated ){
                initX = CPM.Enums.Constants.iconToIconToTextGap + ( CPM.Enums.Constants.iconDim / 2 ) + CPM.Enums.Constants.horizontalgap;
            } else {
                initX = CPM.Enums.Constants.iconToIconToTextGap + ( CPM.Enums.Constants.iconDim / 2 ) + CPM.Enums.Constants.horizontalgap -(2*_left);
            }
            x = initX + ( ( currText.depth ? currText.depth : 0 ) * CPM.Enums.Constants.iconToIconGap );
            return {
                x: x,
                y: y,
                currText: currText.Name,
                nodeTextGroup: _nodeTextGroup,
                font: _font,
                isSelected: currText.isSelected
            };
        },
        _getNodeWidth = function ( node ) {
            var nodeDepth = node.depth, nodeNameWidth,
            initX = _left + CPM.Enums.Constants.iconToIconToTextGap + ( CPM.Enums.Constants.iconDim / 2 ) + CPM.Enums.Constants.horizontalgap,
            x = initX + ( ( nodeDepth ? nodeDepth : 0 ) * CPM.Enums.Constants.iconToIconGap ),
            bbox = CPM.svgUtil.getTextBBox( { Size: _font.Size, Name: _font.family }, '' + node.Name );
            nodeNameWidth = bbox.width + x;
            return {
                nodeWidth: nodeNameWidth,
                textBBox: bbox
            };
        },
        _updateSummary = function ( i, fullPath ) {
            var isAlarmIconRemove = true;
            if ( _vpAlarmIconNodes[i] && _alarmDataFromServer ) {
                if ( _alarmDataFromServer.RemovedAlarms && _alarmDataFromServer.RemovedAlarms[fullPath] === 0 ) {
                    _vpAlarmIconNodes[i].changeAlarmState( false );
                    isAlarmIconRemove = false;

                }
                if ( _alarmDataFromServer.ActiveAlarms && _alarmDataFromServer.ActiveAlarms[fullPath] === 1 ) {
                    _vpAlarmIconNodes[i].changeAlarmState( true );
                    isAlarmIconRemove = false;

                }
                if ( isAlarmIconRemove ) {
                    _vpAlarmIconNodes[i].changeAlarmState( false );
                }

            }
        },

        _getBgAttributes = function ( parent, data, i ) {
            var x = 0, y, attrs = {};
            y = i * data.nodeHeight;
            attrs = {
                width: data.Width,
                height: data.nodeHeight,
                appendTo: parent,
                x: x,
                y: y,
                fill: ( i % 2 !== 0 ) ? data.grey3 : data.white,
                stroke: data.HorizLineColor,
                nodeIconColor: data.NodeIconColor,
                expCollIconColor: data.ExpCollIconColor
            };
            return attrs;
        };

    this.createBgRects = function ( parent, data ) {
        var i, svgNode, attrs;
        _parent = parent;
        _vpSVgNodes = [];
        _count = data.count;
        _nodeHeight = data.nodeHeight;
        _top = data.Top;
        _left = data.Left;
        _ctrlWidth = data.Width;
        _urlPartTotalHeight = data.UrlHeight;
        _toolbarHeight = data.ToolbarHeight;
        _searchComboBoxHeight = data.SearchComboBoxHeight;
        for ( i = 0; i < _count + 1; i++ ) {
            attrs = {};
            attrs = _getBgAttributes( parent, data, i, top );
            svgNode = new CPM.svgNode( { Left: data.Left, Top: data.Top, index: i, selectionColor: data.SelectionBackColor, selectionForeColor: data.SelectionForeColor } );
            svgNode.create( attrs );
            _vpSVgNodes.push( svgNode );
        }
        _resetTextGroup();
    };


    this.updateBgRects = function ( dataArray, isResetScrollReq, data, isAlarmsPresent ) {
        var svgNode, y, idx, nodeBBoxInfo, nodeWidth, nodeData, nodeIdx, top, alarmIconNode, nodeText, nodeProps = {};
        _alarmSummaryData = [];
        _font = data.Font;
        _urlPartTotalHeight = data.URLPart.border.height;
        _toolbarHeight = data.ToolbarPart.border.height;
        _searchComboBoxHeight = data.SearchComboBoxPart.border.height;
        top = _urlPartTotalHeight + _toolbarHeight + _searchComboBoxHeight;
        if ( dataArray ) {
            _dataArray = dataArray;
        }
        if ( isResetScrollReq ) {
            _scrollIndex = 0;
        }
        //On control resize, if the viewport has space to show more tree nodes then adjust the scroll index accordingly to show more nodes. 
        if ( _scrollIndex > 0 && ( _count > ( _dataArray.length - _scrollIndex ) ) ) {
            if ( _dataArray.length > _count ) {
                idx = _scrollIndex = _dataArray.length - _count;
            } else {
                idx = _scrollIndex = 0;//Reset the scroll index to 0 if the tree length becomes less than the viewport count i.e. the complete tree can be shown within the viewport on resize.
            }
        } else {
            idx = _scrollIndex;
        }
        //nodeIdx is used in this for loop to find deepest node and is incremented depending on nodes visible in viewport
        nodeIdx = idx;
        for ( var i = 0; i < _count; i++ ) {
            svgNode = _vpSVgNodes[i];
            nodeData = _dataArray[nodeIdx];
            if ( nodeData ) {
                nodeBBoxInfo = _getNodeWidth( nodeData );
                if ( i === 0 ) {
                    nodeWidth = nodeBBoxInfo.nodeWidth;
                }
                if ( nodeWidth < nodeBBoxInfo.nodeWidth ) {
                    nodeWidth = nodeBBoxInfo.nodeWidth;
                }
            }
            nodeIdx++;
        }
        // Below for loop takes care of node icon, expand/collapse icon, node text, selection of node, alarm data
        for ( i = 0; i < _count; i++ ) {
            svgNode = _vpSVgNodes[i];
            nodeData = _dataArray[idx];
            if ( nodeData ) {
                nodeProps.isSelected = nodeData.isSelected;
                nodeProps.hasSearchText = nodeData.hasSearchText;
                y = i * _nodeHeight;
                nodeText = _createText( _dataArray[idx] );
                svgNode.createText( nodeText, data, i );
                svgNode.createNodeIcon( nodeText, i );
                svgNode.update( nodeData, _left, y );
                svgNode.setStyleForNode( nodeProps, data, i );
                if ( isAlarmsPresent ) {
                    alarmIconNode = _vpAlarmIconNodes[i];
                    alarmIconNode.updateAlarmIcon( nodeData, y, data.Width );
                    alarmIconNode.setStyleForAlarmNode( nodeData.isSelected, data, i );
                }
                _alarmSummaryData.push( nodeData.fullPath );
                idx++;
            } else {
                svgNode.update();
                if ( isAlarmsPresent ) {
                    alarmIconNode = _vpAlarmIconNodes[i];
                    alarmIconNode.setStyleForAlarmNode( false, data, i );
                }
            }
        }
        if ( nodeBBoxInfo ) {
            nodeBBoxInfo.nodeWidth = nodeWidth;
        }
        return nodeBBoxInfo;
    };

    this.createAlarmBgRects = function ( parent, data ) {
        var i, alarmIconNode, attrs;
        _vpAlarmIconNodes = [];
        for ( i = 0; i < _count + 1; i++ ) {
            attrs = {};
            attrs = _getBgAttributes( parent, data, i );
            alarmIconNode = new CPM.svgNode( { index: i, selectionColor: data.SelectionBackColor, selectionForeColor: data.SelectionForeColor } );
            alarmIconNode.createAlarmIconGroup( attrs );
            _vpAlarmIconNodes.push( alarmIconNode );
        }
    };

    this.onScroll = function ( yValue, stylePropObj, isScrollbarCreated, isAlarmsPresent, horizontalLine ) {
        var bBoxData;
        _scrollIndex = yValue;
        bBoxData = _updateOnScroll( stylePropObj, isScrollbarCreated, isAlarmsPresent, horizontalLine );
        return bBoxData;
    };

    this.getScrollIndex = function () {
        return _scrollIndex;
    };

    this.getNodeData = function ( target ) {
        var idArray = target.id.split( '_' ), idx;
        idx = parseInt( idArray[idArray.length - 1] ) + _scrollIndex;
        //if ( idx > _count ) {
        //    idx = parseInt( idArray[idArray.length - 1] );
        //}
        return _dataArray[idx];

    };
    this.resetDataArray = function ( data ) {
        _dataArray = data;
    };
    this.getIconTextGroup = function () {
        return _nodeTextGroup;
    };
    this.setSelectedNode = function ( node, stylePropObj, isAlarmsPresent, horizontalLine ) {
        var vpIndx, nodeProps = {};
        if ( node ) {
            vpIndx = node.index - _scrollIndex;
            if ( vpIndx === _vpSVgNodes.length - 2 && horizontalLine ) {
                return;
            }
            if ( _vpSVgNodes[vpIndx] ) {
                _selectedSvgNode = _vpSVgNodes[vpIndx];
                nodeProps.isSelected = node.isSelected;
                nodeProps.hasSearchText = node.hasSearchText;
                _selectedSvgNode.setStyleForNode( nodeProps, stylePropObj, vpIndx );
            }
            if ( isAlarmsPresent && _vpAlarmIconNodes[vpIndx] ) {
                _selectedAlarmIconNode = _vpAlarmIconNodes[vpIndx];
                _selectedAlarmIconNode.setStyleForAlarmNode( node.isSelected, stylePropObj, vpIndx );
            }
        }
    };
    this.updateAlarmSummary = function ( data, styleProp, isScrollbarCreated, isAlarmsPresent, horizontalLine ) {
        var len, i, fullPath, ctrlWidth, y, lineColor, foreColor, lastNodeIdx, nodeProps = {},
            dataLength, svgNode, alarmIconNode, scrollBarWidth, top, dataIndex;
        len = _vpSVgNodes.length;
        lineColor = styleProp.stylePropObj.Control.HorizLineColor;
        foreColor = styleProp.stylePropObj.Control.ForeColor;
        scrollBarWidth = styleProp.stylePropObj.ScrollBar.Width;
        if ( horizontalLine ) {
            dataLength = _count - 1;
        }
        ctrlWidth = _ctrlWidth;
        if ( data ) {
            _alarmDataFromServer = data;
        }
        if ( Object.keys( _alarmDataFromServer ).length ) {
            if ( isAlarmsPresent ) {
                ctrlWidth = ctrlWidth - CPM.Enums.Constants.alarmIconWidth;
            }
            if ( isScrollbarCreated ) {
                if ( !isAlarmsPresent ) {
                    ctrlWidth = ctrlWidth + scrollBarWidth;
                }
                ctrlWidth = ctrlWidth - scrollBarWidth;
            }
            top = _urlPartTotalHeight + _toolbarHeight + _searchComboBoxHeight;
            for ( i = 0; i < len; i++ ) {
                fullPath = _alarmSummaryData[i];
                y = top + ( i * _nodeHeight );
                svgNode = _vpSVgNodes[i];
                if ( isAlarmsPresent ) {
                    alarmIconNode = _vpAlarmIconNodes[i];
                    alarmIconNode.changeAlarmSeperatorState( ctrlWidth, lineColor, foreColor, y );
                    dataIndex = i + _scrollIndex;
                    if ( _dataArray[dataIndex] ) {
                        alarmIconNode.setStyleForAlarmNode( _dataArray[dataIndex].isSelected, styleProp, i );
                    }
                    svgNode.updateRectWidth( ctrlWidth );
                } else {
                    svgNode.updateRectWidth( _ctrlWidth );
                }
                _updateSummary( i, fullPath );
                if ( dataLength === i ) {
                    svgNode.hideLastNode();
                    alarmIconNode = _vpAlarmIconNodes[i];
                    alarmIconNode.hideLastAlarmNode();
                    if ( _dataArray[dataLength] && _dataArray[dataLength].isSelected ) {
                        nodeProps.isSelected = false;
                        nodeProps.hasSearchText = _dataArray[dataLength].hasSearchText;
                        svgNode.setStyleForNode( nodeProps, styleProp, i );
                        alarmIconNode.setStyleForAlarmNode( false, styleProp, i );
                    }
                } else {
                    if ( !isAlarmsPresent ) {
                        svgNode.showLastNode();
                        lastNodeIdx = len - 2;
                        dataIndex = i + _scrollIndex;
                        if ( dataIndex === lastNodeIdx && _dataArray[dataIndex] && _dataArray[dataIndex].isSelected ) {
                            nodeProps.isSelected = true;
                            nodeProps.hasSearchText = _dataArray[dataIndex].hasSearchText;
                            svgNode.setStyleForNode( nodeProps, styleProp, i );
                        }
                    }
                }
            }
        }
    };
    this.updateSelectionBackColor = function ( color ) {
        if ( _selectedSvgNode ) {
            _selectedSvgNode.updateSelectionBackColor( color );
        }
        if ( _selectedAlarmIconNode ) {
            _selectedAlarmIconNode.updateSelectionBackColor( color );
        }
    };

    this.updateSelectionForeColor = function ( color ) {
        if ( _selectedSvgNode ) {
            _selectedSvgNode.updateSelectionForeColor( color );
        }
    };
    this.updateNodeStyle = function ( stylePropObj, isAlarmsPresent ) {
        var i, vpLength, altBackFill, svgNode, alarmIconNode, nodeObj, dataIndex, nodeProps = {};
        vpLength = _vpSVgNodes.length;
        for ( i = 0; i < vpLength; i++ ) {
            altBackFill = ( i % 2 !== 0 ) ? stylePropObj.grey3 : stylePropObj.white;
            svgNode = _vpSVgNodes[i];
            dataIndex = i + _scrollIndex;
            nodeObj = _dataArray[dataIndex];
            svgNode.updateNodeStyle( stylePropObj, altBackFill, false );
            if ( nodeObj && nodeObj.isSelected ) {
                nodeProps.isSelected = true;
                nodeProps.hasSearchText = nodeObj.hasSearchText;
                svgNode.setStyleForNode( nodeProps, stylePropObj, i );
            }
            if ( isAlarmsPresent ) {
                alarmIconNode = _vpAlarmIconNodes[i];
                alarmIconNode.updateNodeStyle( stylePropObj, altBackFill, isAlarmsPresent );
                if ( nodeObj && nodeObj.isSelected ) {
                    alarmIconNode.setStyleForAlarmNode( nodeObj.isSelected, stylePropObj, i );
                }
            }
        }
    };

};