var CPM = ( CPM || {} );

CPM.svgNode = function ( data ) {
    var _bgRect,
        _rectColor,
        _currRectColor,
        _nodeText,
        _rootIcon,
        _alarmSeparatorVertLine,
        _arrowIconGrp,
        _alarmIconGrp,
        _alarmIconSeparatorRect,
        _alarmIconSeparatorGrp,
        _alarmSeparatorHorLine,
        _iconGroup,
        _nodeGroup,
        _openFolderIcon,
        _closedFolderIcon,
        _linkedNodeGrpIcon,
        _traverseNodeGrpIcon,
        _mainIconSvg,
        _expandCollapseIcon,
        _horizSeparatorLine,
        _alarmSvgIcon,
        _attrs,
        _createAlarmIcon = function ( nodeHeight ) {
            var alarmIconSvg = CPM.svgUtil.createSVG( 'svg', {
                id: 'treeGroup_summaryAlarm_Svg_' + data.index,
                height: nodeHeight,
                width: CPM.Enums.Constants.alarmIconWidth,
                viewBox: '5 5 20 20',
                fill: 'red',
                appendTo: _alarmIconGrp,
                cursor: 'pointer'
            } );
            CPM.svgUtil.createSVG( 'rect', {
                width: '100%',
                height: '100%',
                appendTo: alarmIconSvg,
                x: 5,
                y: 0,
                fill: 'red',
                'fill-opacity': 0,
                id: 'treeGroup_summaryAlarm_Rect_' + data.index
            } );

            _alarmSvgIcon = CPM.svgUtil.createSVG( 'path', {
                d: 'M18.7,16.1l-5.3-9.5c-0.3-0.5-0.7-0.5-1,0l-5.1,9.5c-0.3,0.5,0,0.9,0.5,0.9h10.3C18.8,17,19,16.6,18.7,16.1z M14,16h-2 v-2h2V16z M14,13h-2V9h2V13z',
                fill: 'black',
                appendTo: alarmIconSvg,
                id: 'treeGroup_summaryAlarm_Path_' + data.index
            } );
        },
        _createAlarmIconSeparator = function ( attrs ) {
            _alarmIconSeparatorRect = CPM.svgUtil.createSVG( 'rect', {
                x: 0,
                y: 0,
                width: 2 * CPM.Enums.Constants.alarmIconWidth,
                height: attrs.height,
                fill: attrs.fill,
                'opacity': 1,
                position: 'fixed',
                style: 'cursor: pointer',
                id: 'alarm_nodeRect' + data.index,
                appendTo: _alarmIconSeparatorGrp
            } );
            _alarmSeparatorVertLine = CPM.svgUtil.createSVG( 'line', {
                x1: 0,
                x2: 0,
                y1: 0,
                y2: attrs.height,
                stroke: attrs.stroke,
                'stroke-width': '1px',
                id: 'alarm_line' + data.index,
                appendTo: _alarmIconSeparatorGrp
            } );
            _alarmSeparatorHorLine = CPM.svgUtil.createSVG( 'line', {
                x1: 0,
                x2: 50,
                y1: attrs.height,
                y2: attrs.height,
                stroke: attrs.stroke,
                'stroke-width': '1px',
                appendTo: _alarmIconSeparatorGrp
            } );
        },
        _show = function ( element ) {
            element.setAttribute( 'display', 'block' );
        },
        _hide = function ( element ) {
            element.setAttribute( 'display', 'none' );
        },
        _createRootIcon = function ( nodeIconSvg, x, y, nodeIconColor ) {
            var _rootGrp1, _rootGrp2, _rootGrp3;
            _rootIcon = CPM.svgUtil.createSVG( 'svg', {
                x: x, y: y,
                width: '26', height: '22',
                viewBox: '0 0 26 22',
                appendTo: nodeIconSvg,
                id: 'rootIcon',
                fill: nodeIconColor
            } );
            _rootGrp1 = CPM.svgUtil.createSVG( 'g', {
                appendTo: _rootIcon
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M13,9L9.5,5.5L13,2l3.5,3.5L13,9z M10.6,5.5L13,7.9l2.4-2.4L13,3.1L10.6,5.5z',
                id: 'treeGroup__rootGrp1_path',
                appendTo: _rootGrp1
            } );
            CPM.svgUtil.createSVG( 'polygon', {
                points: '13,2.6 13,8.4 15.9,5.5',
                id: 'treeGroup__rootGrp1_polygon',
                appendTo: _rootGrp1
            } );
            _rootGrp2 = CPM.svgUtil.createSVG( 'g', {
                appendTo: _rootIcon
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M7,20l-3.5-3.5L7,13l3.5,3.5L7,20z M4.6,16.5L7,18.9l2.4-2.4L7,14.1L4.6,16.5z',
                id: 'treeGroup__rootGrp2_path',
                appendTo: _rootGrp2
            } );
            CPM.svgUtil.createSVG( 'polygon', {
                points: '7,13.6 7,19.4 9.9,16.5',
                id: 'treeGroup__rootGrp2_polygon',
                appendTo: _rootGrp2
            } );
            _rootGrp3 = CPM.svgUtil.createSVG( 'g', {
                appendTo: _rootIcon
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M19,20l-3.5-3.5L19,13l3.5,3.5L19,20z M16.6,16.5l2.4,2.4l2.4-2.4L19,14.1L16.6,16.5z',
                id: 'treeGroup__rootGrp3_path',
                appendTo: _rootGrp3
            } );
            CPM.svgUtil.createSVG( 'polygon', {
                points: '19,13.6 19,19.4 21.9,16.5',
                id: 'treeGroup__rootGrp3_polygon',
                appendTo: _rootGrp3
            } );

            CPM.svgUtil.createSVG( 'rect', {
                x: '12', y: '8',
                width: '2',
                height: '4',
                appendTo: _rootIcon
            } );
            CPM.svgUtil.createSVG( 'rect', {
                x: '6', y: '10',
                width: '14',
                height: '2',
                appendTo: _rootIcon
            } );
            CPM.svgUtil.createSVG( 'rect', {
                x: '6', y: '10',
                width: '2',
                height: '4',
                appendTo: _rootIcon
            } );
            CPM.svgUtil.createSVG( 'rect', {
                x: '18', y: '10',
                width: '2',
                height: '4',
                appendTo: _rootIcon
            } );
        },
        _createOpenFolderIcon = function () {
            // Plant object folder opened 
            var expandedGrp = CPM.svgUtil.createSVG( 'g', {
                appendTo: _openFolderIcon
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M18,11l-3.5,3.5L18,18l3.5-3.5Zm-2.09,3.5L18,12.41v4.17Z',
                id: 'treeGroup_expandedGrp_path1',
                appendTo: expandedGrp
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M24.5,10.5,22,8l-2.5,2.5L22,13Zm-3.59,0L22,9.41v2.17Z',
                id: 'treeGroup_expandedGrp_path2',
                appendTo: expandedGrp
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M19.5,18.5,22,21l2.5-2.5L22,16Zm1.41,0L22,17.41v2.17Z',
                id: 'treeGroup_expandedGrp_path3',
                appendTo: expandedGrp
            } );
            CPM.svgUtil.createSVG( 'path', {
                d: 'M5.9,10H16V8H9.4L7.5,6H2V17l3.1-6.4A.76.76,0,0,1,5.9,10Z',
                id: 'treeGroup_expandedGrp_path4',
                appendTo: expandedGrp
            } );
            CPM.svgUtil.createSVG( 'polygon', {
                points: '12.52 14.5 13.51 13.51 16.02 11 6.4 11 3.4 17 15.02 17 13.51 15.49 12.52 14.5',
                id: 'treeGroup_expandedGrp_polygon',
                appendTo: expandedGrp
            } );

            CPM.svgUtil.createSVG( 'rect', {
                width: '26',
                height: '22',
                fill: 'none',
                appendTo: expandedGrp
            } );
        },
    _createClosedFolderIcon = function () {
        // Plant object folder closed     
        var collapsedGrp = CPM.svgUtil.createSVG( 'g', {
            appendTo: _closedFolderIcon
        } );
        CPM.svgUtil.createSVG( 'polygon', {
            points: '16 8 9.4 8 7.5 6 2 6 2 10 16 10 16 8',
            id: 'treeGroup_collapsedGrp_polygon',
            appendTo: collapsedGrp
        } );
        CPM.svgUtil.createSVG( 'path', {
            d: 'M18,11l-3.5,3.5L18,18l3.5-3.5Zm0,5.59L15.91,14.5,18,12.41Z',
            id: 'treeGroup_collapsedGrp_path1',
            appendTo: collapsedGrp
        } );
        CPM.svgUtil.createSVG( 'path', {
            d: 'M24.5,10.5,22,8l-2.5,2.5L22,13ZM22,9.41v2.17L20.91,10.5Z',
            id: 'treeGroup_collapsedGrp_path2',
            appendTo: collapsedGrp
        } );
        CPM.svgUtil.createSVG( 'path', {
            d: 'M19.5,18.5,22,21l2.5-2.5L22,16ZM22,19.59,20.91,18.5,22,17.41Z',
            id: 'treeGroup_collapsedGrp_path3',
            appendTo: collapsedGrp
        } );
        CPM.svgUtil.createSVG( 'polygon', {
            points: '12.52 14.5 13.51 13.51 16.02 11 2 11 2 17 15.02 17 13.51 15.49 12.52 14.5',
            id: 'treeGroup_collapsedGrp_path4',
            appendTo: collapsedGrp
        } );

        CPM.svgUtil.createSVG( 'rect', {
            width: '26',
            height: '22',
            fill: 'none',
            appendTo: collapsedGrp
        } );
    },
    _createlinkedNodeGrpIcon = function () {
        // Linked node 
        var linkedNodeGrp = CPM.svgUtil.createSVG( 'g', {
            appendTo: _linkedNodeGrpIcon
        } );
        CPM.svgUtil.createSVG( 'path', {
            d: 'M10,7,5.5,11.5,10,16l4.5-4.5ZM6.91,11.5,10,8.41v6.17Z',
            id: 'treeGroup_linkedNodeGrp_path1',
            appendTo: linkedNodeGrp
        } );
        CPM.svgUtil.createSVG( 'path', {
            d: 'M18.5,6.5,15,3,11.5,6.5,15,10Zm-5.59,0L15,4.41V8.59Z',
            id: 'treeGroup_linkedNodeGrp_path2',
            appendTo: linkedNodeGrp
        } );
        CPM.svgUtil.createSVG( 'path', {
            d: 'M11.5,16.5,15,20l3.5-3.5L15,13Zm1.41,0L15,14.41v4.17Z',
            id: 'treeGroup_linkedNodeGrp_path3',
            appendTo: linkedNodeGrp
        } );
        CPM.svgUtil.createSVG( 'rect', {
            width: '26',
            height: '22',
            fill: 'none',
            appendTo: linkedNodeGrp
        } );
    },

    _setNodeOpacity = function ( elements, value ) {
        var i,
        length = elements.length;

        for ( i = 0; i < length; i++ ) {
            _setElementProp( elements[i], 'fill-opacity', value );
        }
    },

    _setElementProp = function ( element, prop, value ) {
        if ( element ) {
            element.setAttribute( prop, value );
        }
    };

    this.create = function ( attrs ) {
        _attrs = attrs;
        _nodeGroup = CPM.svgUtil.createSVG( 'g', {
            id: 'treeGroup_nodegroup_' + data.index,
            appendTo: attrs.appendTo,
            'data-tif-id': 'CPMNodeGroup_' + data.index,
            'data-tif-type': 'WSI:CpmTreeNode'
        } );
        _nodeGroup.TifProperties = {
            tif: {},
            item: {
                nodes: [],
                expanded: false,
                selected: false,
                text: null,
                nodeId: null,
                tifId: _nodeGroup.getAttribute( 'data-tif-id' )
            }
        };
        _bgRect = CPM.svgUtil.createSVG( 'rect', {
            width: attrs.width,
            height: attrs.height,
            appendTo: _nodeGroup,
            x: attrs.x,
            y: attrs.y,
            fill: attrs.fill,
            id: 'treeGroup_nodeBgRect_' + data.index
        } );
        _horizSeparatorLine = CPM.svgUtil.createSVG( 'line', {
            x1: attrs.x,
            x2: attrs.width,
            y1: attrs.y + attrs.height,
            y2: attrs.y + attrs.height,
            stroke: attrs.stroke,
            'stroke-width': '1px',
            appendTo: _nodeGroup
        } );
        _rectColor = attrs.fill;
        _currRectColor = attrs.fill;
    };

    this.createAlarmIconGroup = function ( attrs ) {
        _alarmIconSeparatorGrp = CPM.svgUtil.createSVG( 'g', {
            appendTo: attrs.appendTo,
            display: 'none',
            id: 'alarmSeparator_Grp_' + data.index
        } );
        //alarm icon
        _alarmIconGrp = CPM.svgUtil.createSVG( 'g', {
            appendTo: attrs.appendTo,
            display: 'none',
            id: 'alarmIcon_Grp_' + data.index
        } );
        _createAlarmIconSeparator( attrs );
        _createAlarmIcon( attrs.height );
    };

    this.updateAlarmIcon = function ( node, y, width ) {
        var alarmIconX;
        if ( node ) {
            alarmIconX = width - CPM.Enums.Constants.alarmIconWidth;
            _show( _alarmIconSeparatorGrp );
            _alarmIconSeparatorGrp.setAttribute( 'transform', 'translate(' + ( alarmIconX ) + ',' + ( y ) + ')' );
            _show( _alarmIconGrp );
            _alarmIconGrp.setAttribute( 'transform', 'translate(' + ( alarmIconX + CPM.Enums.Constants.alarmIconLeftPadding ) + ',' + ( y + CPM.Enums.Constants.topPaddingAlarmIcon ) + ')' );
        } else {
            _hide( _alarmIconGrp );
        }
    };

    this.update = function ( node, left, y ) {
        var x, iconSvg;
        if ( node ) {
            if ( _traverseNodeGrpIcon && ( node.isSelected || node.childSelected ) && node.ParentId && node.isNodeNavigated ) {
                x = ( node.depth * CPM.Enums.Constants.iconToIconGap ) + CPM.Enums.Constants.horizontalgap;// - (2*left);
            } else{
                x = ( node.depth * CPM.Enums.Constants.iconToIconGap ) + CPM.Enums.Constants.horizontalgap - (2*left);
            }
            _show( _iconGroup );
            _iconGroup.setAttribute( 'transform', 'translate(' + x + ',' + y + ' )' ); //TODO: remove y update

            _nodeGroup.TifProperties = {
                tif: {},
                item: {
                    nodes: node.Children ? node.Children : [],
                    expanded: node.IsExpanded,
                    text: node.Name,
                    nodeId: node.Id,
                    tifId: _nodeGroup.getAttribute( 'data-tif-id' )
                }
            };
            if ( _traverseNodeGrpIcon && ( node.isSelected || node.childSelected ) && node.ParentId && node.isNodeNavigated ) {
                _show( _iconGroup.childNodes[3] );
            } else {
                if ( _traverseNodeGrpIcon ) {
                    _hide( _iconGroup.childNodes[3] );
                }
            }
            if ( node.IsLeaf || node.ChildCount === 0 ) {
                _hide( _iconGroup.childNodes[1] );
                if ( node.IsLinked ) {
                    iconSvg = _linkedNodeGrpIcon;
                }
                else if ( !node.ParentId ) {
                    iconSvg = _rootIcon;
                }
                else {
                    iconSvg = _openFolderIcon;
                }
            } else {
                _show( _iconGroup.childNodes[1] );
                if ( node.IsLinked ) {
                    iconSvg = _linkedNodeGrpIcon;
                }
                else if ( !node.ParentId ) {
                    iconSvg = _rootIcon;
                }
                else if ( node.IsExpanded ) {
                    iconSvg = _openFolderIcon;
                }
                else {
                    iconSvg = _closedFolderIcon;
                }

                if ( node.IsExpanded ) {
                    _iconGroup.childNodes[1].childNodes[0].childNodes[0].setAttribute( 'points', '5 7 11.5 14 18 7 5 7' );
                } else {
                    _iconGroup.childNodes[1].childNodes[0].childNodes[0].setAttribute( 'points', '9 3 9 16 16 9.5 9 3' );
                }
            }
            if ( iconSvg ) {
                _mainIconSvg.removeChild( _mainIconSvg.firstChild );
                _mainIconSvg.appendChild( iconSvg );
            }
        }
        else {
            if ( _iconGroup ) {
                _hide( _iconGroup );
            }
            if ( _nodeText ) {
                _nodeText.textContent = '';
            }
            if ( _currRectColor === data.selectionColor ) { //Remove the selection color from the bgRect if the node data is not present.
                _bgRect.setAttribute( 'fill', _rectColor );
                _currRectColor = _rectColor;
            }
        }
    };
    this.setStyleForNode = function ( nodeProps, stylePropObj, i ) {
        var opacity = 1;

        _nodeGroup.TifProperties.item.selected = nodeProps.isSelected;
        if ( nodeProps.isSelected ) {
            if ( stylePropObj.SelectionBackColor ) {
                data.selectionColor = stylePropObj.SelectionBackColor;
            }
            if ( _nodeText && stylePropObj.SelectionForeColor ) {
                data.selectionForeColor = stylePropObj.SelectionForeColor;
            }
            _currRectColor = data.selectionColor;
            _setElementProp( _nodeText, 'fill', stylePropObj.SelectionForeColor );
            _setElementProp( _rootIcon, 'fill', stylePropObj.SelectionNodeIconColor );
            _setElementProp( _openFolderIcon, 'fill', stylePropObj.SelectionNodeIconColor );
            _setElementProp( _closedFolderIcon, 'fill', stylePropObj.SelectionNodeIconColor );
            _setElementProp( _linkedNodeGrpIcon, 'fill', stylePropObj.SelectionNodeIconColor );
            _setElementProp( _expandCollapseIcon, 'fill', stylePropObj.SelectionNodeIconColor );
            _setElementProp( _traverseNodeGrpIcon, 'fill', stylePropObj.SelectionNodeIconColor );
        } else {
            if ( i % 2 !== 0 ) {
                _rectColor = stylePropObj.grey3;
            } else {
                _rectColor = stylePropObj.white;
            }
            _currRectColor = _rectColor;
            _setElementProp( _nodeText, 'fill', stylePropObj.ForeColor );
            _setElementProp( _rootIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _openFolderIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _closedFolderIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _linkedNodeGrpIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _expandCollapseIcon, 'fill', stylePropObj.ForeColor );
            _setElementProp( _traverseNodeGrpIcon, 'fill', stylePropObj.ForeColor );
        }

        if ( !nodeProps.hasSearchText ) {
            opacity = 0.5;
        }

        _setNodeOpacity( [_nodeText, _rootIcon, _openFolderIcon, _closedFolderIcon, _linkedNodeGrpIcon, _expandCollapseIcon], opacity );

        _setElementProp( _bgRect, 'fill', _currRectColor );
        _setElementProp( _horizSeparatorLine, 'stroke', stylePropObj.HorizLineColor );

    };

    this.setStyleForAlarmNode = function ( isSelected, stylePropObj, i ) {
        if ( isSelected ) {
            if ( stylePropObj.SelectionBackColor ) {
                data.selectionColor = stylePropObj.SelectionBackColor;
            }
            _currRectColor = data.selectionColor;
            _setElementProp( _alarmSvgIcon, 'fill', stylePropObj.SelectionNodeIconColor );
        } else {
            if ( i % 2 !== 0 ) {
                _rectColor = stylePropObj.grey3;
            } else {
                _rectColor = stylePropObj.white;
            }
            _currRectColor = _rectColor;
            _setElementProp( _alarmSvgIcon, 'fill', stylePropObj.ForeColor );
        }
        _setElementProp( _alarmIconSeparatorRect, 'fill', _currRectColor );
        _setElementProp( _alarmSeparatorHorLine, 'stroke', stylePropObj.HorizLineColor );
        _setElementProp( _alarmSeparatorVertLine, 'stroke', stylePropObj.HorizLineColor );
    };

    this.createNodeIcon = function ( obj, viewportIndex ) {
        var nodeIconSvg, x = 0;
        if ( !_iconGroup ) {
            _iconGroup = CPM.svgUtil.createSVG( 'g', {
                id: 'treeGroup_iconGroup_' + data.index,
                appendTo: obj.nodeTextGroup,
                display: 'none'
            } );

            //Expand collapse icon
            CPM.svgUtil.createSVG( 'rect', {
                height: '25',
                width: '25',
                x: '-5',
                y: '0',
                stroke: 'none',
                fill: 'gray',
                'fill-opacity': '0.01',
                style: 'cursor: pointer',
                id: 'treeGroup_rect_expandCollapseIcon_' + data.index,
                appendTo: _iconGroup
            } );
            nodeIconSvg = CPM.svgUtil.createSVG( 'svg', {
                x: x,
                y: '8',
                appendTo: _iconGroup
            } );
            _arrowIconGrp = CPM.svgUtil.createSVG( 'g', {
                appendTo: nodeIconSvg
            } );

            _expandCollapseIcon = CPM.svgUtil.createSVG( 'polygon', {
                fill: _attrs.expandCollIconColor,
                style: 'cursor: pointer',
                id: 'treeGroup_path_expandCollapseIcon_' + data.index,
                appendTo: _arrowIconGrp
            } );
            CPM.svgUtil.createSVG( 'rect', {
                width: '24',
                height: '20',
                fill: 'black',
                'fill-opacity': 0,
                style: 'cursor: pointer',
                id: 'treeGroup_rect_expandCollapseIcon_' + data.index,
                appendTo: _arrowIconGrp
            } );

            // Plant object for root node 
            x = data.Left + CPM.Enums.Constants.horizontalgap;
            _mainIconSvg = CPM.svgUtil.createSVG( 'svg', {
                id: 'iconSvg',
                appendTo: _iconGroup
            } );
            _createRootIcon( _mainIconSvg, x, 4, _attrs.nodeIconColor );

            _openFolderIcon = CPM.svgUtil.createSVG( 'svg', {
                x: x,
                y: '4',
                fill: _attrs.nodeIconColor,
                id: 'OpenFolderIcon'
            } );
            _createOpenFolderIcon();
            _closedFolderIcon = CPM.svgUtil.createSVG( 'svg', {
                x: x,
                y: '4',
                fill: _attrs.nodeIconColor,
                id: 'ClosedFolderIcon'
            } );
            _createClosedFolderIcon();
            _linkedNodeGrpIcon = CPM.svgUtil.createSVG( 'svg', {
                x: x,
                y: '7',
                height: '22',
                width: '26',
                viewbox: '4 2 22 18',
                fill: _attrs.nodeIconColor,
                id: 'linkedNodeGrpIcon'
            } );
            _createlinkedNodeGrpIcon();            
        }
        if ( !_traverseNodeGrpIcon && viewportIndex === 0 && WebCC.Properties.NavigationType === CPM.Enums.NavigationType.Dynamic ) {
            _traverseNodeGrpIcon = CPM.svgUtil.createSVG('svg', {
                x: '-12',
                y: '10',
                id: 'traverseNodeGrpIcon',
                appendTo: _iconGroup
            });
            var traverseNodeGrp = CPM.svgUtil.createSVG('g', {
                appendTo: _traverseNodeGrpIcon
            });
            CPM.svgUtil.createSVG('rect', {
                width: '12',
                height: '16',
                y: '-2',
                fill: 'black',
                'fill-opacity': 0,
                style: 'cursor: pointer',
                id: 'traverseToParentIconBackgroundRect_' + data.index,
                appendTo: _traverseNodeGrpIcon
            });
            CPM.svgUtil.createSVG('path', {
                id: 'traverseToParentIconPolygon_' + data.index,
                fill: _attrs.expandCollIconColor,
                d: 'M6,0.03795 L11.801,6.99995 L9.198,6.99995 L6,3.16199994 L2.801,6.99995 L0.199,6.99995 L6,0.03795 Z',
                style: 'cursor: pointer',
                appendTo: traverseNodeGrp
            });
            CPM.svgUtil.createSVG('rect', {
                id: 'traverseToParentIconRect_' + data.index,
                x: '5',
                y: '2',
                width: '2',
                height: '10',
                fill: _attrs.expandCollIconColor,
                style: 'cursor: pointer',
                appendTo: traverseNodeGrp
            });
        }
    };

    this.createText = function ( obj, stylePropObj, i ) {
        if ( !_nodeText ) {
            _nodeText = CPM.svgUtil.createSVG( 'text', {
                style: 'cursor: default',
                display: 'block',
                appendTo: obj.nodeTextGroup
            } );
        }
        CPM.svgUtil.setAttr( _nodeText, {
            id: 'treeGroup_nodeText_' + i,
            x: obj.x,
            y: obj.y,
            'font-size': obj.font.Size,
            'fill': ( obj.isSelected && stylePropObj.SelectionForeColor ) ? stylePropObj.SelectionForeColor : stylePropObj.ForeColor,
            'font-style': obj.font.Italic ? 'italic' : 'normal',
            'font-family': obj.font.family
        } );
        _nodeText.textContent = obj.currText;
    };

    this.updateRectWidth = function ( rectWidth ) {
        _bgRect.setAttribute( 'width', rectWidth );
    };

    this.hideLastNode = function () {
        if ( _iconGroup ) {
            _hide( _iconGroup );
        }
        if ( _nodeText ) {
            _hide( _nodeText );
        }
    };

    this.hideLastAlarmNode = function () {
        _hide( _alarmIconGrp );
    };

    this.showLastNode = function () {
        if ( _nodeText && _nodeText.textContent ) {
            _show( _iconGroup );
            _show( _nodeText );
        }
    };

    this.changeAlarmState = function ( isActive ) {
        if ( isActive ) {
            _show( _alarmIconGrp );
        } else {
            _hide( _alarmIconGrp );
        }
    };

    this.changeAlarmSeperatorState = function ( width, lineColor, foreColor, y ) {
        _show( _alarmIconSeparatorGrp );
        _alarmIconSeparatorGrp.setAttribute( 'transform', 'translate(' + ( width ) + ',' + ( y ) + ')' );
        _alarmIconGrp.setAttribute( 'transform', 'translate(' + ( width + CPM.Enums.Constants.alarmIconLeftPadding ) + ',' + ( y + CPM.Enums.Constants.topPaddingAlarmIcon ) + ')' );
        _setElementProp( _alarmSeparatorVertLine, 'stroke', lineColor );
        _setElementProp( _alarmSeparatorVertLine, 'x', width );
        _setElementProp( _alarmSvgIcon, 'fill', foreColor );
    };

    this.updateSelectionBackColor = function ( color ) {
        _setElementProp( _bgRect, 'fill', color );
        _setElementProp( _alarmIconSeparatorRect, 'fill', color );
    };

    this.updateSelectionForeColor = function ( color ) {
        _setElementProp( _nodeText, 'fill', color );
    };

    this.updateNodeStyle = function ( stylePropObj, altBackFill, forAlarmIcon ) {
        if ( !forAlarmIcon ) {
            _setElementProp( _bgRect, 'fill', altBackFill );
            _setElementProp( _horizSeparatorLine, 'stroke', stylePropObj.HorizLineColor );
            _setElementProp( _nodeText, 'fill', stylePropObj.ForeColor );
            _setElementProp( _rootIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _openFolderIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _closedFolderIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _linkedNodeGrpIcon, 'fill', stylePropObj.NodeIconColor );
            _setElementProp( _expandCollapseIcon, 'fill', stylePropObj.ForeColor );
            _setElementProp( _traverseNodeGrpIcon, 'fill', stylePropObj.ForeColor );
        } else {
            _setElementProp( _alarmIconSeparatorRect, 'fill', altBackFill );
            _setElementProp( _alarmSeparatorHorLine, 'stroke', stylePropObj.HorizLineColor );
            _setElementProp( _alarmSeparatorVertLine, 'stroke', stylePropObj.HorizLineColor );
            _setElementProp( _alarmSvgIcon, 'fill', stylePropObj.ForeColor );
        }
    };
};