﻿/* 
* Copyright (C) Siemens AG 2013.
* All Rights Reserved. Confidential.
*
* @namespace CPM.Lib.ScrollButton
* @desc ScrollButton implementation in SVG.
*
*/
var CPM = ( CPM || {} );
CPM.Lib = ( CPM.Lib || {} );

//scrollbutton styles

//id,parentNode,scrollButtonProps,scrollButtonOrientation,currentStyle
CPM.Lib.ScrollButton = function (id, parentNode, scrollButtonProps, scrollButtonOrientation, currentStyle) {

    'use strict';
    // PRIVATE API
    var _id = id,
    _scrollButtonOrientation = scrollButtonOrientation,
     _stylePropObj = CPM.StyleFactory.getCurrentStyleProps(currentStyle),
    _isExtendedStyle = currentStyle === CPM.Enums.StyleName.Extended ? true : false,
    _scrollbarBackColor = _stylePropObj.ScrollBar.BgColor,
    _triangleFillColor = _stylePropObj.ScrollBar.TriangleFillColor,
    _triangleStrokeColor = _stylePropObj.ScrollBar.TriangleStrokeColor,
    _highlightColor = _stylePropObj.ScrollBar.HighlightColor,
    _disabledColor = _stylePropObj.ScrollBar.DisabledFillColor,
    _parentGroup = CPM.svgUtil.createSVG( 'g' ),
    _scrollRect = null,
    _scrollTriangle = null,
    
    //create scrollbutton geometry
    _createScrollbutton = function ( x, y, width, height ) {
        var myTriPath, triangleFourth, cellHeight, offsY = 0, offsX = 0, dataTifType;
        if ( height > width ) {
            offsY = ( height - width ) / 2;
            cellHeight = width;
        } else {
            offsX = ( width - height ) / 2;
            cellHeight = height;
        }
        //this is used to construct the triangles for the buttons
        triangleFourth = cellHeight / 4;
        if (_scrollButtonOrientation === 'vertical_up') {
            dataTifType = 'LineUp';
            if (_isExtendedStyle) {
                myTriPath = 'M' + (x + triangleFourth) + ' ' + (y + offsY + 3 * triangleFourth) + ' L' + (x + cellHeight * 0.5) + ' ' +
                   (y + offsY + triangleFourth) + ' L' + (x + 3 * triangleFourth) + ' ' + (y + offsY + 3 * triangleFourth) + ' Z';
            } else {
                myTriPath = 'M' + (x + triangleFourth) + ' ' + ((y + offsY + 3 * triangleFourth) - 2) + ' L' + (x + cellHeight * 0.5) + ' ' +
               (y + offsY + triangleFourth) + ' L' + (x + 3 * triangleFourth) + ' ' + ((y + offsY + 3 * triangleFourth) - 2);
            }
        } else if (_scrollButtonOrientation === 'vertical_down') {
            dataTifType = 'LineDown';
            if (_isExtendedStyle) {
                myTriPath = 'M' + (x + triangleFourth * 3) + ' ' + (y + offsY + triangleFourth) + ' L' + (x + cellHeight * 0.5) + ' ' +
                   (y + offsY + 3 * triangleFourth) + ' L' + (x + triangleFourth) + ' ' + (y + offsY + triangleFourth) + ' Z';

            } else {

                myTriPath = 'M' + (x + triangleFourth * 3) + ' ' + ((y + offsY + triangleFourth) + 2) + ' L' + (x + cellHeight * 0.5) + ' ' +
                       (y + offsY + 3 * triangleFourth) + ' L' + (x + triangleFourth) + ' ' + ((y + offsY + triangleFourth) + 2);

            }
        } else if (_scrollButtonOrientation === 'horizontal_up') {
            dataTifType = 'LineUp';
            if (_isExtendedStyle) {
                myTriPath = 'M' + (x + triangleFourth) + ' ' + (y + triangleFourth * 2) + ' L' + (x + 3 * triangleFourth) + ' ' +
                    (y + 3 * triangleFourth) + ' L' + (x + 3 * triangleFourth) + ' ' + (y + triangleFourth) + ' Z';
            }
            else {
                myTriPath = 'M' + ((x + 3 * triangleFourth) - 2) + ' ' + (y + triangleFourth) + 'L' + (x + triangleFourth) + ' ' + (y + triangleFourth * 2) + ' L' + ((x + 3 * triangleFourth) - 2) + ' ' +
             (y + 3 * triangleFourth);
            }
        } else {
            dataTifType = 'LineDown';
            if (_isExtendedStyle) {
                myTriPath = 'M' + (x + triangleFourth * 3) + ' ' + (y + 2 * triangleFourth) + ' L' + (x + triangleFourth) + ' ' +
                    (y + triangleFourth) + ' L' + (x + triangleFourth) + ' ' + (y + triangleFourth * 3) + ' Z';
            }
            else {
                myTriPath = 'M' + ((x + triangleFourth) + 2) + ' ' + (y + triangleFourth * 3) + ' L' + (x + triangleFourth * 3) + ' ' + (y + 2 * triangleFourth) + ' L' + ((x + triangleFourth) + 2) + ' ' +
              (y + triangleFourth);

            }
        }
        // rect
        _scrollRect = CPM.svgUtil.createSVG( 'rect', {
            id: _id,
            'data-tif-type': dataTifType,
            x: x,
            y: y,
            width: width,
            height: height,
            'fill-opacity': _stylePropObj.ScrollBar.Opacity,
            appendTo: _parentGroup
        } );
        //_scrollbarBackColor
        _scrollRect.setAttributeNS(null, 'fill', _scrollbarBackColor);
        _scrollTriangle = CPM.svgUtil.createSVG( 'path', {
            d: myTriPath,
            fill: _isExtendedStyle ? _stylePropObj.ScrollBar.TriangleColor : 'none',
            stroke: _stylePropObj.ScrollBar.TriangleColor,
            //'stroke-width': _stylePropObj.ScrollBar.StrokeWidth,
            'stroke-width': 2,
            'pointer-events': 'none',
             appendTo: _parentGroup
        } );
        //_triangleColor
        _scrollTriangle.setAttributeNS(null, 'fill', _triangleFillColor);
        _scrollTriangle.setAttributeNS(null, 'stroke', _triangleStrokeColor);
    };

    // INITIALIZER
    ( function () {
        //create scrollbutton
        if ( CPM.svgUtil.testParent( parentNode, _parentGroup ) ) {
            _createScrollbutton( scrollButtonProps.x, scrollButtonProps.y, scrollButtonProps.width, scrollButtonProps.height );
        }
    } )();

    // PUBLIC API
    return {
        onPointerDown: function () {
            //change appearance of triangle
            //_triangleColor
            _scrollTriangle.removeAttributeNS(null, 'fill');
            _scrollTriangle.removeAttributeNS(null, 'stroke');
            //_hightlightColor
            _scrollTriangle.setAttributeNS(null, 'fill', _highlightColor);
        },
        onPointerUp: function () {
            //change appearance of triangle
            //change appearance of triangle
            //_hightlightColor
            _scrollTriangle.removeAttributeNS(null, 'fill');
            //_trianglecolor
            _scrollTriangle.setAttributeNS(null, 'fill', _triangleFillColor);
            _scrollTriangle.setAttributeNS(null, 'stroke', _triangleStrokeColor);
        },
        updateScrollButton: function ( x, y, width, height ) {
            var myTriPath, triangleFourth, cellHeight, offsY = 0, offsX = 0, setAttributes = CPM.svgUtil.setAttr;
            if ( height > width ) {
                offsY = ( height - width ) / 2;
                cellHeight = width;
            } else {
                offsX = ( width - height ) / 2;
                cellHeight = height;
            }
            triangleFourth = cellHeight / 4;
            if (_scrollButtonOrientation === 'vertical_up') {
                if (_isExtendedStyle) {
                    myTriPath = 'M' + (x + triangleFourth) + ' ' + (y + offsY + 3 * triangleFourth) + ' L' + (x + cellHeight * 0.5) + ' ' +
                       (y + offsY + triangleFourth) + ' L' + (x + 3 * triangleFourth) + ' ' + (y + offsY + 3 * triangleFourth) + ' Z';
                } else {
                    myTriPath = 'M' + (x + triangleFourth) + ' ' + ((y + offsY + 3 * triangleFourth) - 2) + ' L' + (x + cellHeight * 0.5) + ' ' +
                   (y + offsY + triangleFourth) + ' L' + (x + 3 * triangleFourth) + ' ' + ((y + offsY + 3 * triangleFourth) - 2);
                }
            } else if (_scrollButtonOrientation === 'vertical_down') {
                if (_isExtendedStyle) {
                    myTriPath = 'M' + (x + triangleFourth * 3) + ' ' + (y + offsY + triangleFourth) + ' L' + (x + cellHeight * 0.5) + ' ' +
                       (y + offsY + 3 * triangleFourth) + ' L' + (x + triangleFourth) + ' ' + (y + offsY + triangleFourth) + ' Z';

                } else {

                    myTriPath = 'M' + (x + triangleFourth * 3) + ' ' + ((y + offsY + triangleFourth) + 2) + ' L' + (x + cellHeight * 0.5) + ' ' +
                           (y + offsY + 3 * triangleFourth) + ' L' + (x + triangleFourth) + ' ' + ((y + offsY + triangleFourth) + 2);

                }
            } else if (_scrollButtonOrientation === 'horizontal_up') {
                if (_isExtendedStyle) {
                    myTriPath = 'M' + (x + triangleFourth) + ' ' + (y + triangleFourth * 2) + ' L' + (x + 3 * triangleFourth) + ' ' +
                        (y + 3 * triangleFourth) + ' L' + (x + 3 * triangleFourth) + ' ' + (y + triangleFourth) + ' Z';
                }
                else {
                    myTriPath = 'M' + ((x + 3 * triangleFourth) - 2) + ' ' + (y + triangleFourth) + 'L' + (x + triangleFourth) + ' ' + (y + triangleFourth * 2) + ' L' + ((x + 3 * triangleFourth) - 2) + ' ' +
                 (y + 3 * triangleFourth);
                }
            } else {
                if (_isExtendedStyle) {
                    myTriPath = 'M' + (x + triangleFourth * 3) + ' ' + (y + 2 * triangleFourth) + ' L' + (x + triangleFourth) + ' ' +
                        (y + triangleFourth) + ' L' + (x + triangleFourth) + ' ' + (y + triangleFourth * 3) + ' Z';
                }
                else {
                    myTriPath = 'M' + ((x + triangleFourth) + 2) + ' ' + (y + triangleFourth * 3) + ' L' + (x + triangleFourth * 3) + ' ' + (y + 2 * triangleFourth) + ' L' + ((x + triangleFourth) + 2) + ' ' +
                  (y + triangleFourth);

                }
            }
            setAttributes( _scrollRect, {
                x: x,
                y: y,
                width: width,
                height: height
            } );
            setAttributes( _scrollTriangle, {
                d: myTriPath,
                fill: _isExtendedStyle ? _stylePropObj.ScrollBar.TriangleColor : 'none',
                stroke: _stylePropObj.ScrollBar.TriangleColor,
                //'stroke-width': _stylePropObj.ScrollBar.StrokeWidth,
                'stroke-width': 2,
                'pointer-events': 'none'
            } );
        },
        hide: function () {
            _parentGroup.setAttributeNS( null, 'display', 'none' );
        },
        show: function () {
            _parentGroup.setAttributeNS( null, 'display', 'inherit' );
        },
        remove: function () {
            _parentGroup.parentNode.removeChild( _parentGroup );
        },
        enable: function () {
            //_disabledColor
            _scrollRect.removeAttributeNS(null, 'fill');
            //_scrollbarBackColor
            _scrollRect.setAttributeNS(null, 'fill', _scrollbarBackColor);
        },
        disable: function () {
            //_scrollbarBackColor
            _scrollRect.removeAttributeNS(null, 'fill', _scrollbarBackColor);
            //_disabledColor
            _scrollRect.setAttributeNS(null, 'fill', _disabledColor);
        },
        updateColor: function () {
            _scrollRect.setAttributeNS(null, 'fill', _scrollbarBackColor);
        }
    };
};