/*
* Copyright (C) Siemens AG 2016.
* All Rights Reserved. Confidential.
*
* Descr.:  Handles all the TimesliceHandler functionality.
* <Description>
*
* Authors: Ambika Jadhav ambika@siemens.com)
* Authors: Rama Reddy (satyasairama.reddy@siemens.com)
*/
/**
* @fileOverview timeslicehandler.js.
* @author Ambika Jadhav
* @author Rama Reddy
*/
/**
* Namespace for TimesliceHandler.
* @namespace CPM.Control
*/
var CPM = CPM || {};
CPM.Control = CPM.Control || {};
/**
* Creates an instance of TimesliceHandler.
* @class
* @desc Class representing the timeslicehandler object.
* @constructor
*/
CPM.Control.ScrollHandler = function () {
    'use strict';
    /**
    * Private members.
    */
    var _settings = null,
        _bgRect = null,
        _isHorizontal,
        _stylePropObj,
        _scrollBarRef = {
            id: null,
            width: 0,
            height: 0,
            x: 0,
            y: 0,
            instance: null,
            visible: false,
            columnStartIndex: 0,
            borderLine: null,
            scrolledValue: 0,
            scrollEnd: 0,
            isScrollMove: false,
            parentNode: null,
            startValue: 0,
            endValue: 0,
            initialHeightPerc: 0,
            initialOffset: 0,
            scrollStep: 0,
            scrollButtonLocations: '',
            functionToCall: null
        },
        _createBgRect = function () {
            _bgRect = CPM.svgUtil.createSVG( 'rect', {
                x: _scrollBarRef.x,
                y: _scrollBarRef.y,
                height: _scrollBarRef.height,
                width: _settings.width,
                fill: _stylePropObj.ScrollBar.BgColor,
                'shape-rendering': 'crispEdges',
                stroke: 'none',
                'fill-opacity': 0,
                appendTo: _scrollBarRef.parentNode
            } );
        };
    this.createScrollBar = function (areaSettings, left, top, parent, scrollbarCallBack, isHorizontal, horizontalLine) {
        _settings = areaSettings;
        _scrollBarRef.parentNode = parent;
        _isHorizontal = isHorizontal;
        _stylePropObj = CPM.StyleFactory.getCurrentStyleProps( areaSettings.currentStyle );
        _scrollBarRef.x = left;
        _scrollBarRef.y = top;
        if ( isHorizontal ) {
            _scrollBarRef.width = _settings.width;
            _scrollBarRef.height = _settings.height;
            _scrollBarRef.id = 'hScrollbar';

            _scrollBarRef.startValue = 0;
            _scrollBarRef.endValue = _settings.endValue;//areaSettings.cellSettings.actualCount - areaSettings.cellSettings.countForEachRow;
            _scrollBarRef.initialHeightPerc = _settings.initialHeightPerc;//areaSettings.cellSettings.countForEachRow / areaSettings.cellSettings.actualCount;
            _scrollBarRef.initialOffset = 0;
            if ( _settings.initialScrollOffset ) {
                _scrollBarRef.initialOffset = _settings.initialScrollOffset;//areaSettings.verticalScrollIndex / _scrollBarRef.endValue;
            }
            //_scrollBarRef.initialOffset = _scrollBarRef.scrolledValue;
            _scrollBarRef.scrollStep = _settings.scrollStep;// / ( areaSettings.cellSettings.actualCount - areaSettings.cellSettings.countForEachRow );
            _scrollBarRef.scrollButtonLocations = 'top_bottom';
        }
        else {
            //_scrollBarRef.width = _settings.horizontalSliderHeight;
            _scrollBarRef.width = _settings.width;
            _scrollBarRef.height = _settings.height;
            _scrollBarRef.id = _settings.id + 'vScrollbar';

            _scrollBarRef.startValue = 0;
            _scrollBarRef.endValue = _settings.endValue;//areaSettings.rowCount - areaSettings.maxRowCount;

            _scrollBarRef.initialOffset = 0;
            if ( _settings.initialScrollOffset ) {
                _scrollBarRef.initialOffset = _settings.initialScrollOffset;//areaSettings.verticalScrollIndex / _scrollBarRef.endValue;
            }

            //_scrollBarRef.initialOffset = areaSettings.verticalScrollIndex;
            _scrollBarRef.initialHeightPerc = _settings.initialHeightPerc;//( areaSettings.maxRowCount / areaSettings.rowCount );
            _scrollBarRef.scrollStep = _settings.scrollStep;// / ( areaSettings.rowCount - areaSettings.maxRowCount );
            _scrollBarRef.scrollButtonLocations = 'top_bottom';
            _scrollBarRef.isScrollMove = true;

        }
        _scrollBarRef.functionToCall = scrollbarCallBack;
        _createBgRect();
        _scrollBarRef.instance = new CPM.Lib.ScrollBar(_scrollBarRef, _settings.currentStyle, horizontalLine);
    };
    this.onScrollEvent = function ( mousePosWrtArea, targetGroup, evt, targetNode ) {
        var x = mousePosWrtArea.x,
        y = mousePosWrtArea.y;
        switch ( evt.type ) {
            case 'panstart':
            case 'mousedown':
            case 'touchstart':
                _scrollBarRef.instance.onPointerDown( x, y, targetNode );
                break;
            case 'pan':
            case 'panright':
            case 'panleft':
            case 'panup':
            case 'pandown':
            case 'mousemove':
                if ( ( _isHorizontal && ( evt.type !== 'panup' && evt.type !== 'pandown' ) ) ) {
                    _scrollBarRef.instance.onPointerMove( x, y, targetNode );
                }
                else {
                    if ( ( !_isHorizontal && ( evt.type !== 'panright' && evt.type !== 'panleft' ) ) ) {
                        _scrollBarRef.instance.onPointerMove( x, y, targetNode );
                    }
                }
                break;
            case 'panend':
            case 'mouseup':
            case 'touchend':
                _scrollBarRef.instance.onPointerUp( x, y );
                break;
            default:
                break;
        }
    };
    this.onScrollClickEvent = function ( mousePosWrtArea, targetGroup, evt, targetNode ) {
        var x = _scrollBarRef.x + mousePosWrtArea.x,
       y = _scrollBarRef.y + mousePosWrtArea.y;
        switch ( evt.type ) {
            case 'panstart':
            case 'touchstart':
            case 'mousedown':
                _scrollBarRef.instance.onPointerDown( x, y, targetNode );
                break;
            case 'panend':
            case 'touchend':
            case 'mouseup':
                _scrollBarRef.instance.onPointerUp( x, y );
                break;
            default:
                break;
        }
    };
    this.remove = function () {
        _scrollBarRef.parentNode.removeChild( _bgRect );
        //_bgRect.remove();
        _scrollBarRef.instance.remove();
    };
};