       /**
       * Creates an instance of TreeImplementor
       * @class
       * @desc Class for creating TreeImplementor
       * @constructor
       */
var TreeImplementor = function () {
    /**
    * Private members.
    */
    var
        /**
        * @memberOf TreeImplementor
        * Hold reference to array of callbacks
        */
        _callbacks = [],
        /**
        * @memberOf TreeImplementor
        * Hold reference to tree control
        */
        _tree = null,
        /**
        * @memberOf TreeImplementor
        * Holds information about offset width
        */
        _offsetWidth = 0,
        /**
        * @memberOf TreeImplementor
        * Holds information about offset width
        */
        _offsetHeight = 2,
        /**
        * @memberOf TreeImplementor
        * Holds information about container and directory
        */
        _options = { rootDir: '', svgParent: null, domParent: null, zoom: 0, width: 0, height: 0 },
        // Event handling
        /**
        * function to call all callbacks on property change
        * @param {data} object
        */
        _fireEvent = function (data) {
            for (var i = 0; i < _callbacks.length; i++) {
                _callbacks[i](data);
            }
        },
        /**
        * HostListener function to register callbacks at the time of WebCC initialization
        * @param {data} object
        */
        _subscribe_in = function (callback) {
            _callbacks.push(callback);
        },
        // HostListener methods
        /**
        * HostListener function to expand all nodes
        */
        _expand = function () {
            if (_tree != null) {
                _tree.expand();
                return 'expanded';
            }
        },
        /**
        * HostListener function to collapse all nodes
        */
        _collapse = function () {
            if (_tree != null) {
                _tree.collapse();
                return 'collapsed';
            }
        },
        /**
        * HostListener function to create Hierarchy node
        * @param {data} object
        */
        _createHierarchyNode = function (data) {
            var nodeData = {};
            if (data.DisplayNameArray instanceof Array && data.ViewNodeIdArray instanceof Array) {
                nodeData.Name = data.DisplayNameArray[0];
                nodeData.Id = data.ViewNodeIdArray[0];
                _tree.createHierarchyNode(nodeData);
            }
        },
        /**
        * HostListener function to add multiple nodes
        * @param {data} object
        */
        _loadNodes = function (data) {
            //var st = Date.now();
            _tree.loadNodes(data);
        },

        _addNewNodes = function (data, isBreadCrumbReq, isBufferData) {
            if (isBreadCrumbReq) {
                _tree.loadBreadCrumb(data);
            } else {
                _tree.addNewNodes(data, isBufferData);
            }

        },
        /**
        * HostListener function to add node
        * @param {name} string
        * @param {id} string
        * @param {objectType} string
        * @param {isExpanded} bool
        * @param {isLeaf} bool
        * @param {visible} bool
        */
        _addNewNode = function (name, id, objectType) {
            var node = {
                Name: name,
                Id: id,
                ObjectType: objectType,
                //IsExpanded: isExpanded,
                //IsLeaf: isLeaf,
                //Visible: visible,
                //Children: [],
                Parent: WebCC.Properties.SelectedNode
            };
            _tree.loadNodes([node]);
            return name + ' added suceessfully'
        },
        /**
        * HostListener function to remove selected node
        */
        _removeNode = function () {
            var name = WebCC.Properties.SelectedNode;
            _tree.removeNode(name);
            return name + ' removed suceessfully'
        },
        /**
        * Callback to be called from controller on property change
        */
        _propertyChangeCallback = function (arguments) {
            var paramIds,
                paramValues,
                mode;

            WebCC.Properties.SelectedNode = arguments.name;
            if (arguments.isRequestData) {
                if (arguments.isHierarchyNode) {
                    mode = CPM.Enums.BrowsingMode.ViewRoot;
                }
                else {
                    mode = CPM.Enums.BrowsingMode.ViewNode;
                }
                paramIds = [CPM.Enums.ObjectCountAttributes.Requested, CPM.Enums.ObjectCountAttributes.TreeOrList, CPM.Enums.ObjectCountAttributes.SystemId, CPM.Enums.ObjectCountAttributes.ObjectId, CPM.Enums.ObjectCountAttributes.SelectedNode, CPM.Enums.ObjectCountAttributes.NameFilter,
                CPM.Enums.ObjectCountAttributes.PropertyFilter, CPM.Enums.ObjectCountAttributes.LanguageId, CPM.Enums.ObjectCountAttributes.BrowsingMode, CPM.Enums.ObjectCountAttributes.SortingMode, CPM.Enums.ObjectCountAttributes.SortByAttribute];
                paramValues = [1, CPM.Enums.View.Tree, 0, undefined, arguments.id, undefined, undefined, CPM.Enums.Language.English, mode, undefined]; //4 == VIEWROOT
                WebCC.Extensions.HMI.DomainLogic.sendDLEvent(paramIds, paramValues);
            }

        },
        /**
        * function to get iframe width
        * return {height}int
        */
        _getWidth = function () {
            var width = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
            return width;
        },
        /**
        * function to get iframe height
        * return {height}int
        */
        _getHeight = function () {
            var height = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
            return height;
        },
        /**
        * function to register as a callback. fires on resizing window
        */
        _doResize = function () {
            var width = _getWidth(),
                height = _getHeight();
            _tree.updateView(height - _offsetHeight, width - _offsetWidth);
        },
        // Local methods
        /**
        * function to initialize tree control
        */
        _initialize = function () {
            var iframeElem, iframeElemArray = [], elem, cpmDiv = [];
            if (_tree === null) {
                iframeElemArray = window.parent.document.getElementsByTagName('iFrame');
                try {
                    for (elem in iframeElemArray) {
                        if ( iframeElemArray.hasOwnProperty( elem ) ) {
                            iframeElem = iframeElemArray[elem];
                            //Exception in iPad handled, to avoid firing of resize event for iframe's scrollbar
                            iframeElem.setAttribute('scrolling', 'no');
                            if (iframeElem.contentDocument) {
                                cpmDiv = iframeElem.contentDocument.getElementsByClassName('cpmDiv')[0];
                                if (cpmDiv) {
                                    iframeElem.style.position = '';
                                }
                            }
                        }
                    }
                }
                catch (exec) {
                    //Swac exception only in IE.
                }
                _options.svgParent = document.getElementById('Main_SVG');
                _options.domParent = document.getElementById('CPM_Main_Div');
                _options.divParent = document.getElementById('divParent');
                _options.width = _getWidth();
                _options.height = _getHeight() - _offsetHeight;
                _options.svgParent.setAttribute('width', (_options.width - _offsetWidth));
                _options.svgParent.setAttribute('height', (_options.height));
                _options.divParent.setAttribute('width', (_options.width + 4) + 'px');
                _options.divParent.setAttribute('height', (_options.height + 4) + 'px');
                _options.SelectionBackColor = WebCC.Properties.SelectionBackColor;
                _options.SelectionForeColor = WebCC.Properties.SelectionForeColor;
                _options.SelectedNodePath = WebCC.Properties.SelectedNode;
                _options.NavigationType = WebCC.Properties.NavigationType;
                _options.Companions = WebCC.Properties.Companions;
                _options.Filter = WebCC.Properties.Filter;
                _options.rtoId = WebCC._internal.containerInfo.name;
                _options.Enabled = WebCC.Extensions.HMI.Properties.Enabled;
                _options.ShowBreadCrumb = WebCC.Properties.ShowBreadCrumb;
                _options.ShowToolBar = WebCC.Properties.ShowToolBar;
                _options.RootNode = WebCC.Properties.RootNode;
                _options.svgParent.setAttribute('data-rtoid', _options.rtoId);
                _tree = new CPM.Tree();
                _tree.createTree(_options);
                window.addEventListener("resize", _doResize);
                _tree.on(_propertyChangeCallback);
            }
        },
        _propChange = function (data) {
            _tree.updateProperties(data);
        },
        _handleAlarmData = function (data) {
            _tree.handleAlarmData(data);
        },
        _handleScreenData = function (data) {
            _tree.handleScreenData(data);
        },
        _disableToolbarButtons = function () {
            _tree.disableToolbarButtons();
        },
        _handleLanguageChange = function (data) {
            _tree.handleLanguageChange(data);
        },
        _handleStyleChange = function (currentStyle) {
            if (currentStyle) { //Work around added for now, if a particular style is set in ES, switching from other style to ES set style in prepending device name as eg. HMI_RT_1::ExtendedStyle
                if (currentStyle.indexOf(':') !== -1) {
                    currentStyle = currentStyle.split('::')[1];
                }
                if (_tree !== null) {
                    _tree.handleStyleChange(currentStyle);
                }
                _options.currentStyle = currentStyle;
            }
        };

    return {
        Local: {
            Initialize: _initialize,
            createHierarchyNode: _createHierarchyNode,
            loadNodes: _loadNodes,
            addNewNodes: _addNewNodes,
            propChange: _propChange,
            HandleAlarmData: _handleAlarmData,
            HandleScreenData: _handleScreenData,
            HandleLanguageChange: _handleLanguageChange,
            DisableToolbarButtons: _disableToolbarButtons,
            HandleStyleChange: _handleStyleChange
        },
        HostListener: {
            //////////
            // API
            expand: _expand,
            collapse: _collapse,
            addNewNode: _addNewNode,
            removeNode: _removeNode,
            //////////
            // EVENTS ("Subscribable": an object with at least a subscribe-function, which accepts one argument)
            events: ['onSelectionChanged', 'onExpand', 'onExpandAll', 'onCollapse', 'onCollapseAll'],
            //////////
            properties: {
                RootNode: '',
                SelectedNode: '',
                SelectionBackColor: 0,
                SelectionForeColor: 0,
                Companions: [
                    //{
                    //    'ControlType': 'AlarmControl',
                    //    'ControlRef': 'AlarmControl',
                    //    CompanionConfig: {
                    //        ShowAlarmSummary: true,
                    //        AlarmClassFilter: 'AlarmClassName = \'CPMAlarm\''
                    //    }
                    //}
                ],
                Filter: 0,
                ShowToolBar: true,
                ShowBreadCrumb: true,
                NavigationType: 0
            }
        }
    };
}();

var initializeControl = function (result) {
    if (result) {
        try { //Added try catch block to avoid the control going complately blank.
            WebCC.Extensions.HMI.DomainLogic.onDLSendData.subscribe(function (value) {
                var typeReceived = value.data.id, paramIds, paramValues;
                switch (typeReceived) {
                    case CPM.Enums.DataRecievedType.SetViewPort:
                        paramIds = [0];
                        paramValues = [CPM.Enums.BrowsingMode.Hierarchies];
                        WebCC.Extensions.HMI.DomainLogic.sendDLEvent(paramIds, paramValues);
                        break;
                    case CPM.Enums.DataRecievedType.Hierarchies: //Heirarchies data
                        if (value.data.data.DisplayNameArray.length > 1) {
                            TreeImplementor.Local.createHierarchyNode(value.data.data);
                        }
                        else {
                            if (value.data.data.DisplayNameArray.length === 0) {//No tree configured. Disable the toolbar buttons in this case.
                                TreeImplementor.Local.DisableToolbarButtons();
                            }
                            paramIds = [CPM.Enums.ObjectCountAttributes.Requested, CPM.Enums.ObjectCountAttributes.TreeOrList, CPM.Enums.ObjectCountAttributes.SystemId, CPM.Enums.ObjectCountAttributes.ObjectId, CPM.Enums.ObjectCountAttributes.SelectedNode, CPM.Enums.ObjectCountAttributes.NameFilter,
                            CPM.Enums.ObjectCountAttributes.PropertyFilter, CPM.Enums.ObjectCountAttributes.LanguageId, CPM.Enums.ObjectCountAttributes.BrowsingMode, CPM.Enums.ObjectCountAttributes.SortingMode, CPM.Enums.ObjectCountAttributes.SortByAttribute];
                            paramValues = [1, CPM.Enums.View.Tree, 0, undefined, value.data.data.ItemIdArray[0], undefined, undefined, CPM.Enums.Language.English, CPM.Enums.BrowsingMode.ViewRoot, undefined]; //4 == VIEWROOT
                            WebCC.Extensions.HMI.DomainLogic.sendDLEvent(paramIds, paramValues);
                        }
                        break;
                    case CPM.Enums.DataRecievedType.RootOrNode: //ViewRoot or ViewNodes data
                    case CPM.Enums.DataRecievedType.ExpandAll:
                    case CPM.Enums.DataRecievedType.ExpandAllForNode:
                        if (value.data.data.DisplayData !== null) {
                            if (typeReceived === CPM.Enums.DataRecievedType.ExpandAllForNode) {
                                //Here we receive the selected node data also which is already loaded on UI. So we take only its children(available at index 6) and load them.
                                TreeImplementor.Local.loadNodes(value.data.data.DisplayData[0][6]);
                            } else {
                                TreeImplementor.Local.loadNodes(value.data.data.DisplayData);
                            }
                            TreeImplementor.Local.propChange({ key: 'Companions', value: WebCC.Properties.Companions });
                            TreeImplementor.Local.propChange({ key: 'SelectionBackColor', value: WebCC.Properties.SelectionBackColor });
                            TreeImplementor.Local.propChange({ key: 'SelectedNode', value: WebCC.Properties.SelectedNode });
                            TreeImplementor.Local.propChange({ key: 'SelectionForeColor', value: WebCC.Properties.SelectionForeColor });
                        }
                        break;
                    case CPM.Enums.DataRecievedType.Scroll:
                        if (value.data.data.DisplayData !== null) {
                            TreeImplementor.Local.addNewNodes(value.data.data, false, true);
                        }
                        break;
                    case CPM.Enums.DataRecievedType.NodeCount: //Object Count
                        paramIds = [CPM.Enums.DataAttributes.Requested, CPM.Enums.DataAttributes.TreeOrList, CPM.Enums.DataAttributes.StartIndex, CPM.Enums.DataAttributes.EndIndex];
                        paramValues = [8, CPM.Enums.View.List, 0, value.data.data.ObjectCount];
                        WebCC.Extensions.HMI.DomainLogic.sendDLEvent(paramIds, paramValues);
                        break;
                    case CPM.Enums.DataRecievedType.BreadCrumbData: //ViewRoot or ViewNodes data
                        if (value.data.data.DisplayData !== null) {
                            TreeImplementor.Local.addNewNodes(value.data.data.DisplayData, true);
                        }
                        break;
                    case CPM.Enums.DataRecievedType.AlarmSummary:
                        if (value.data.data !== null) {
                            TreeImplementor.Local.HandleAlarmData(value.data.data);
                        }
                        break;
                    case CPM.Enums.DataRecievedType.ScreenWindowNode:
                        if (value.data.data && value.data.data.ScreenFilter !== null) {
                            TreeImplementor.Local.HandleScreenData(value.data.data);
                        }
                        break;
                    case CPM.Enums.DataRecievedType.LanguageChange:
                        if (value.data.data && value.data.data.LanguageId !== null) {
                            TreeImplementor.Local.HandleLanguageChange(value.data.data.LanguageId);
                        }
                        break;
                    default:
                        break;
                }
            });

            WebCC.onPropertyChanged.subscribe(TreeImplementor.Local.propChange);
            WebCC.Extensions.HMI.Properties.onPropertyChanged.subscribe(TreeImplementor.Local.propChange);
            TreeImplementor.Local.HandleStyleChange(WebCC.Extensions.HMI.Style.Name);
            WebCC.Extensions.HMI.Style.onChanged.subscribe(TreeImplementor.Local.HandleStyleChange);
            //First time ask for all Hierarchies
            var paramIds, paramValues, vpNodesCount;


            paramIds = [0];
            paramValues = [14];
            WebCC.Extensions.HMI.DomainLogic.sendDLEvent(paramIds, paramValues);

            TreeImplementor.Local.Initialize();
        }
        catch (error) {
            console.log(error);
        }
    }
}
// Lifecycle
/**
* WebCC initialization. onsucess,control will initialize.
*/
WebCC.start(
    initializeControl,
    TreeImplementor.HostListener,
    ['HMI', 'X_Textbib', 'X_SiemensFont'],
    // timeout
    10000
);