/* Copyright (C) Siemens AG 2013.
* All Rights Reserved. Confidential.
*
* Descr.:  Creates an instance of svg combo box
*          and handles all the functionality related to the combo box.
* <Description>
*
* Authors: Aalok Gokhale (aalok.gokhale@siemens.com)

/**
* Namespace for ComboBox.
* @namespace PWC.HmiAC
*/

var CPM = (CPM || {});

/**
* Creates an instance of ComboBox.
* @class
* @desc Class representing the svg combo box.
* @constructor
*/
CPM.ComboBoxHandler = function (svgParent) {
    var _svgParent = svgParent;
    this.styleGuideGradGroup = null;
    this.getControlName = 'CPM_';
    this.id = "CPM_Gradient_"
    this.getGuideStyles = function ( styleGuideGradient ) {

        var createSVGElement = CPM.svgUtil.createSVG,
            linearGrad,
            stopElement,
            styleGuideGradients = CPM.Enums.ComboGradients,
            id = '';

        this.styleGuideGradPresent = ( this.styleGuideGradPresent || {} );
        if (!this.styleGuideGradGroup) {
            this.styleGuideGradGroup = createSVGElement('g', {
                'id': this.getControlName + 'StyleGuideGradientGroup'
            });
            createSVGElement('defs',
            {
                'id': 'defs_' + this.getControlName + 'StyleGuideGradientGroup', 'appendTo': this.styleGuideGradGroup
            });
            _svgParent.appendChild(this.styleGuideGradGroup);
        }
        switch ( styleGuideGradient ) {
            case styleGuideGradients.IOFieldNormal:
                if ( this.styleGuideGradPresent.IOFieldNormal ) {
                    id = this.styleGuideGradPresent.IOFieldNormal;
                } else {
                    id = this.styleGuideGradPresent.IOFieldNormal = this.id + '_IOFieldNormal_Gradient';
                    linearGrad = createSVGElement( 'linearGradient' );
                    linearGrad.setAttributeNS( null, 'id', id );
                    linearGrad.setAttributeNS( null, 'x1', '0%' );
                    linearGrad.setAttributeNS( null, 'x2', '0%' );
                    linearGrad.setAttributeNS( null, 'y1', '0%' );
                    linearGrad.setAttributeNS( null, 'y2', '100%' );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '0%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#E6E6EB' );
                    linearGrad.appendChild( stopElement );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '15%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#FFFFFF' );
                    linearGrad.appendChild( stopElement );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '85%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#FFFFFF' );
                    linearGrad.appendChild( stopElement );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '100%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#E6E6EB' );
                    linearGrad.appendChild( stopElement );

                    this.styleGuideGradGroup.appendChild( linearGrad );
                }
                break;
            case styleGuideGradients.ButtonNormal:
                if ( this.styleGuideGradPresent.ButtonNormal ) {
                    id = this.styleGuideGradPresent.ButtonNormal;
                } else {
                    id = this.styleGuideGradPresent.ButtonNormal = this.id + '_ButtonNormal_Gradient';
                    linearGrad = createSVGElement( 'linearGradient' );
                    linearGrad.setAttributeNS( null, 'id', id );
                    linearGrad.setAttributeNS( null, 'x1', '0%' );
                    linearGrad.setAttributeNS( null, 'x2', '0%' );
                    linearGrad.setAttributeNS( null, 'y1', '0%' );
                    linearGrad.setAttributeNS( null, 'y2', '100%' );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '0%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#F2F4FF' );
                    linearGrad.appendChild( stopElement );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '100%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#91939A' );
                    linearGrad.appendChild( stopElement );

                    this.styleGuideGradGroup.appendChild( linearGrad );
                }
                break;
            case styleGuideGradients.ButtonPressed:
                if ( this.styleGuideGradPresent.ButtonPressed ) {
                    id = this.styleGuideGradPresent.ButtonPressed;
                } else {
                    id = this.styleGuideGradPresent.ButtonPressed = this.id + '_ButtonPressed_Gradient';
                    linearGrad = createSVGElement( 'linearGradient' );
                    linearGrad.setAttributeNS( null, 'id', id );
                    linearGrad.setAttributeNS( null, 'x1', '0%' );
                    linearGrad.setAttributeNS( null, 'x2', '0%' );
                    linearGrad.setAttributeNS( null, 'y1', '0%' );
                    linearGrad.setAttributeNS( null, 'y2', '100%' );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '0%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#91939A' );
                    linearGrad.appendChild( stopElement );

                    stopElement = createSVGElement( 'stop' );
                    stopElement.setAttributeNS( null, 'offset', '100%' );
                    stopElement.setAttributeNS( null, 'stop-color', '#F2F4FF' );
                    linearGrad.appendChild( stopElement );
                    this.styleGuideGradGroup.appendChild( linearGrad );
                }
                break;
            default:
                id = '';
                break;
        }
        return 'url(#' + id + ')';
    }
}